/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.Specification;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.compat.Bi_1To1_JT;
import org.apache.openjpa.persistence.compat.Bi_1ToM_FK;
import org.apache.openjpa.persistence.compat.Bi_1ToM_JT;
import org.apache.openjpa.persistence.compat.Bi_1ToM_Map_JT;
import org.apache.openjpa.persistence.compat.Bi_1ToM_Map_RelKey_JT;
import org.apache.openjpa.persistence.compat.EntityA;
import org.apache.openjpa.persistence.compat.EntityB;
import org.apache.openjpa.persistence.compat.EntityC;
import org.apache.openjpa.persistence.compat.EntityC_B11JT;
import org.apache.openjpa.persistence.compat.EntityC_B1MFK;
import org.apache.openjpa.persistence.compat.EntityC_B1MJT;
import org.apache.openjpa.persistence.compat.EntityC_B1M_Map_JT;
import org.apache.openjpa.persistence.compat.EntityC_B1M_Map_RelKey_JT;
import org.apache.openjpa.persistence.compat.EntityC_U11JT;
import org.apache.openjpa.persistence.compat.EntityC_U1MFK;
import org.apache.openjpa.persistence.compat.EntityC_U1M_Map_FK;
import org.apache.openjpa.persistence.compat.EntityC_U1M_Map_RelKey_FK;
import org.apache.openjpa.persistence.compat.MappedSuper;
import org.apache.openjpa.persistence.compat.Uni_1To1_JT;
import org.apache.openjpa.persistence.compat.Uni_1ToM_FK;
import org.apache.openjpa.persistence.compat.Uni_1ToM_JT;
import org.apache.openjpa.persistence.compat.Uni_1ToM_Map_FK;
import org.apache.openjpa.persistence.compat.Uni_1ToM_Map_RelKey_FK;
import org.apache.openjpa.persistence.compat.Uni_MTo1_JT;
import org.apache.openjpa.persistence.jdbc.SQLSniffer;
import org.apache.openjpa.persistence.test.ContainerEMFTest;

public class TestContainerSpecCompatibilityOptions
extends ContainerEMFTest {
    protected List<String> sql = new ArrayList<String>();
    protected int sqlCount;

    @Override
    public String getPersistenceResourceName() {
        return "org/apache/openjpa/persistence/compat/persistence_2_0.xml";
    }

    @Override
    public String getPersistenceUnitName() {
        return "persistence_2_0";
    }

    public void testJPA1CompatibilityOptions() {
        OpenJPAEntityManagerFactorySPI emf1 = this.createContainerEMF("persistence_1_0", "org/apache/openjpa/persistence/compat/persistence_1_0.xml", null);
        Compatibility compat = emf1.getConfiguration().getCompatibilityInstance();
        TestContainerSpecCompatibilityOptions.assertTrue((boolean)compat.getFlushBeforeDetach());
        TestContainerSpecCompatibilityOptions.assertTrue((boolean)compat.getCopyOnDetach());
        TestContainerSpecCompatibilityOptions.assertTrue((boolean)compat.getIgnoreDetachedStateFieldForProxySerialization());
        TestContainerSpecCompatibilityOptions.assertTrue((boolean)compat.getPrivatePersistentProperties());
        TestContainerSpecCompatibilityOptions.assertFalse((boolean)compat.isAbstractMappingUniDirectional());
        TestContainerSpecCompatibilityOptions.assertFalse((boolean)compat.isNonDefaultMappingAllowed());
        String vMode = emf1.getConfiguration().getValidationMode();
        TestContainerSpecCompatibilityOptions.assertEquals((String)"NONE", (String)vMode);
        Specification spec = emf1.getConfiguration().getSpecificationInstance();
        TestContainerSpecCompatibilityOptions.assertEquals((String)"JPA", (String)spec.getName().toUpperCase());
        TestContainerSpecCompatibilityOptions.assertEquals((int)spec.getVersion(), (int)1);
        this.closeEMF((EntityManagerFactory)emf1);
    }

    public void testJPA2CompatibilityOptions() {
        Compatibility compat = this.emf.getConfiguration().getCompatibilityInstance();
        TestContainerSpecCompatibilityOptions.assertFalse((boolean)compat.getFlushBeforeDetach());
        TestContainerSpecCompatibilityOptions.assertFalse((boolean)compat.getCopyOnDetach());
        TestContainerSpecCompatibilityOptions.assertFalse((boolean)compat.getIgnoreDetachedStateFieldForProxySerialization());
        TestContainerSpecCompatibilityOptions.assertFalse((boolean)compat.getPrivatePersistentProperties());
        TestContainerSpecCompatibilityOptions.assertTrue((boolean)compat.isAbstractMappingUniDirectional());
        TestContainerSpecCompatibilityOptions.assertTrue((boolean)compat.isNonDefaultMappingAllowed());
        String vMode = this.emf.getConfiguration().getValidationMode();
        TestContainerSpecCompatibilityOptions.assertEquals((String)"AUTO", (String)vMode);
        Specification spec = this.emf.getConfiguration().getSpecificationInstance();
        TestContainerSpecCompatibilityOptions.assertEquals((String)"JPA", (String)spec.getName().toUpperCase());
        TestContainerSpecCompatibilityOptions.assertEquals((int)spec.getVersion(), (int)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMappedSuperClass() {
        ArrayList types = new ArrayList();
        types.add(EntityA.class);
        types.add(EntityB.class);
        types.add(MappedSuper.class);
        OpenJPAEntityManagerFactorySPI oemf = this.createEMF2_0(types);
        OpenJPAEntityManagerSPI em = null;
        try {
            em = oemf.createEntityManager();
            EntityA a = new EntityA();
            a.setId(1);
            EntityB b = new EntityB();
            b.setId(1);
            a.setEntityB(b);
            b.setEntityA(a);
            em.getTransaction().begin();
            em.persist((Object)a);
            em.persist((Object)b);
            em.getTransaction().commit();
            em.close();
            TestContainerSpecCompatibilityOptions.fail((String)"An exceptioin will be thrown for a bi-directional relation declared in mapped superclass");
        }
        catch (ArgumentException e) {
            if (em != null) {
                em.getTransaction().rollback();
                em.close();
            }
        }
        finally {
            this.closeEMF((EntityManagerFactory)oemf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneToManyRelation() {
        ArrayList types = new ArrayList();
        types.add(EntityC.class);
        types.add(EntityC_B1MFK.class);
        types.add(EntityC_B1MJT.class);
        types.add(EntityC_U1MFK.class);
        types.add(Bi_1ToM_FK.class);
        types.add(Bi_1ToM_JT.class);
        types.add(Uni_1ToM_FK.class);
        types.add(Uni_1ToM_JT.class);
        OpenJPAEntityManagerFactorySPI oemf = this.createEMF2_0(types);
        OpenJPAEntityManagerSPI em = oemf.createEntityManager();
        try {
            em.getTransaction().begin();
            em.getTransaction().commit();
            this.assertSQLFragnments(this.sql, "CREATE TABLE Bi1MJT_C", "C_ID", "Bi1MJT_ID");
            this.assertSQLFragnments(this.sql, "CREATE TABLE C_B1MFK", "BI1MFK_ID");
            this.assertSQLFragnments(this.sql, "CREATE TABLE Uni1MJT_C", "Uni1MJT_ID", "C_ID");
            this.assertSQLFragnments(this.sql, "CREATE TABLE C_B1MFK", "BI1MFK_ID");
            this.assertSQLFragnments(this.sql, "CREATE TABLE C_U1MFK", "Uni1MFK_ID");
            this.crudUni1MFK((EntityManager)em);
            this.crudUni1MJT((EntityManager)em);
            this.crudBi1MFK((EntityManager)em);
            this.crudBi1MJT((EntityManager)em);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestContainerSpecCompatibilityOptions.fail((String)("OneToMany mapping failed with exception message: " + e.getMessage()));
        }
        finally {
            em.close();
            this.closeEMF((EntityManagerFactory)oemf);
        }
    }

    public void crudUni1MFK(EntityManager em) {
        Uni_1ToM_FK u = new Uni_1ToM_FK();
        u.setName("u");
        List<EntityC_U1MFK> cs = new ArrayList<EntityC_U1MFK>();
        EntityC_U1MFK c = new EntityC_U1MFK();
        c.setName("c");
        cs.add(c);
        u.setEntityCs(cs);
        em.persist((Object)u);
        em.persist((Object)c);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        cs = u.getEntityCs();
        u.setName("newName");
        EntityC_U1MFK c1 = new EntityC_U1MFK();
        c1.setName("c1");
        cs.add(c1);
        em.persist((Object)c1);
        em.getTransaction().commit();
        em.getTransaction().begin();
        EntityC_U1MFK c2 = cs.remove(0);
        Uni_1ToM_FK u2 = new Uni_1ToM_FK();
        u2.setName("u2");
        ArrayList<EntityC_U1MFK> cs2 = new ArrayList<EntityC_U1MFK>();
        cs2.add(c2);
        u2.setEntityCs(cs2);
        em.persist((Object)u2);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT u FROM Uni_1ToM_FK u where u.name = 'newName'");
        Uni_1ToM_FK u1 = (Uni_1ToM_FK)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)u1);
        em.clear();
        long id = u1.getId();
        Uni_1ToM_FK findU1 = (Uni_1ToM_FK)em.find(Uni_1ToM_FK.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)findU1, (Object)u1);
        em.getTransaction().begin();
        em.remove((Object)findU1);
        em.getTransaction().commit();
        em.clear();
    }

    public void crudUni1MJT(EntityManager em) {
        Uni_1ToM_JT u = new Uni_1ToM_JT();
        u.setName("u");
        List<EntityC> cs = new ArrayList<EntityC>();
        EntityC c = new EntityC();
        c.setName("c");
        cs.add(c);
        u.setEntityCs(cs);
        em.persist((Object)u);
        em.persist((Object)c);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        cs = u.getEntityCs();
        u.setName("newName");
        EntityC c1 = new EntityC();
        c1.setName("c1");
        cs.add(c1);
        em.persist((Object)c1);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT u FROM Uni_1ToM_JT u");
        Uni_1ToM_JT u1 = (Uni_1ToM_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)u1);
        em.clear();
        long id = u1.getId();
        Uni_1ToM_JT u2 = (Uni_1ToM_JT)em.find(Uni_1ToM_JT.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)u2);
        em.getTransaction().begin();
        em.remove((Object)u2);
        em.getTransaction().commit();
        em.clear();
    }

    public void crudBi1MFK(EntityManager em) {
        Bi_1ToM_FK b = new Bi_1ToM_FK();
        b.setName("b");
        List<EntityC_B1MFK> cs = new ArrayList<EntityC_B1MFK>();
        EntityC_B1MFK c = new EntityC_B1MFK();
        c.setName("c");
        c.setBi1mfk(b);
        cs.add(c);
        b.setEntityCs(cs);
        em.persist((Object)b);
        em.persist((Object)c);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        cs = b.getEntityCs();
        b.setName("newName");
        EntityC_B1MFK c1 = new EntityC_B1MFK();
        c1.setName("c1");
        cs.add(c1);
        c1.setBi1mfk(b);
        em.persist((Object)c1);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT b FROM Bi_1ToM_FK b");
        Bi_1ToM_FK b1 = (Bi_1ToM_FK)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b1);
        em.clear();
        long id = b1.getId();
        Bi_1ToM_FK b2 = (Bi_1ToM_FK)em.find(Bi_1ToM_FK.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b2);
        em.getTransaction().begin();
        em.remove((Object)b2);
        em.getTransaction().commit();
        em.clear();
    }

    public void crudBi1MJT(EntityManager em) {
        Bi_1ToM_JT b = new Bi_1ToM_JT();
        b.setName("b");
        List<EntityC_B1MJT> cs = new ArrayList<EntityC_B1MJT>();
        EntityC_B1MJT c = new EntityC_B1MJT();
        c.setName("c");
        c.setBi1mjt(b);
        cs.add(c);
        b.setEntityCs(cs);
        em.persist((Object)b);
        em.persist((Object)c);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        cs = b.getEntityCs();
        b.setName("newName");
        EntityC_B1MJT c1 = new EntityC_B1MJT();
        c1.setName("c1");
        cs.add(c1);
        c1.setBi1mjt(b);
        em.persist((Object)c1);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT b FROM Bi_1ToM_JT b where b.name = 'newName'");
        Bi_1ToM_JT b1 = (Bi_1ToM_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b1);
        em.clear();
        q = em.createQuery("SELECT c FROM EntityC_B1MJT c");
        List cs1 = q.getResultList();
        TestContainerSpecCompatibilityOptions.assertEquals((int)2, (int)cs1.size());
        em.clear();
        long id = b1.getId();
        Bi_1ToM_JT b2 = (Bi_1ToM_JT)em.find(Bi_1ToM_JT.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b2);
        em.getTransaction().begin();
        em.remove((Object)b2);
        em.getTransaction().commit();
        em.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneToManyMapRelation() {
        ArrayList types = new ArrayList();
        types.add(EntityC_U1M_Map_FK.class);
        types.add(Uni_1ToM_Map_FK.class);
        types.add(EntityC_B1M_Map_JT.class);
        types.add(Bi_1ToM_Map_JT.class);
        types.add(EntityC_U1M_Map_RelKey_FK.class);
        types.add(Uni_1ToM_Map_RelKey_FK.class);
        types.add(EntityC.class);
        types.add(EntityC_B1M_Map_RelKey_JT.class);
        types.add(Bi_1ToM_Map_RelKey_JT.class);
        OpenJPAEntityManagerFactorySPI emf = this.createEMF2_0(types);
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        try {
            em.getTransaction().begin();
            em.getTransaction().commit();
            this.assertSQLFragnments(this.sql, "CREATE TABLE C_U1M_Map_FK", "Uni1MFK_ID", "KEY0");
            this.assertSQLFragnments(this.sql, "CREATE TABLE Bi1M_Map_JT_C", "B_ID", "C_ID");
            this.assertSQLFragnments(this.sql, "CREATE TABLE C_U1M_Map_RelKey_FK", "Uni1MFK_ID");
            this.assertSQLFragnments(this.sql, "CREATE TABLE Bi1M_Map_RelKey_JT_C", "B_ID", "C_ID");
            this.crudUni1MMapFK((EntityManager)em);
            this.crudBi1MMapJT((EntityManager)em);
            this.crudUni1MMapRelKeyFK((EntityManager)em);
            this.crudBi1MMapRelKeyJT((EntityManager)em);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestContainerSpecCompatibilityOptions.fail((String)("OneToMany mapping failed with exception message: " + e.getMessage()));
        }
        finally {
            em.close();
            emf.close();
        }
    }

    public void crudUni1MMapFK(EntityManager em) {
        Uni_1ToM_Map_FK u = new Uni_1ToM_Map_FK();
        u.setName("u");
        Map<String, EntityC_U1M_Map_FK> cs = new HashMap<String, EntityC_U1M_Map_FK>();
        EntityC_U1M_Map_FK c1 = new EntityC_U1M_Map_FK();
        c1.setName("c1");
        cs.put(c1.getName(), c1);
        EntityC_U1M_Map_FK c2 = new EntityC_U1M_Map_FK();
        c2.setName("c2");
        cs.put(c2.getName(), c2);
        u.setEntityCs(cs);
        em.persist((Object)u);
        em.persist((Object)c1);
        em.persist((Object)c2);
        em.getTransaction().begin();
        em.getTransaction().commit();
        cs = u.getEntityCs();
        u.setName("newName");
        EntityC_U1M_Map_FK c3 = new EntityC_U1M_Map_FK();
        c3.setName("c3");
        cs.put(c3.getName(), c3);
        em.persist((Object)c3);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        EntityC_U1M_Map_FK c4 = cs.remove("c1");
        Uni_1ToM_Map_FK u2 = new Uni_1ToM_Map_FK();
        u2.setName("u2");
        HashMap<String, EntityC_U1M_Map_FK> cs2 = new HashMap<String, EntityC_U1M_Map_FK>();
        cs2.put(c4.getName(), c4);
        u2.setEntityCs(cs2);
        em.persist((Object)u2);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT u FROM Uni_1ToM_Map_FK u where u.name='newName'");
        Uni_1ToM_Map_FK u1 = (Uni_1ToM_Map_FK)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)u1);
        em.clear();
        long id = u1.getId();
        Uni_1ToM_Map_FK findU = (Uni_1ToM_Map_FK)em.find(Uni_1ToM_Map_FK.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)findU);
        em.getTransaction().begin();
        em.remove((Object)findU);
        em.getTransaction().commit();
    }

    public void crudBi1MMapJT(EntityManager em) {
        Bi_1ToM_Map_JT b = new Bi_1ToM_Map_JT();
        b.setName("b");
        Map<String, EntityC_B1M_Map_JT> cs = new HashMap<String, EntityC_B1M_Map_JT>();
        EntityC_B1M_Map_JT c = new EntityC_B1M_Map_JT();
        c.setName("c");
        c.setBi1mjt(b);
        cs.put(c.getName(), c);
        b.setEntityCs(cs);
        em.persist((Object)b);
        em.persist((Object)c);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        cs = b.getEntityCs();
        b.setName("newName");
        EntityC_B1M_Map_JT c1 = new EntityC_B1M_Map_JT();
        c1.setName("c1");
        cs.put(c1.getName(), c1);
        c1.setBi1mjt(b);
        em.persist((Object)c1);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT b FROM Bi_1ToM_Map_JT b");
        Bi_1ToM_Map_JT b1 = (Bi_1ToM_Map_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b1);
        em.clear();
        q = em.createQuery("SELECT c FROM EntityC_B1M_Map_JT c");
        List cs1 = q.getResultList();
        TestContainerSpecCompatibilityOptions.assertEquals((int)2, (int)cs.size());
        em.clear();
        long id = b1.getId();
        Bi_1ToM_Map_JT b2 = (Bi_1ToM_Map_JT)em.find(Bi_1ToM_Map_JT.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b2);
        em.getTransaction().begin();
        em.remove((Object)b2);
        em.getTransaction().commit();
    }

    public void crudUni1MMapRelKeyFK(EntityManager em) {
        Uni_1ToM_Map_RelKey_FK u = new Uni_1ToM_Map_RelKey_FK();
        u.setName("u");
        Map<EntityC, EntityC_U1M_Map_RelKey_FK> cs = new HashMap<EntityC, EntityC_U1M_Map_RelKey_FK>();
        EntityC_U1M_Map_RelKey_FK c1 = new EntityC_U1M_Map_RelKey_FK();
        c1.setName("c1");
        EntityC cKey1 = new EntityC();
        cKey1.setName("cKey1");
        cs.put(cKey1, c1);
        EntityC_U1M_Map_RelKey_FK c2 = new EntityC_U1M_Map_RelKey_FK();
        c2.setName("c2");
        EntityC cKey2 = new EntityC();
        cKey2.setName("cKey2");
        cs.put(cKey2, c1);
        cs.put(cKey2, c2);
        u.setEntityCs(cs);
        em.persist((Object)u);
        em.persist((Object)c1);
        em.persist((Object)c2);
        em.persist((Object)cKey1);
        em.persist((Object)cKey2);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        cs = u.getEntityCs();
        u.setName("newName");
        EntityC_U1M_Map_RelKey_FK c3 = new EntityC_U1M_Map_RelKey_FK();
        c3.setName("c3");
        EntityC cKey3 = new EntityC();
        cKey3.setName("cKey3");
        cs.put(cKey3, c3);
        em.persist((Object)c3);
        em.persist((Object)cKey3);
        em.getTransaction().commit();
        em.getTransaction().begin();
        EntityC_U1M_Map_RelKey_FK c4 = cs.remove(cKey1);
        Uni_1ToM_Map_RelKey_FK u2 = new Uni_1ToM_Map_RelKey_FK();
        u2.setName("u2");
        HashMap<EntityC, EntityC_U1M_Map_RelKey_FK> cs2 = new HashMap<EntityC, EntityC_U1M_Map_RelKey_FK>();
        cs2.put(cKey1, c4);
        u2.setEntityCs(cs2);
        em.persist((Object)u2);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT u FROM Uni_1ToM_Map_RelKey_FK u where u.name='newName'");
        Uni_1ToM_Map_RelKey_FK u1 = (Uni_1ToM_Map_RelKey_FK)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)u1);
        em.clear();
        long id = u1.getId();
        Uni_1ToM_Map_RelKey_FK findU = (Uni_1ToM_Map_RelKey_FK)em.find(Uni_1ToM_Map_RelKey_FK.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)findU);
        em.getTransaction().begin();
        em.remove((Object)findU);
        em.getTransaction().commit();
    }

    public void crudBi1MMapRelKeyJT(EntityManager em) {
        Bi_1ToM_Map_RelKey_JT b = new Bi_1ToM_Map_RelKey_JT();
        b.setName("b");
        Map<EntityC, EntityC_B1M_Map_RelKey_JT> cs = new HashMap<EntityC, EntityC_B1M_Map_RelKey_JT>();
        EntityC_B1M_Map_RelKey_JT c = new EntityC_B1M_Map_RelKey_JT();
        c.setName("c");
        c.setBi1mjt(b);
        EntityC cKey = new EntityC();
        cKey.setName("cKey");
        cs.put(cKey, c);
        b.setEntityCs(cs);
        em.persist((Object)b);
        em.persist((Object)c);
        em.persist((Object)cKey);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        cs = b.getEntityCs();
        b.setName("newName");
        EntityC_B1M_Map_RelKey_JT c1 = new EntityC_B1M_Map_RelKey_JT();
        c1.setName("c1");
        EntityC cKey1 = new EntityC();
        cKey1.setName("cKey1");
        cs.put(cKey1, c1);
        c1.setBi1mjt(b);
        em.persist((Object)c1);
        em.persist((Object)cKey1);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT b FROM Bi_1ToM_Map_RelKey_JT b");
        Bi_1ToM_Map_RelKey_JT b1 = (Bi_1ToM_Map_RelKey_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b1);
        em.clear();
        q = em.createQuery("SELECT c FROM EntityC_B1M_Map_RelKey_JT c where c.name = 'c'");
        EntityC_B1M_Map_RelKey_JT newC = (EntityC_B1M_Map_RelKey_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)newC, (Object)c);
        em.clear();
        long id = b1.getId();
        Bi_1ToM_Map_RelKey_JT b2 = (Bi_1ToM_Map_RelKey_JT)em.find(Bi_1ToM_Map_RelKey_JT.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b2);
        em.getTransaction().begin();
        em.remove((Object)b2);
        em.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUniManyToOneUsingJoinTable() {
        ArrayList types = new ArrayList();
        types.add(EntityC.class);
        types.add(Uni_MTo1_JT.class);
        OpenJPAEntityManagerFactorySPI emf = this.createEMF2_0(types);
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        try {
            em.getTransaction().begin();
            em.getTransaction().commit();
            this.assertSQLFragnments(this.sql, "CREATE TABLE UniM1JT_C", "U_ID", "C_ID");
            this.crudUniM1JT((EntityManager)em);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestContainerSpecCompatibilityOptions.fail((String)("ManyToOne mapping failed with exception message: " + e.getMessage()));
        }
        finally {
            em.close();
            emf.close();
        }
    }

    public void crudUniM1JT(EntityManager em) {
        Uni_MTo1_JT u = new Uni_MTo1_JT();
        u.setName("u");
        Uni_MTo1_JT u1 = new Uni_MTo1_JT();
        u1.setName("u1");
        EntityC c1 = new EntityC();
        c1.setName("c1");
        u.setEntityC(c1);
        u1.setEntityC(c1);
        em.persist((Object)u);
        em.persist((Object)u1);
        em.persist((Object)c1);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        u.setName("u_new");
        EntityC c3 = new EntityC();
        c3.setName("c3");
        u.setEntityC(c3);
        em.persist((Object)c3);
        em.getTransaction().commit();
        em.getTransaction().begin();
        u.setEntityC(null);
        em.getTransaction().commit();
        Query q = em.createQuery("SELECT u FROM Uni_MTo1_JT u where u.name='u_new'");
        Uni_MTo1_JT queryU = (Uni_MTo1_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)queryU);
        em.clear();
        long id = u1.getId();
        Uni_MTo1_JT findU = (Uni_MTo1_JT)em.find(Uni_MTo1_JT.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u1, (Object)findU);
        em.getTransaction().begin();
        em.remove((Object)findU);
        em.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneToOneUsingJoinTable() {
        ArrayList types = new ArrayList();
        types.add(EntityC_B11JT.class);
        types.add(EntityC_U11JT.class);
        types.add(Bi_1To1_JT.class);
        types.add(Uni_1To1_JT.class);
        OpenJPAEntityManagerFactorySPI emf = this.createEMF2_0(types);
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        try {
            em.getTransaction().begin();
            em.getTransaction().commit();
            this.assertSQLFragnments(this.sql, "CREATE TABLE Bi11JT_C", "B_ID", "C_ID");
            this.assertSQLFragnments(this.sql, "CREATE TABLE Uni11JT_C", "U_ID", "C_ID");
            this.crudBi11JT((EntityManager)em);
            this.crudUni11JT((EntityManager)em);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestContainerSpecCompatibilityOptions.fail((String)("OneToOne mapping failed with exception message: " + e.getMessage()));
        }
        finally {
            em.close();
            emf.close();
        }
    }

    public void crudUni11JT(EntityManager em) {
        Uni_1To1_JT u = new Uni_1To1_JT();
        u.setName("uni1mjt");
        EntityC_U11JT c1 = new EntityC_U11JT();
        c1.setName("c1");
        u.setEntityC(c1);
        em.persist((Object)u);
        em.persist((Object)c1);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        u.setName("uni1mjt_new");
        EntityC_U11JT newC = new EntityC_U11JT();
        newC.setName("newC");
        u.setEntityC(newC);
        em.persist((Object)newC);
        em.getTransaction().commit();
        em.getTransaction().begin();
        u.setEntityC(null);
        em.getTransaction().commit();
        em.clear();
        Query q = em.createQuery("SELECT u FROM Uni_1To1_JT u where u.name = 'uni1mjt_new'");
        Uni_1To1_JT u1 = (Uni_1To1_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)u1);
        em.clear();
        long id = u1.getId();
        Uni_1To1_JT findU1 = (Uni_1To1_JT)em.find(Uni_1To1_JT.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)u, (Object)findU1);
        em.getTransaction().begin();
        em.remove((Object)findU1);
        em.getTransaction().commit();
    }

    public void crudBi11JT(EntityManager em) {
        Bi_1To1_JT b = new Bi_1To1_JT();
        b.setName("bi11fk");
        EntityC_B11JT c = new EntityC_B11JT();
        c.setName("c");
        b.setEntityC(c);
        em.persist((Object)b);
        em.persist((Object)c);
        em.getTransaction().begin();
        em.getTransaction().commit();
        em.getTransaction().begin();
        b.setEntityC(null);
        em.getTransaction().commit();
        em.getTransaction().begin();
        b.setName("newName");
        EntityC_B11JT c1 = new EntityC_B11JT();
        c1.setName("c1");
        b.setEntityC(c1);
        em.persist((Object)c1);
        em.getTransaction().commit();
        Query q = em.createQuery("SELECT u FROM Bi_1To1_JT u");
        Bi_1To1_JT b1 = (Bi_1To1_JT)q.getSingleResult();
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b1);
        em.clear();
        q = em.createQuery("SELECT c FROM EntityC_B11JT c");
        List cs1 = q.getResultList();
        TestContainerSpecCompatibilityOptions.assertEquals((int)2, (int)cs1.size());
        em.clear();
        long id = b1.getId();
        Bi_1To1_JT b2 = (Bi_1To1_JT)em.find(Bi_1To1_JT.class, (Object)id);
        TestContainerSpecCompatibilityOptions.assertEquals((Object)b, (Object)b2);
        em.getTransaction().begin();
        em.remove((Object)b2);
        em.getTransaction().commit();
    }

    private OpenJPAEntityManagerFactorySPI createEMF2_0(List<Class<?>> types) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("openjpa.jdbc.JDBCListeners", new JDBCListener[]{new Listener()});
        map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='drop,add')");
        map.put("PERSISTENT_CLASS_LIST", types);
        return this.createContainerEMF("persistence_2_0", "org/apache/openjpa/persistence/compat/persistence_2_0.xml", map);
    }

    void assertSQLFragnments(List<String> list, String ... keys) {
        if (SQLSniffer.matches(list, keys)) {
            return;
        }
        TestContainerSpecCompatibilityOptions.fail((String)("None of the following " + this.sql.size() + " SQL \r\n" + this.toString(this.sql) + "\r\n contains all keys \r\n" + this.toString(Arrays.asList(keys))));
    }

    public String toString(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String s : list) {
            buf.append(s).append("\r\n");
        }
        return buf.toString();
    }

    public class Listener
    extends AbstractJDBCListener {
        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL() != null && TestContainerSpecCompatibilityOptions.this.sql != null) {
                TestContainerSpecCompatibilityOptions.this.sql.add(event.getSQL());
                ++TestContainerSpecCompatibilityOptions.this.sqlCount;
            }
        }
    }
}

