/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.compat;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.relations.TblChild;
import org.apache.openjpa.persistence.relations.TblGrandChild;
import org.apache.openjpa.persistence.relations.TblParent;
import org.apache.openjpa.persistence.simple.Person;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestQuerySQLCache
extends SingleEMFTestCase {
    final int nThreads = 5;
    final int nPeople = 100;
    final int nIterations = 10;

    @Override
    public void setUp() {
        this.setUp(DROP_TABLES, Person.class, TblChild.class, TblGrandChild.class, TblParent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadCustomCacheSetting() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.MetaDataFactory", "jpa(Types=" + Person.class.getName() + ")");
        props.put("openjpa.jdbc.QuerySQLCache", "org.apache.openjpa.persistence.compatible.TestQuerySQLCache.BadCacheMap");
        OpenJPAEntityManagerFactorySPI emf1 = null;
        try {
            emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props));
            TestQuerySQLCache.fail((String)"EMF creation must throw an exception because the cache implementation class will not be found");
        }
        catch (Exception e) {
            try {
                TestQuerySQLCache.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                this.closeEMF((EntityManagerFactory)emf1);
                throw throwable;
            }
            this.closeEMF((EntityManagerFactory)emf1);
        }
        this.closeEMF((EntityManagerFactory)emf1);
    }

    @AllowFailure(message="OPENJPA-1179 2.0 doesn't allow 'all' as in previous releases")
    public void testMultiEMCachingAll() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.MetaDataFactory", "jpa(Types=" + Person.class.getName() + ")");
        props.put("openjpa.jdbc.QuerySQLCache", "all");
        this.runMultiEMCaching(props);
    }

    public void testMultiEMCachingTrue() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.MetaDataFactory", "jpa(Types=" + Person.class.getName() + ")");
        props.put("openjpa.jdbc.QuerySQLCache", "true");
        this.runMultiEMCaching(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AllowFailure(message="Fails after first run with duplicate key value in a unique PK constraint or index")
    public void testEagerFetch() {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.MetaDataFactory", "jpa(Types=" + TblChild.class.getName() + ";" + TblGrandChild.class.getName() + ";" + TblParent.class.getName() + ")");
        props.put("openjpa.jdbc.QuerySQLCache", "true");
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)Persistence.createEntityManagerFactory((String)"test", props));
        try {
            TblParent p;
            int i;
            EntityManagerImpl em = (EntityManagerImpl)emf1.createEntityManager();
            em.getTransaction().begin();
            for (i = 1; i < 3; ++i) {
                p = new TblParent();
                p.setParentId(i);
                TblChild c = new TblChild();
                c.setChildId(i);
                c.setTblParent(p);
                p.addTblChild(c);
                em.persist((Object)p);
                em.persist((Object)c);
                TblGrandChild gc = new TblGrandChild();
                gc.setGrandChildId(i);
                gc.setTblChild(c);
                c.addTblGrandChild(gc);
                em.persist((Object)p);
                em.persist((Object)c);
                em.persist((Object)gc);
            }
            em.flush();
            em.getTransaction().commit();
            em.clear();
            for (i = 1; i < 3; ++i) {
                p = (TblParent)em.find(TblParent.class, (Object)i);
                int pid = p.getParentId();
                TestQuerySQLCache.assertEquals((int)pid, (int)i);
                Collection<TblChild> children = p.getTblChildren();
                boolean hasChild = false;
                for (TblChild c : children) {
                    hasChild = true;
                    Collection<TblGrandChild> gchildren = c.getTblGrandChildren();
                    int cid = c.getChildId();
                    TestQuerySQLCache.assertEquals((int)cid, (int)i);
                    boolean hasGrandChild = false;
                    for (TblGrandChild gc : gchildren) {
                        hasGrandChild = true;
                        int gcId = gc.getGrandChildId();
                        TestQuerySQLCache.assertEquals((int)gcId, (int)i);
                    }
                    TestQuerySQLCache.assertTrue((boolean)hasGrandChild);
                }
                TestQuerySQLCache.assertTrue((boolean)hasChild);
                em.close();
            }
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMultiEMCaching(Map props) {
        EntityManagerFactory emfac = Persistence.createEntityManagerFactory((String)"test", (Map)props);
        try {
            int i;
            EntityManager em = emfac.createEntityManager();
            em.getTransaction().begin();
            for (int i2 = 0; i2 < 100; ++i2) {
                Person p = new Person();
                p.setId(i2);
                em.persist((Object)p);
            }
            em.flush();
            em.getTransaction().commit();
            em.close();
            Thread[] newThreads = new Thread[5];
            FindPeople[] customer = new FindPeople[5];
            for (i = 0; i < 5; ++i) {
                customer[i] = new FindPeople(emfac, 0, 100, 10, i);
                newThreads[i] = new Thread(customer[i]);
                newThreads[i].start();
            }
            for (i = 0; i < 5; ++i) {
                try {
                    newThreads[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    TestQuerySQLCache.fail((String)("Caught Interrupted Exception: " + e));
                }
            }
            for (i = 0; i < 5; ++i) {
                TestQuerySQLCache.assertFalse((boolean)customer[i].hadFailures());
            }
            em = emfac.createEntityManager();
            em.getTransaction().begin();
            for (i = 0; i < 100; ++i) {
                Person p = (Person)em.find(Person.class, (Object)i);
                em.remove((Object)p);
            }
            em.flush();
            em.getTransaction().commit();
            em.close();
        }
        finally {
            this.closeEMF(emfac);
        }
    }

    private class FindPeople
    implements Runnable {
        private int startId;
        private int endId;
        private int thread;
        private int iterations;
        private EntityManagerFactory emf;
        private boolean failures = false;

        public FindPeople(EntityManagerFactory emf, int startId, int endId, int iterations, int thread) {
            this.startId = startId;
            this.endId = endId;
            this.thread = thread;
            this.iterations = iterations;
            this.emf = emf;
        }

        public boolean hadFailures() {
            return this.failures;
        }

        @Override
        public void run() {
            try {
                EntityManager em = this.emf.createEntityManager();
                for (int j = 0; j < this.iterations; ++j) {
                    for (int i = this.startId; i < this.endId; ++i) {
                        Person p1 = (Person)em.find(Person.class, (Object)i);
                        if (p1.getId() == i) continue;
                        System.out.println("Finder failed: " + i);
                        this.failures = true;
                        break;
                    }
                    em.clear();
                }
                em.close();
            }
            catch (Exception e) {
                this.failures = true;
                System.out.println("Thread " + this.thread + " exception :" + e);
            }
        }
    }
}

