/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.conf;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.common.utils.BufferedLogFactory;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="excluded")
public class TestOpenJPAConfiguration
extends AbstractTestCase {
    public TestOpenJPAConfiguration(String test) {
        super(test, "confcactusapp");
    }

    public void testSetObjects() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object cfactory = new Object();
        Object cfactory2 = new Object();
        map.put("openjpa.ConnectionFactory", cfactory);
        map.put("openjpa.ConnectionFactory2", cfactory2);
        map.put("openjpa.Optimistic", Boolean.FALSE);
        map.put("openjpa.LockTimeout", new Integer(503));
        map.put("javax.persistence.query.timeout", new Integer(1500));
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl(true, false);
        conf.fromProperties(map);
        TestOpenJPAConfiguration.assertEquals((Object)cfactory, (Object)conf.getConnectionFactory());
        TestOpenJPAConfiguration.assertEquals((Object)cfactory2, (Object)conf.getConnectionFactory2());
        TestOpenJPAConfiguration.assertEquals((boolean)false, (boolean)conf.getOptimistic());
        TestOpenJPAConfiguration.assertEquals((boolean)false, (boolean)conf.getPostLoadOnMerge());
        TestOpenJPAConfiguration.assertEquals((int)503, (int)conf.getLockTimeout());
        TestOpenJPAConfiguration.assertEquals((int)1500, (int)conf.getQueryTimeout());
        OpenJPAConfigurationImpl conf2 = new OpenJPAConfigurationImpl(true, false);
        conf2.fromProperties(map);
        TestOpenJPAConfiguration.assertEquals((Object)conf, (Object)conf2);
        Map p = conf.toProperties(false);
        TestOpenJPAConfiguration.assertTrue((!p.containsKey("openjpa.ConnectionFactory") ? 1 : 0) != 0);
        TestOpenJPAConfiguration.assertTrue((!p.containsKey("openjpa.ConnectionFactory2") ? 1 : 0) != 0);
        TestOpenJPAConfiguration.assertEquals((Object)"false", p.get("openjpa.Optimistic"));
        TestOpenJPAConfiguration.assertEquals((Object)"503", p.get("openjpa.LockTimeout"));
        TestOpenJPAConfiguration.assertEquals((Object)p, (Object)conf2.toProperties(false));
        map.put("openjpa.LockTimeout", new Integer(504));
        OpenJPAConfigurationImpl conf3 = new OpenJPAConfigurationImpl(true, false);
        conf3.fromProperties(map);
        TestOpenJPAConfiguration.assertNotEquals(conf, conf3);
    }

    public void testClassAliases() throws Exception {
        OpenJPAConfiguration conf = this.getConfiguration();
        if (!(conf instanceof OpenJPAConfigurationImpl)) {
            return;
        }
        Value[] values = ((OpenJPAConfigurationImpl)conf).getValues();
        ArrayList<String> failures = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof PluginValue)) continue;
            String[] aliases = values[i].getAliases();
            for (int j = 0; j < aliases.length; j += 2) {
                try {
                    String clsName = Configurations.getClassName((String)aliases[j + 1]);
                    if (clsName == null) continue;
                    Class.forName(clsName);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    failures.add("Key: " + aliases[j] + " for property " + values[i].getProperty() + " does not list a valid " + "class: " + aliases[j + 1]);
                    continue;
                }
                catch (UnsupportedClassVersionError ucve) {
                    // empty catch block
                }
            }
        }
        if (failures.size() != 0) {
            TestOpenJPAConfiguration.fail((String)((Object)failures).toString());
        }
    }

    public void testBeanAccessors() throws Exception {
        OpenJPAConfiguration conf = this.getConfiguration();
        OpenJPAConfigurationImpl simp = (OpenJPAConfigurationImpl)conf.clone();
        Value[] values = simp.getValues();
        PropertyDescriptor[] pds = simp.getPropertyDescriptors();
        ArrayList<String> failures = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            try {
                TestOpenJPAConfiguration.assertNotNull((Object)pds[i].getShortDescription());
                TestOpenJPAConfiguration.assertNotNull((Object)pds[i].getDisplayName());
                if ("EntityManagerFactory".equals(values[i].getProperty())) continue;
                Method getter = pds[i].getReadMethod();
                Method setter = pds[i].getWriteMethod();
                TestOpenJPAConfiguration.assertNotNull((Object)getter);
                TestOpenJPAConfiguration.assertNotNull((Object)setter);
                TestOpenJPAConfiguration.assertNotNull((String)("Missing attribute (propertyType) for property " + pds[i].getName()), (Object)pds[i].getValue("propertyType"));
                TestOpenJPAConfiguration.assertNotNull((String)("Missing attribute (propertyCategory) for property " + pds[i].getName()), (Object)pds[i].getValue("propertyCategory"));
                TestOpenJPAConfiguration.assertNotNull((String)("Missing attribute (propertyCategoryOrder) for property " + pds[i].getName()), (Object)pds[i].getValue("propertyCategoryOrder"));
                pds[i].getReadMethod().invoke((Object)simp, (Object[])null);
                continue;
            }
            catch (Exception e) {
                failures.add(pds[i].getName());
            }
        }
        if (failures.size() != 0) {
            TestOpenJPAConfiguration.fail((String)("not all properties had valid comments / setters / getters. failed props: " + failures));
        }
    }

    public void testInvalidPlugins() {
        OpenJPAConfigurationImpl config = new OpenJPAConfigurationImpl();
        config.setLog("log3j");
        try {
            config.getLogFactory().getLog("Foo");
            TestOpenJPAConfiguration.fail((String)"getting the Foo log should have failed");
        }
        catch (RuntimeException re) {
            TestOpenJPAConfiguration.assertTrue((-1 != re.getMessage().indexOf("log4j") ? 1 : 0) != 0);
        }
    }

    public void testInvalidConfigurationWarnings() {
        Properties props = new Properties();
        props.setProperty("openjpa.MaxxFetchDepth", "1");
        OpenJPAConfigurationImpl config = new OpenJPAConfigurationImpl();
        BufferedLogFactory log = new BufferedLogFactory();
        config.setLogFactory((LogFactory)log);
        config.fromProperties((Map)props);
        log.assertLogMessage("*\"openjpa.MaxxFetchDepth\"*");
        log.assertLogMessage("*\"openjpa.MaxFetchDepth\"*");
        log.clear();
        props.clear();
        props.setProperty("openjpa.jdbc.Foo", "XXX");
        props.setProperty("oponjpa", "XXX");
        config.fromProperties((Map)props);
        log.assertNoLogMessage("*\"openjpa.jdbc.Foo\"*");
        log.assertNoLogMessage("*\"oponjpa\"*");
    }

    public void testInvalidNonPluginValues() {
        OpenJPAConfigurationImpl config = new OpenJPAConfigurationImpl();
        try {
            config.setConnectionFactoryMode("aoeu");
            TestOpenJPAConfiguration.fail((String)"setting the ConnectionFactoryMode to aoeu should fail");
        }
        catch (RuntimeException re) {
            TestOpenJPAConfiguration.assertTrue((-1 != re.getMessage().indexOf("managed") ? 1 : 0) != 0);
            TestOpenJPAConfiguration.assertTrue((-1 != re.getMessage().indexOf("local") ? 1 : 0) != 0);
            TestOpenJPAConfiguration.assertTrue((-1 != re.getMessage().indexOf("true") ? 1 : 0) != 0);
            TestOpenJPAConfiguration.assertTrue((-1 != re.getMessage().indexOf("false") ? 1 : 0) != 0);
        }
    }
}

