/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.conf;

import java.util.HashMap;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.RollbackException;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.conf.Person;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOverrideNonJtaDataSource
extends SingleEMFTestCase {
    private String defaultJndiName = "jdbc/mocked";
    private String[] jndiNames = new String[]{"jdbc/mocked1"};

    protected void init(String cfName) {
        EntityManagerFactory emf1 = this.getEmf("openjpa.ConnectionFactoryName", cfName, true);
        EntityManager em = emf1.createEntityManager();
        em.getTransaction().begin();
        em.createQuery("Delete from confPerson").executeUpdate();
        em.getTransaction().commit();
        em.close();
        this.closeEMF(emf1);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp(Person.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        JDBCConfiguration conf = (JDBCConfiguration)em.getConfiguration();
        String user = conf.getConnectionUserName();
        if (user != null && !user.equals("")) {
            this.setTestsDisabled(true);
            this.getLog().trace((Object)"TestOverrideNonJtaDataSource can only be executed against Derby w/o a schema");
        } else {
            this.init(this.defaultJndiName);
            this.init(this.jndiNames[0]);
        }
    }

    protected EntityManagerFactory getEmf(String cfPropertyName, String cfPropertyValue) {
        return this.getEmf(cfPropertyName, cfPropertyValue, false);
    }

    protected EntityManagerFactory getEmf(String cfPropertyName, String cfPropertyValue, boolean syncMappings) {
        if (syncMappings) {
            return this.createEMF("openjpa.jdbc.SynchronizeMappings", "buildSchema", "openjpa.ConnectionDriverName", "", "openjpa.ConnectionFactoryMode", "managed", "openjpa.ConnectionFactoryName", this.defaultJndiName, cfPropertyName, cfPropertyValue, Person.class);
        }
        return this.createEMF("openjpa.ConnectionDriverName", "", "openjpa.ConnectionFactoryMode", "managed", "openjpa.ConnectionFactoryName", this.defaultJndiName, cfPropertyName, cfPropertyValue, Person.class);
    }

    protected EntityManager getEm(EntityManagerFactory emf, String name, String value) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(name, value);
        return emf.createEntityManager(props);
    }

    @Override
    public String getPersistenceUnitName() {
        return "TestCfSwitching";
    }

    public void testConnectionFactoryName() {
        this.overridePropertyOnEM("openjpa.ConnectionFactory2Name", this.jndiNames[0]);
    }

    public void testJtaDataSource() {
        this.overridePropertyOnEM("javax.persistence.nonJtaDataSource", this.jndiNames[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overridePropertyOnEM(String name, String value) {
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)this.getEmf(name, this.defaultJndiName);
        TestOverrideNonJtaDataSource.assertNotNull((Object)emf1);
        try {
            OpenJPAEntityManagerSPI em = emf1.createEntityManager();
            TestOverrideNonJtaDataSource.assertNotNull((Object)em);
            EntityManager em1 = this.getEm((EntityManagerFactory)emf1, name, value);
            TestOverrideNonJtaDataSource.assertNotNull((Object)em1);
            em.getTransaction().begin();
            em.persist((Object)new Person(1, "em"));
            em.getTransaction().commit();
            em1.getTransaction().begin();
            em1.persist((Object)new Person(1, "em1"));
            em1.getTransaction().commit();
            em.clear();
            em1.clear();
            Person p = (Person)em.find(Person.class, (Object)1);
            Person p1 = (Person)em1.find(Person.class, (Object)1);
            TestOverrideNonJtaDataSource.assertNotSame((Object)p, (Object)p1);
            TestOverrideNonJtaDataSource.assertEquals((String)"em", (String)p.getName());
            TestOverrideNonJtaDataSource.assertEquals((String)"em1", (String)p1.getName());
            em.clear();
            em1.clear();
            em.getTransaction().begin();
            em.persist((Object)new Person(1));
            try {
                em.getTransaction().commit();
                TestOverrideNonJtaDataSource.fail((String)"Should not be able to commit the same row a second time");
            }
            catch (RollbackException rbe) {
                TestOverrideNonJtaDataSource.assertTrue((String)("Expected EntityExistsException but found " + rbe.getCause()), (boolean)(rbe.getCause() instanceof EntityExistsException));
            }
            em1.getTransaction().begin();
            em1.persist((Object)new Person(1));
            try {
                em1.getTransaction().commit();
                TestOverrideNonJtaDataSource.fail((String)"Should not be able to commit the same row a second time");
            }
            catch (RollbackException rbe) {
                TestOverrideNonJtaDataSource.assertTrue((boolean)(rbe.getCause() instanceof EntityExistsException));
            }
            em.close();
            em1.close();
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidCfName() throws Exception {
        EntityManagerFactory emf1 = null;
        try {
            emf1 = this.getEmf("openjpa.ConnectionFactory2Name", this.defaultJndiName);
            this.getEm(emf1, "openjpa.ConnectionFactory2Name", "jdbc/NotReal");
            TestOverrideNonJtaDataSource.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            try {
                TestOverrideNonJtaDataSource.assertTrue((boolean)e.isFatal());
                System.out.println((Object)e);
                TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
                TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("EntityManager"));
            }
            catch (Throwable throwable) {
                this.closeEMF(emf1);
                throw throwable;
            }
            this.closeEMF(emf1);
        }
        this.closeEMF(emf1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataCache() {
        EntityManagerFactory emf1 = null;
        try {
            emf1 = this.getEmf("openjpa.DataCache", "true");
            this.getEm(emf1, "openjpa.ConnectionFactoryName", "jdbc/NotReal");
            TestOverrideNonJtaDataSource.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.isFatal());
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("L2 Cache"));
        }
        finally {
            this.closeEMF(emf1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCache() {
        EntityManagerFactory emf1 = null;
        try {
            emf1 = this.getEmf("openjpa.QueryCache", "true");
            this.getEm(emf1, "openjpa.ConnectionFactoryName", "jdbc/NotReal");
            TestOverrideNonJtaDataSource.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.isFatal());
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("openjpa.QueryCache"));
        }
        finally {
            this.closeEMF(emf1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncMappings() {
        EntityManagerFactory emf1 = null;
        try {
            emf1 = this.getEmf("openjpa.jdbc.SynchronizeMappings", "buildSchema");
            this.getEm(emf1, "openjpa.ConnectionFactoryName", "jdbc/NotReal");
            TestOverrideNonJtaDataSource.fail((String)"Expected an excepton when creating an EM with a bogus JNDI name");
        }
        catch (ArgumentException e) {
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.isFatal());
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("jdbc/NotReal"));
            TestOverrideNonJtaDataSource.assertTrue((boolean)e.getMessage().contains("openjpa.jdbc.SynchronizeMappings"));
        }
        finally {
            this.closeEMF(emf1);
        }
    }
}

