/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.List;
import javax.persistence.EntityTransaction;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.criteria.BlogUser;
import org.apache.openjpa.persistence.criteria.BlogUser_;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestByteArray
extends SingleEMFTestCase {
    protected CriteriaBuilder cb;
    String pic = "IamNotAPicture";
    Character[] chars = new Character[]{new Character('a'), new Character('b')};

    @Override
    public void setUp() {
        super.setUp(BlogUser.class);
        this.cb = this.emf.getCriteriaBuilder();
        this.populate();
    }

    public void populate() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        BlogUser bu = new BlogUser();
        bu.setUsername("jode1");
        bu.setPic(this.pic.getBytes());
        bu.setCharacters(this.chars);
        bu.setChars(this.pic.toCharArray());
        em.persist((Object)bu);
        tran.commit();
        em.close();
    }

    public void assertBlogUser(BlogUser bu) {
        TestByteArray.assertNotNull((Object)bu);
        TestByteArray.assertNotNull((Object)bu.getPic());
        TestByteArray.assertNotNull((Object)bu.getCharacters());
        TestByteArray.assertNotNull((Object)bu.getChars());
    }

    public void testSimpleQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaQuery cq = this.cb.createQuery(BlogUser.class);
        cq.select((Selection)cq.from(BlogUser.class));
        List users = em.createQuery(cq).getResultList();
        TestByteArray.assertNotNull((Object)users);
        TestByteArray.assertFalse((boolean)users.isEmpty());
        this.assertBlogUser((BlogUser)users.get(0));
        em.close();
    }

    public void testSimpleQueryBytesNotNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaQuery cq = this.cb.createQuery(BlogUser.class);
        Root bloguser = cq.from(BlogUser.class);
        cq.select((Selection)bloguser);
        cq.where((Expression)bloguser.get(BlogUser_.pic).isNotNull());
        List users = em.createQuery(cq).getResultList();
        TestByteArray.assertNotNull((Object)users);
        TestByteArray.assertFalse((boolean)users.isEmpty());
        this.assertBlogUser((BlogUser)users.get(0));
        em.close();
    }

    public void testSimpleQueryBytesNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaQuery cq = this.cb.createQuery(BlogUser.class);
        Root bloguser = cq.from(BlogUser.class);
        cq.select((Selection)bloguser);
        cq.where((Expression)bloguser.get(BlogUser_.pic).isNull());
        List users = em.createQuery(cq).getResultList();
        TestByteArray.assertNotNull((Object)users);
        TestByteArray.assertTrue((boolean)users.isEmpty());
        em.close();
    }

    public void testSimpleQueryCharactersNotNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaQuery cq = this.cb.createQuery(BlogUser.class);
        Root bloguser = cq.from(BlogUser.class);
        cq.select((Selection)bloguser);
        cq.where((Expression)bloguser.get(BlogUser_.characters).isNotNull());
        List users = em.createQuery(cq).getResultList();
        TestByteArray.assertNotNull((Object)users);
        TestByteArray.assertFalse((boolean)users.isEmpty());
        this.assertBlogUser((BlogUser)users.get(0));
        em.close();
    }

    public void testSimpleQueryCharactersNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaQuery cq = this.cb.createQuery(BlogUser.class);
        Root bloguser = cq.from(BlogUser.class);
        cq.select((Selection)bloguser);
        cq.where((Expression)bloguser.get(BlogUser_.characters).isNull());
        List users = em.createQuery(cq).getResultList();
        TestByteArray.assertNotNull((Object)users);
        TestByteArray.assertTrue((boolean)users.isEmpty());
        em.close();
    }

    public void testSimpleQueryCharsNotNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaQuery cq = this.cb.createQuery(BlogUser.class);
        Root bloguser = cq.from(BlogUser.class);
        cq.select((Selection)bloguser);
        cq.where((Expression)bloguser.get(BlogUser_.chars).isNotNull());
        List users = em.createQuery(cq).getResultList();
        TestByteArray.assertNotNull((Object)users);
        TestByteArray.assertFalse((boolean)users.isEmpty());
        this.assertBlogUser((BlogUser)users.get(0));
        em.close();
    }

    public void testSimpleQueryCharsNull() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        CriteriaQuery cq = this.cb.createQuery(BlogUser.class);
        Root bloguser = cq.from(BlogUser.class);
        cq.select((Selection)bloguser);
        cq.where((Expression)bloguser.get(BlogUser_.chars).isNull());
        List users = em.createQuery(cq).getResultList();
        TestByteArray.assertNotNull((Object)users);
        TestByteArray.assertTrue((boolean)users.isEmpty());
        em.close();
    }
}

