/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.Person_;

public class TestCQL
extends CriteriaTest {
    public void testLogicalPrecedence() {
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        Root p = q.from(Person.class);
        q.select((Selection)p);
        Predicate a = this.cb.equal((Expression)p.get(Person_.name), (Object)"A");
        Predicate b = this.cb.equal((Expression)p.get(Person_.name), (Object)"B");
        Predicate c = this.cb.equal((Expression)p.get(Person_.name), (Object)"C");
        Predicate d = this.cb.equal((Expression)p.get(Person_.name), (Object)"D");
        q.where(new Predicate[]{this.cb.or((Expression)a, (Expression)b), this.cb.or((Expression)c, (Expression)d)});
        String jpql = "";
        jpql = "SELECT p FROM Person p WHERE ((p.name = 'A' OR p.name = 'B') AND (p.name = 'C' OR p.name = 'D'))";
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestCQL.assertEquals((String)jpql, (String)q.toCQL());
        q.where(new Predicate[]{this.cb.or(new Predicate[]{a, b, c}), d});
        jpql = "SELECT p FROM Person p WHERE ((p.name = 'A' OR p.name = 'B' OR p.name = 'C') AND p.name = 'D')";
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestCQL.assertEquals((String)jpql, (String)q.toCQL());
        q.where(new Predicate[]{a, this.cb.or((Expression)b, (Expression)c), d});
        jpql = "SELECT p FROM Person p WHERE (p.name = 'A' AND (p.name = 'B' OR p.name = 'C') AND p.name = 'D')";
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestCQL.assertEquals((String)jpql, (String)q.toCQL());
        q.where((Expression)this.cb.or((Expression)a, (Expression)this.cb.and((Expression)b, (Expression)this.cb.or((Expression)c, (Expression)d))));
        jpql = "SELECT p FROM Person p WHERE (p.name = 'A' OR (p.name = 'B' AND (p.name = 'C' OR p.name = 'D')))";
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestCQL.assertEquals((String)jpql, (String)q.toCQL());
        q.where((Expression)this.cb.or((Expression)a, (Expression)b).not());
        jpql = "SELECT p FROM Person p WHERE NOT (p.name = 'A' OR p.name = 'B')";
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestCQL.assertEquals((String)jpql, (String)q.toCQL());
        q.where((Expression)this.cb.and(new Predicate[]{a}).not());
        jpql = "SELECT p FROM Person p WHERE NOT p.name = 'A'";
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestCQL.assertEquals((String)jpql, (String)q.toCQL());
        q.where((Expression)this.cb.or((Expression)this.cb.not((Expression)a), (Expression)this.cb.not((Expression)b)));
        jpql = "SELECT p FROM Person p WHERE (p.name <> 'A' OR p.name <> 'B')";
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
        TestCQL.assertEquals((String)jpql, (String)q.toCQL());
    }
}

