/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.Account;
import org.apache.openjpa.persistence.criteria.Account_;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.Address_;
import org.apache.openjpa.persistence.criteria.CompUser;
import org.apache.openjpa.persistence.criteria.CompUser_;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Customer;
import org.apache.openjpa.persistence.criteria.Customer_;
import org.apache.openjpa.persistence.criteria.Department;
import org.apache.openjpa.persistence.criteria.Department_;
import org.apache.openjpa.persistence.criteria.Dependent;
import org.apache.openjpa.persistence.criteria.DependentId_;
import org.apache.openjpa.persistence.criteria.Dependent_;
import org.apache.openjpa.persistence.criteria.Employee;
import org.apache.openjpa.persistence.criteria.Employee_;
import org.apache.openjpa.persistence.criteria.LineItem;
import org.apache.openjpa.persistence.criteria.LineItem_;
import org.apache.openjpa.persistence.criteria.Magazine;
import org.apache.openjpa.persistence.criteria.Magazine_;
import org.apache.openjpa.persistence.criteria.Manager;
import org.apache.openjpa.persistence.criteria.Manager_;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Order;
import org.apache.openjpa.persistence.criteria.Order_;
import org.apache.openjpa.persistence.criteria.Person_;
import org.apache.openjpa.persistence.criteria.Product;
import org.apache.openjpa.persistence.criteria.Publisher;
import org.apache.openjpa.persistence.criteria.Publisher_;
import org.apache.openjpa.persistence.criteria.Request;
import org.apache.openjpa.persistence.criteria.Request_;

public class TestJPQLSubquery
extends CriteriaTest {
    public void testSubqueries1() {
        String jpql = "SELECT goodCustomer FROM Customer goodCustomer WHERE goodCustomer.balanceOwed < (SELECT AVG(c.balanceOwed)  FROM Customer c)";
        String expectedSQL = "SELECT t0.id, t0.accountNum, t2.id, t2.city, t2.country, t2.county, t2.state, t2.street, t3.userid, t3.DTYPE, t3.age, t3.compName, t3.creditRating, t3.name, t2.zipCode, t0.balanceOwed, t0.creditRating, t0.filledOrderCount, t0.firstName, t0.lastName, t0.name, t0.status FROM CR_CUST t0 LEFT OUTER JOIN CR_ADDR t2 ON t0.ADDRESS_ID = t2.id LEFT OUTER JOIN CompUser t3 ON t2.id = t3.ADD_ID WHERE (t0.balanceOwed < (SELECT AVG(t1.balanceOwed) FROM CR_CUST t1))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root goodCustomer = q.from(Customer.class);
        q.select((Selection)goodCustomer);
        Subquery sq = q.subquery(Double.class);
        Root c = sq.from(Customer.class);
        q.where((Expression)this.cb.lt((Expression)goodCustomer.get(Customer_.balanceOwed), (Expression)sq.select(this.cb.avg((Expression)c.get(Customer_.balanceOwed)))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries2() {
        String jpql = "SELECT DISTINCT emp FROM Employee emp WHERE EXISTS (SELECT spouseEmp FROM Employee spouseEmp WHERE spouseEmp = emp.spouse)";
        String expectedSQL = "SELECT t1.empId, t1.EMP_TYPE, t2.id, t2.city, t2.country, t2.county, t2.state, t2.street, t3.userid, t3.DTYPE, t3.age, t3.compName, t3.creditRating, t3.name, t2.zipCode, t4.deptNo, t4.name, t5.id, t5.annualMiles, t5.name, t6.id, t7.deptNo, t7.name, t6.name, t6.salary, t1.name, t1.rating, t1.salary, t8.empId, t8.EMP_TYPE, t8.ADDRESS_ID, t8.DEPARTMENT_DEPTNO, t8.FREQUENTFLIERPLAN_ID, t8.MANAGER_ID, t8.name, t8.rating, t8.salary, t8.hireDate, t1.hireDate FROM CR_EMP t1 LEFT OUTER JOIN CR_ADDR t2 ON t1.ADDRESS_ID = t2.id LEFT OUTER JOIN CR_DEPT t4 ON t1.DEPARTMENT_DEPTNO = t4.deptNo LEFT OUTER JOIN FrequentFlierPlan t5 ON t1.FREQUENTFLIERPLAN_ID = t5.id LEFT OUTER JOIN CR_MGR t6 ON t1.MANAGER_ID = t6.id LEFT OUTER JOIN CR_EMP t8 ON t1.SPOUSE_EMPID = t8.empId LEFT OUTER JOIN CompUser t3 ON t2.id = t3.ADD_ID LEFT OUTER JOIN CR_DEPT t7 ON t6.DEPARTMENT_DEPTNO = t7.deptNo WHERE (EXISTS (SELECT t0.empId FROM CR_EMP t0 WHERE (t0.empId = t1.SPOUSE_EMPID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        q.select((Selection)emp).distinct(true);
        Subquery sq = q.subquery(Employee.class);
        Root spouseEmp = sq.from(Employee.class);
        sq.where((Expression)this.cb.equal((Expression)spouseEmp, (Expression)emp.get(Employee_.spouse)));
        q.where((Expression)this.cb.exists(sq.select((Expression)spouseEmp)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries3() {
        String jpql = "SELECT emp FROM Employee emp WHERE emp.salary > ALL (SELECT m.salary FROM Manager m WHERE m.department = emp.department)";
        String expectedSQL = "SELECT t0.empId, t0.EMP_TYPE, t2.id, t2.city, t2.country, t2.county, t2.state, t2.street, t3.userid, t3.DTYPE, t3.age, t3.compName, t3.creditRating, t3.name, t2.zipCode, t4.deptNo, t4.name, t5.id, t5.annualMiles, t5.name, t6.id, t7.deptNo, t7.name, t6.name, t6.salary, t0.name, t0.rating, t0.salary, t8.empId, t8.EMP_TYPE, t8.ADDRESS_ID, t8.DEPARTMENT_DEPTNO, t8.FREQUENTFLIERPLAN_ID, t8.MANAGER_ID, t8.name, t8.rating, t8.salary, t8.hireDate, t0.hireDate FROM CR_EMP t0 LEFT OUTER JOIN CR_ADDR t2 ON t0.ADDRESS_ID = t2.id LEFT OUTER JOIN CR_DEPT t4 ON t0.DEPARTMENT_DEPTNO = t4.deptNo LEFT OUTER JOIN FrequentFlierPlan t5 ON t0.FREQUENTFLIERPLAN_ID = t5.id LEFT OUTER JOIN CR_MGR t6 ON t0.MANAGER_ID = t6.id LEFT OUTER JOIN CR_EMP t8 ON t0.SPOUSE_EMPID = t8.empId LEFT OUTER JOIN CompUser t3 ON t2.id = t3.ADD_ID LEFT OUTER JOIN CR_DEPT t7 ON t6.DEPARTMENT_DEPTNO = t7.deptNo WHERE (t0.salary > ALL (SELECT t1.salary FROM CR_MGR t1 WHERE (t1.DEPARTMENT_DEPTNO = t0.DEPARTMENT_DEPTNO)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        q.select((Selection)emp);
        Subquery sq = q.subquery(BigDecimal.class);
        Root m = sq.from(Manager.class);
        sq.where((Expression)this.cb.equal((Expression)m.get(Manager_.department), (Expression)emp.get(Employee_.department)));
        sq.select((Expression)m.get(Manager_.salary));
        q.where((Expression)this.cb.gt((Expression)emp.get(Employee_.salary), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries4() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM c.orders o) > 10";
        String expectedSQL = "SELECT t0.id, t0.accountNum, t3.id, t3.city, t3.country, t3.county, t3.state, t3.street, t4.userid, t4.DTYPE, t4.age, t4.compName, t4.creditRating, t4.name, t3.zipCode, t0.balanceOwed, t0.creditRating, t0.filledOrderCount, t0.firstName, t0.lastName, t0.name, t0.status FROM CR_CUST t0 LEFT OUTER JOIN CR_ADDR t3 ON t0.ADDRESS_ID = t3.id LEFT OUTER JOIN CompUser t4 ON t3.id = t4.ADD_ID WHERE ((SELECT COUNT(t2.id) FROM CR_ODR t1, CR_ODR t2 WHERE (t1.id = t2.id) AND (t0.id = t1.CUSTOMER_ID)) > ?)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Long.class);
        Root csq = sq.correlate(c);
        SetJoin o = csq.join(Customer_.orders);
        q.where((Expression)this.cb.gt((Expression)sq.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries4a() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM Customer c1 JOIN c1.orders o WHERE c = c1) > 10";
        String expectedSQL = "SELECT t2.id, t2.accountNum, t3.id, t3.city, t3.country, t3.county, t3.state, t3.street, t4.userid, t4.DTYPE, t4.age, t4.compName, t4.creditRating, t4.name, t3.zipCode, t2.balanceOwed, t2.creditRating, t2.filledOrderCount, t2.firstName, t2.lastName, t2.name, t2.status FROM CR_CUST t2 LEFT OUTER JOIN CR_ADDR t3 ON t2.ADDRESS_ID = t3.id LEFT OUTER JOIN CompUser t4 ON t3.id = t4.ADD_ID WHERE ((SELECT COUNT(t1.id) FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID WHERE (t2.id = t0.id)) > ?)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Long.class);
        Root c1 = sq.from(Customer.class);
        SetJoin o = c1.join(Customer_.orders);
        sq.where((Expression)this.cb.equal((Expression)c, (Expression)c1));
        q.where((Expression)this.cb.gt((Expression)sq.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries4b() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM Customer c1 JOIN c1.orders o WHERE c.id = c1.id) > 10";
        String expectedSQL = "SELECT t2.id, t2.accountNum, t3.id, t3.city, t3.country, t3.county, t3.state, t3.street, t4.userid, t4.DTYPE, t4.age, t4.compName, t4.creditRating, t4.name, t3.zipCode, t2.balanceOwed, t2.creditRating, t2.filledOrderCount, t2.firstName, t2.lastName, t2.name, t2.status FROM CR_CUST t2 LEFT OUTER JOIN CR_ADDR t3 ON t2.ADDRESS_ID = t3.id LEFT OUTER JOIN CompUser t4 ON t3.id = t4.ADD_ID WHERE ((SELECT COUNT(t1.id) FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID WHERE (t2.id = t0.id)) > ?)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Long.class);
        Root c1 = sq.from(Customer.class);
        SetJoin o = c1.join(Customer_.orders);
        sq.where((Expression)this.cb.equal((Expression)c.get(Customer_.id), (Expression)c1.get(Customer_.id)));
        q.where((Expression)this.cb.gt((Expression)sq.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries4c() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM Customer c1 JOIN c1.orders o) > 10";
        String expectedSQL = "SELECT t2.id, t2.accountNum, t3.id, t3.city, t3.country, t3.county, t3.state, t3.street, t4.userid, t4.DTYPE, t4.age, t4.compName, t4.creditRating, t4.name, t3.zipCode, t2.balanceOwed, t2.creditRating, t2.filledOrderCount, t2.firstName, t2.lastName, t2.name, t2.status FROM CR_CUST t2 LEFT OUTER JOIN CR_ADDR t3 ON t2.ADDRESS_ID = t3.id LEFT OUTER JOIN CompUser t4 ON t3.id = t4.ADD_ID WHERE ((SELECT COUNT(t1.id) FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID) > ?)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Long.class);
        Root c1 = sq.from(Customer.class);
        SetJoin o = c1.join(Customer_.orders);
        q.where((Expression)this.cb.gt((Expression)sq.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries4d() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM Customer c1 JOIN c1.orders o WHERE c.address.county = c1.address.county) > 10";
        String expectedSQL = "SELECT t2.id, t2.accountNum, t5.id, t5.city, t5.country, t5.county, t5.state, t5.street, t6.userid, t6.DTYPE, t6.age, t6.compName, t6.creditRating, t6.name, t5.zipCode, t2.balanceOwed, t2.creditRating, t2.filledOrderCount, t2.firstName, t2.lastName, t2.name, t2.status FROM CR_CUST t2 INNER JOIN CR_ADDR t3 ON t2.ADDRESS_ID = t3.id LEFT OUTER JOIN CR_ADDR t5 ON t2.ADDRESS_ID = t5.id LEFT OUTER JOIN CompUser t6 ON t5.id = t6.ADD_ID WHERE ((SELECT COUNT(t1.id) FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID INNER JOIN CR_ADDR t4 ON t0.ADDRESS_ID = t4.id WHERE (t3.county = t4.county)) > ?)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Long.class);
        Root c1 = sq.from(Customer.class);
        SetJoin o = c1.join(Customer_.orders);
        sq.where((Expression)this.cb.equal((Expression)c.get(Customer_.address).get(Address_.county), (Expression)c1.get(Customer_.address).get(Address_.county)));
        q.where((Expression)this.cb.gt((Expression)sq.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries4e() {
        String jpql = "SELECT c FROM Customer c WHERE EXISTS (SELECT o.id FROM Order o WHERE o.customer = c)";
        String expectedSQL = "SELECT t1.id, t1.accountNum, t2.id, t2.city, t2.country, t2.county, t2.state, t2.street, t3.userid, t3.DTYPE, t3.age, t3.compName, t3.creditRating, t3.name, t2.zipCode, t1.balanceOwed, t1.creditRating, t1.filledOrderCount, t1.firstName, t1.lastName, t1.name, t1.status FROM CR_CUST t1 LEFT OUTER JOIN CR_ADDR t2 ON t1.ADDRESS_ID = t2.id LEFT OUTER JOIN CompUser t3 ON t2.id = t3.ADD_ID WHERE (EXISTS (SELECT t0.id FROM CR_ODR t0 WHERE (t0.CUSTOMER_ID = t1.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Integer.class);
        Root o = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer), (Expression)c));
        sq.select((Expression)o.get(Order_.id));
        q.where((Expression)this.cb.exists(sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries5() {
        String jpql = "SELECT o FROM Order o WHERE 10000 < ALL (SELECT a.balance FROM o.customer c JOIN c.accounts a)";
        String expectedSQL = "SELECT t3.id, t3.cnt, t4.id, t4.accountNum, t5.id, t5.city, t5.country, t5.county, t5.state, t5.street, t6.userid, t6.DTYPE, t6.age, t6.compName, t6.creditRating, t6.name, t5.zipCode, t4.balanceOwed, t4.creditRating, t4.filledOrderCount, t4.firstName, t4.lastName, t4.name, t4.status, t3.delivered, t3.name, t3.orderTs, t3.quantity, t3.totalCost FROM CR_ODR t3 LEFT OUTER JOIN CR_CUST t4 ON t3.CUSTOMER_ID = t4.id LEFT OUTER JOIN CR_ADDR t5 ON t4.ADDRESS_ID = t5.id LEFT OUTER JOIN CompUser t6 ON t5.id = t6.ADD_ID WHERE (? < ALL (SELECT t2.balance FROM CR_CUST t0 INNER JOIN CR_CUST_CR_ACCT t1 ON t0.id = t1.CUSTOMER_ID INNER JOIN CR_ACCT t2 ON t1.ACCOUNTS_ID = t2.id WHERE (t3.CUSTOMER_ID = t0.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Root o1 = sq.correlate(o);
        Join c = o1.join(Order_.customer);
        ListJoin a = c.join(Customer_.accounts);
        sq.select((Expression)a.get(Account_.balance));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries5a() {
        String jpql = "SELECT o FROM Order o WHERE o.name = SOME (SELECT a.name FROM o.customer c JOIN c.accounts a)";
        String expectedSQL = "SELECT t3.id, t3.cnt, t4.id, t4.accountNum, t5.id, t5.city, t5.country, t5.county, t5.state, t5.street, t6.userid, t6.DTYPE, t6.age, t6.compName, t6.creditRating, t6.name, t5.zipCode, t4.balanceOwed, t4.creditRating, t4.filledOrderCount, t4.firstName, t4.lastName, t4.name, t4.status, t3.delivered, t3.name, t3.orderTs, t3.quantity, t3.totalCost FROM CR_ODR t3 LEFT OUTER JOIN CR_CUST t4 ON t3.CUSTOMER_ID = t4.id LEFT OUTER JOIN CR_ADDR t5 ON t4.ADDRESS_ID = t5.id LEFT OUTER JOIN CompUser t6 ON t5.id = t6.ADD_ID WHERE (t3.name = ANY (SELECT t2.name FROM CR_CUST t0 INNER JOIN CR_CUST_CR_ACCT t1 ON t0.id = t1.CUSTOMER_ID INNER JOIN CR_ACCT t2 ON t1.ACCOUNTS_ID = t2.id WHERE (t3.CUSTOMER_ID = t0.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(String.class);
        Root o1 = sq.correlate(o);
        Join c = o1.join(Order_.customer);
        ListJoin a = c.join(Customer_.accounts);
        sq.select((Expression)a.get(Account_.name));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.name), this.cb.some(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE 10000 < ALL (SELECT a.balance FROM c.accounts a)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t4.id, t4.accountNum, t5.id, t5.city, t5.country, t5.county, t5.state, t5.street, t6.userid, t6.DTYPE, t6.age, t6.compName, t6.creditRating, t6.name, t5.zipCode, t4.balanceOwed, t4.creditRating, t4.filledOrderCount, t4.firstName, t4.lastName, t4.name, t4.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t4 ON t0.CUSTOMER_ID = t4.id LEFT OUTER JOIN CR_ADDR t5 ON t4.ADDRESS_ID = t5.id LEFT OUTER JOIN CompUser t6 ON t5.id = t6.ADD_ID WHERE (? < ALL (SELECT t3.balance FROM CR_CUST_CR_ACCT t2, CR_ACCT t3 WHERE (t2.ACCOUNTS_ID = t3.id) AND (t1.id = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Join c1 = sq.correlate(c);
        ListJoin a = c1.join(Customer_.accounts);
        sq.select((Expression)a.get(Account_.balance));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6a() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE o.name = SOME (SELECT a.name FROM c.accounts a)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t4.id, t4.accountNum, t5.id, t5.city, t5.country, t5.county, t5.state, t5.street, t6.userid, t6.DTYPE, t6.age, t6.compName, t6.creditRating, t6.name, t5.zipCode, t4.balanceOwed, t4.creditRating, t4.filledOrderCount, t4.firstName, t4.lastName, t4.name, t4.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t4 ON t0.CUSTOMER_ID = t4.id LEFT OUTER JOIN CR_ADDR t5 ON t4.ADDRESS_ID = t5.id LEFT OUTER JOIN CompUser t6 ON t5.id = t6.ADD_ID WHERE (t0.name = ANY (SELECT t3.name FROM CR_CUST_CR_ACCT t2, CR_ACCT t3 WHERE (t2.ACCOUNTS_ID = t3.id) AND (t1.id = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        q.select((Selection)o);
        Subquery sq = q.subquery(String.class);
        Join c1 = sq.correlate(c);
        ListJoin a = c1.join(Customer_.accounts);
        sq.select((Expression)a.get(Account_.name));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.name), this.cb.some(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6b() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE o.name = SOME (SELECT a.county FROM c.address a)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t3.id, t3.accountNum, t4.id, t4.city, t4.country, t4.county, t4.state, t4.street, t5.userid, t5.DTYPE, t5.age, t5.compName, t5.creditRating, t5.name, t4.zipCode, t3.balanceOwed, t3.creditRating, t3.filledOrderCount, t3.firstName, t3.lastName, t3.name, t3.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t3 ON t0.CUSTOMER_ID = t3.id LEFT OUTER JOIN CR_ADDR t4 ON t3.ADDRESS_ID = t4.id LEFT OUTER JOIN CompUser t5 ON t4.id = t5.ADD_ID WHERE (t0.name = ANY (SELECT t2.county FROM CR_ADDR t2 WHERE (t1.ADDRESS_ID = t2.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        q.select((Selection)o);
        Subquery sq = q.subquery(String.class);
        Join c1 = sq.correlate(c);
        Join a = c1.join(Customer_.address);
        sq.select((Expression)a.get(Address_.county));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.name), this.cb.some(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6c() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE 10000 < ALL (SELECT u.age FROM c.address a JOIN a.user u)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t4.id, t4.accountNum, t5.id, t5.city, t5.country, t5.county, t5.state, t5.street, t6.userid, t6.DTYPE, t6.age, t6.compName, t6.creditRating, t6.name, t5.zipCode, t4.balanceOwed, t4.creditRating, t4.filledOrderCount, t4.firstName, t4.lastName, t4.name, t4.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t4 ON t0.CUSTOMER_ID = t4.id LEFT OUTER JOIN CR_ADDR t5 ON t4.ADDRESS_ID = t5.id LEFT OUTER JOIN CompUser t6 ON t5.id = t6.ADD_ID WHERE (? < ALL (SELECT t3.age FROM CR_ADDR t2 INNER JOIN CompUser t3 ON t2.id = t3.ADD_ID WHERE (t1.ADDRESS_ID = t2.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Join c1 = sq.correlate(c);
        Join a = c1.join(Customer_.address);
        Join u = a.join(Address_.user);
        sq.select((Expression)u.get(CompUser_.age));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6d() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c JOIN c.address a WHERE 10000 < ALL (SELECT u.age FROM c.address a1 JOIN a1.user u WHERE a.city = a1.city)";
        String expectedSQL = "SELECT t2.id, t2.cnt, t5.id, t5.accountNum, t6.id, t6.city, t6.country, t6.county, t6.state, t6.street, t7.userid, t7.DTYPE, t7.age, t7.compName, t7.creditRating, t7.name, t6.zipCode, t5.balanceOwed, t5.creditRating, t5.filledOrderCount, t5.firstName, t5.lastName, t5.name, t5.status, t2.delivered, t2.name, t2.orderTs, t2.quantity, t2.totalCost FROM CR_ODR t2 INNER JOIN CR_CUST t3 ON t2.CUSTOMER_ID = t3.id LEFT OUTER JOIN CR_CUST t5 ON t2.CUSTOMER_ID = t5.id INNER JOIN CR_ADDR t4 ON t3.ADDRESS_ID = t4.id LEFT OUTER JOIN CR_ADDR t6 ON t5.ADDRESS_ID = t6.id LEFT OUTER JOIN CompUser t7 ON t6.id = t7.ADD_ID WHERE (? < ALL (SELECT t1.age FROM CR_ADDR t0 INNER JOIN CompUser t1 ON t0.id = t1.ADD_ID WHERE (t4.city = t0.city AND t3.ADDRESS_ID = t0.id)) AND 1 = 1)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        Join a = c.join(Customer_.address);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Join c1 = sq.correlate(c);
        Join a1 = c1.join(Customer_.address);
        Join u = a1.join(Address_.user);
        sq.select((Expression)u.get(CompUser_.age));
        sq.where((Expression)this.cb.equal((Expression)a.get(Address_.city), (Expression)a1.get(Address_.city)));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6e() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c JOIN c.address a WHERE 10000 < ALL (SELECT u.age FROM a.user u)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t5.id, t5.accountNum, t6.id, t6.city, t6.country, t6.county, t6.state, t6.street, t7.userid, t7.DTYPE, t7.age, t7.compName, t7.creditRating, t7.name, t6.zipCode, t5.balanceOwed, t5.creditRating, t5.filledOrderCount, t5.firstName, t5.lastName, t5.name, t5.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t5 ON t0.CUSTOMER_ID = t5.id INNER JOIN CR_ADDR t2 ON t1.ADDRESS_ID = t2.id LEFT OUTER JOIN CR_ADDR t6 ON t5.ADDRESS_ID = t6.id LEFT OUTER JOIN CompUser t7 ON t6.id = t7.ADD_ID WHERE (? < ALL (SELECT t4.age FROM CompUser t3, CompUser t4 WHERE (t3.userid = t4.userid) AND (t2.id = t3.ADD_ID)) AND 1 = 1)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        Join a = c.join(Customer_.address);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Join a1 = sq.correlate(a);
        Join u = a1.join(Address_.user);
        sq.select((Expression)u.get(CompUser_.age));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6f() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE 10000 < ALL (SELECT u.age FROM c.address.user u)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t5.id, t5.accountNum, t6.id, t6.city, t6.country, t6.county, t6.state, t6.street, t7.userid, t7.DTYPE, t7.age, t7.compName, t7.creditRating, t7.name, t6.zipCode, t5.balanceOwed, t5.creditRating, t5.filledOrderCount, t5.firstName, t5.lastName, t5.name, t5.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t5 ON t0.CUSTOMER_ID = t5.id LEFT OUTER JOIN CR_ADDR t6 ON t5.ADDRESS_ID = t6.id LEFT OUTER JOIN CompUser t7 ON t6.id = t7.ADD_ID WHERE (? < ALL (SELECT t4.age FROM CR_ADDR t2 INNER JOIN CompUser t3 ON t2.id = t3.ADD_ID, CompUser t4 WHERE (t3.userid = t4.userid) AND (t1.ADDRESS_ID = t2.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
    }

    public void testSubqueries6g() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE 10000 < ALL (SELECT u.age FROM c.address a JOIN a.user u)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t4.id, t4.accountNum, t5.id, t5.city, t5.country, t5.county, t5.state, t5.street, t6.userid, t6.DTYPE, t6.age, t6.compName, t6.creditRating, t6.name, t5.zipCode, t4.balanceOwed, t4.creditRating, t4.filledOrderCount, t4.firstName, t4.lastName, t4.name, t4.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t4 ON t0.CUSTOMER_ID = t4.id LEFT OUTER JOIN CR_ADDR t5 ON t4.ADDRESS_ID = t5.id LEFT OUTER JOIN CompUser t6 ON t5.id = t6.ADD_ID WHERE (? < ALL (SELECT t3.age FROM CR_ADDR t2 INNER JOIN CompUser t3 ON t2.id = t3.ADD_ID WHERE (t1.ADDRESS_ID = t2.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Join c1 = sq.correlate(c);
        Join u = c1.join(Customer_.address).join(Address_.user);
        sq.select((Expression)u.get(CompUser_.age));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueries6h() {
        String jpql = "SELECT o FROM Order o JOIN o.customer.address a WHERE 10000 < ALL (SELECT u.age FROM a.user u)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t1.id, t1.accountNum, t6.id, t6.city, t6.country, t6.county, t6.state, t6.street, t7.userid, t7.DTYPE, t7.age, t7.compName, t7.creditRating, t7.name, t6.zipCode, t1.balanceOwed, t1.creditRating, t1.filledOrderCount, t1.firstName, t1.lastName, t1.name, t1.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id INNER JOIN CR_ADDR t2 ON t1.ADDRESS_ID = t2.id LEFT OUTER JOIN CR_ADDR t6 ON t1.ADDRESS_ID = t6.id LEFT OUTER JOIN CompUser t7 ON t6.id = t7.ADD_ID WHERE (? < ALL (SELECT t5.age FROM CR_CUST t3, CompUser t4, CompUser t5 WHERE (t4.userid = t5.userid) AND (t0.CUSTOMER_ID = t3.id) AND (t2.id = t4.ADD_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
    }

    public void testExist1() {
        String jpql = "SELECT DISTINCT c.name FROM CompUser c WHERE EXISTS (SELECT a FROM Address a WHERE a = c.address )";
        String expectedSQL = "SELECT DISTINCT t1.name FROM CompUser t1 WHERE (EXISTS (SELECT t0.id FROM CR_ADDR t0 WHERE (t0.id = t1.ADD_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root c = q.from(CompUser.class);
        q.select((Selection)c.get(CompUser_.name)).distinct(true);
        Subquery sq = q.subquery(Address.class);
        Root a = sq.from(Address.class);
        sq.select((Expression)a);
        sq.where((Expression)this.cb.equal((Expression)a, (Expression)c.get(CompUser_.address)));
        q.where((Expression)this.cb.exists(sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExist1a() {
        String jpql = "SELECT DISTINCT o.name FROM CompUser o WHERE EXISTS (SELECT s FROM CompUser s WHERE s.address.country = o.address.country)";
        String expectedSQL = "SELECT DISTINCT t2.name FROM CompUser t2 INNER JOIN CR_ADDR t3 ON t2.ADD_ID = t3.id WHERE (EXISTS (SELECT t0.userid FROM CompUser t0 INNER JOIN CR_ADDR t1 ON t0.ADD_ID = t1.id WHERE (t1.country = t3.country)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root o = q.from(CompUser.class);
        q.select((Selection)o.get(CompUser_.name)).distinct(true);
        Subquery sq = q.subquery(CompUser.class);
        Root s = sq.from(CompUser.class);
        sq.select((Expression)s);
        sq.where((Expression)this.cb.equal((Expression)s.get(CompUser_.address).get(Address_.country), (Expression)o.get(CompUser_.address).get(Address_.country)));
        q.where((Expression)this.cb.exists(sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExist1b() {
        String jpql = "select c from Customer c left join c.orders o where exists (select o2 from c.orders o2 where o2 = o)";
        String expectedSQL = "SELECT t0.id, t0.accountNum, t4.id, t4.city, t4.country, t4.county, t4.state, t4.street, t5.userid, t5.DTYPE, t5.age, t5.compName, t5.creditRating, t5.name, t4.zipCode, t0.balanceOwed, t0.creditRating, t0.filledOrderCount, t0.firstName, t0.lastName, t0.name, t0.status FROM CR_CUST t0 LEFT OUTER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID LEFT OUTER JOIN CR_ADDR t4 ON t0.ADDRESS_ID = t4.id LEFT OUTER JOIN CompUser t5 ON t4.id = t5.ADD_ID WHERE (EXISTS (SELECT t3.id FROM CR_ODR t2, CR_ODR t3 WHERE (t1.id = t3.id AND t2.id = t3.id) AND (t0.id = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders, JoinType.LEFT);
        q.select((Selection)c);
        Subquery sq = q.subquery(Order.class);
        Root c1 = sq.correlate(c);
        SetJoin o2 = c1.join(Customer_.orders);
        sq.select((Expression)o2);
        sq.where((Expression)this.cb.equal((Expression)o2, (Expression)o));
        q.where((Expression)this.cb.exists(sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testNotExist1() {
        String jpql = "SELECT DISTINCT c.name FROM CompUser c WHERE NOT EXISTS (SELECT a FROM Address a WHERE a = c.address )";
        String expectedSQL = "SELECT DISTINCT t1.name FROM CompUser t1 WHERE (NOT (EXISTS (SELECT t0.id FROM CR_ADDR t0 WHERE (t0.id = t1.ADD_ID))))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root c = q.from(CompUser.class);
        q.select((Selection)c.get(CompUser_.name)).distinct(true);
        Subquery sq = q.subquery(Address.class);
        Root a = sq.from(Address.class);
        sq.select((Expression)a);
        sq.where((Expression)this.cb.equal((Expression)a, (Expression)c.get(CompUser_.address)));
        q.where((Expression)this.cb.exists(sq).not());
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testNotExist1a() {
        String jpql = "select c from Customer c left join c.orders o where not exists (select o2 from c.orders o2 where o2 = o)";
        String expectedSQL = "SELECT t0.id, t0.accountNum, t4.id, t4.city, t4.country, t4.county, t4.state, t4.street, t5.userid, t5.DTYPE, t5.age, t5.compName, t5.creditRating, t5.name, t4.zipCode, t0.balanceOwed, t0.creditRating, t0.filledOrderCount, t0.firstName, t0.lastName, t0.name, t0.status FROM CR_CUST t0 LEFT OUTER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID LEFT OUTER JOIN CR_ADDR t4 ON t0.ADDRESS_ID = t4.id LEFT OUTER JOIN CompUser t5 ON t4.id = t5.ADD_ID WHERE (NOT (EXISTS (SELECT t3.id FROM CR_ODR t2, CR_ODR t3 WHERE (t1.id = t3.id AND t2.id = t3.id) AND (t0.id = t2.CUSTOMER_ID))))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders, JoinType.LEFT);
        q.select((Selection)c);
        Subquery sq = q.subquery(Order.class);
        Root c1 = sq.correlate(c);
        SetJoin o2 = c1.join(Customer_.orders);
        sq.select((Expression)o2);
        sq.where((Expression)this.cb.equal((Expression)o2, (Expression)o));
        q.where((Expression)this.cb.exists(sq).not());
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testAny() {
        String jpql = "SELECT o.name FROM CompUser o WHERE o.address.zipCode = ANY (SELECT s.computerName  FROM CompUser s WHERE s.address.country IS NOT NULL)";
        String expectedSQL = "SELECT t0.name FROM CompUser t0 INNER JOIN CR_ADDR t1 ON t0.ADD_ID = t1.id WHERE (t1.zipCode = ANY (SELECT t2.compName FROM CompUser t2 INNER JOIN CR_ADDR t3 ON t2.ADD_ID = t3.id WHERE (t3.country IS NOT NULL)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root o = q.from(CompUser.class);
        q.select((Selection)o.get(CompUser_.name));
        Subquery sq = q.subquery(String.class);
        Root s = sq.from(CompUser.class);
        sq.select((Expression)s.get(CompUser_.computerName));
        sq.where((Expression)this.cb.isNotNull((Expression)s.get(CompUser_.address).get(Address_.country)));
        q.where((Expression)this.cb.equal((Expression)o.get(CompUser_.address).get(Address_.zipCode), this.cb.any(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery01() {
        String jpql = "select o1.id from Order o1 where o1.id in  (select distinct o.id from LineItem i, Order o where i.quantity > 10 and o.count > 1000 and i.id = o.id)";
        String crossJoin = this.getDictionary() instanceof DerbyDictionary ? "JOIN CR_ODR t2 ON (1 = 1)" : "CROSS JOIN CR_ODR t2";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.id IN (SELECT DISTINCT t2.id FROM CR_ODR t1 " + crossJoin + ", CR_LI t3 WHERE (" + "t3.quantity > ? AND t2.cnt > ? AND t3.id = t2.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o1 = q.from(Order.class);
        q.select((Selection)o1.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root i = sq.from(LineItem.class);
        Root o = sq.from(Order.class);
        sq.select((Expression)o.get(Order_.id)).distinct(true);
        sq.where(new Predicate[]{this.cb.gt((Expression)i.get(LineItem_.quantity), (Number)10), this.cb.gt((Expression)o.get(Order_.count), (Number)1000), this.cb.equal((Expression)i.get(LineItem_.id), (Expression)o.get(Order_.id))});
        q.where((Expression)o1.get(Order_.id).in(new Expression[]{sq}));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery02() {
        String jpql = "select o.id from Order o where o.customer.balanceOwed = (select max(o2.customer.balanceOwed) from Order o2 where o.customer.id = o2.customer.id)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id WHERE (t1.balanceOwed = (SELECT MAX(t3.balanceOwed) FROM CR_ODR t2 INNER JOIN CR_CUST t3 ON t2.CUSTOMER_ID = t3.id WHERE (t0.CUSTOMER_ID = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root o2 = sq.from(Order.class);
        sq.select(this.cb.max((Expression)o2.get(Order_.customer).get(Customer_.balanceOwed)));
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.balanceOwed), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery03() {
        String jpql = "select o from Order o where o.customer.balanceOwed = (select max(o2.customer.balanceOwed) from Order o2 where o.customer.id = o2.customer.id)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t1.id, t1.accountNum, t4.id, t4.city, t4.country, t4.county, t4.state, t4.street, t5.userid, t5.DTYPE, t5.age, t5.compName, t5.creditRating, t5.name, t4.zipCode, t1.balanceOwed, t1.creditRating, t1.filledOrderCount, t1.firstName, t1.lastName, t1.name, t1.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_ADDR t4 ON t1.ADDRESS_ID = t4.id LEFT OUTER JOIN CompUser t5 ON t4.id = t5.ADD_ID WHERE (t1.balanceOwed = (SELECT MAX(t3.balanceOwed) FROM CR_ODR t2 INNER JOIN CR_CUST t3 ON t2.CUSTOMER_ID = t3.id WHERE (t0.CUSTOMER_ID = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Root o2 = sq.from(Order.class);
        sq.select(this.cb.max((Expression)o2.get(Order_.customer).get(Customer_.balanceOwed)));
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.balanceOwed), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery04() {
        String jpql = "select o.id from Order o where o.quantity > (select count(i) from o.lineItems i)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.quantity > (SELECT COUNT(t2.id) FROM CR_LI t1, CR_LI t2 WHERE (t1.id = t2.id) AND (t0.id = t1.ORDER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Long.class);
        Root o2 = sq.correlate(o);
        ListJoin i = o2.join(Order_.lineItems);
        sq.select(this.cb.count((Expression)i));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery05() {
        String jpql = "select o.id from Order o where o.quantity > (select count(o.quantity) from Order o)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.quantity > (SELECT COUNT(t1.quantity) FROM CR_ODR t1))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Long.class);
        Root o2 = sq.from(Order.class);
        sq.select(this.cb.count((Expression)o2.get(Order_.quantity)));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery06() {
        String jpql = "select o.id from Order o where o.quantity > (select count(o.id) from Order o)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.quantity > (SELECT COUNT(t1.id) FROM CR_ODR t1))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Long.class);
        Root o2 = sq.from(Order.class);
        sq.select(this.cb.count((Expression)o2.get(Order_.id)));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery07() {
        String jpql = "select o.id from Order o where o.quantity > (select avg(o.quantity) from Order o)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.quantity > (SELECT AVG(t1.quantity) FROM CR_ODR t1))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Double.class);
        Root o2 = sq.from(Order.class);
        sq.select(this.cb.avg((Expression)o2.get(Order_.quantity)));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery08() {
        String jpql = "select c.name from Customer c where exists (select o from c.orders o where o.id = 1) or exists (select o from c.orders o where o.id = 2)";
        String expectedSQL = "SELECT t0.name FROM CR_CUST t0 WHERE (EXISTS (SELECT t2.id FROM CR_ODR t1, CR_ODR t2 WHERE (t2.id = ? AND t1.id = t2.id) AND (t0.id = t1.CUSTOMER_ID)) OR EXISTS (SELECT t4.id FROM CR_ODR t3, CR_ODR t4 WHERE (t4.id = ? AND t3.id = t4.id) AND (t0.id = t3.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c.get(Customer_.name));
        Subquery sq1 = q.subquery(Order.class);
        Root c1 = sq1.correlate(c);
        SetJoin o1 = c1.join(Customer_.orders);
        sq1.select((Expression)o1);
        sq1.where((Expression)this.cb.equal((Expression)o1.get(Order_.id), (Object)1));
        Subquery sq2 = q.subquery(Order.class);
        Root c2 = sq2.correlate(c);
        SetJoin o2 = c2.join(Customer_.orders);
        sq2.select((Expression)o2);
        sq2.where((Expression)this.cb.equal((Expression)o2.get(Order_.id), (Object)2));
        q.where((Expression)this.cb.or((Expression)this.cb.exists(sq1), (Expression)this.cb.exists(sq2)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery09() {
        String jpql = "select c.name from Customer c, in(c.orders) o where o.quantity between (select max(o.quantity) from Order o) and (select avg(o.quantity) from Order o) ";
        String expectedSQL = "SELECT t0.name FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID WHERE (t1.quantity >= (SELECT MAX(t2.quantity) FROM CR_ODR t2) AND t1.quantity <= (SELECT AVG(t3.quantity) FROM CR_ODR t3))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        q.select((Selection)c.get(Customer_.name));
        Subquery sq1 = q.subquery(Integer.class);
        Root o1 = sq1.from(Order.class);
        sq1.select(this.cb.max((Expression)o1.get(Order_.quantity)));
        Subquery sq2 = q.subquery(Double.class);
        Root o2 = sq2.from(Order.class);
        sq2.select(this.cb.avg((Expression)o2.get(Order_.quantity)));
        q.where((Expression)this.cb.between((Expression)o.get(Order_.quantity), (Expression)sq1, sq2.as(Integer.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery10() {
        String jpql = "select o.id from Order o where o.quantity > (select sum(o2.quantity) from Customer c, in(c.orders) o2) ";
        String expectedSQL = "SELECT t2.id FROM CR_ODR t2 WHERE (t2.quantity > (SELECT SUM(t1.quantity) FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root c = sq.from(Customer.class);
        SetJoin o2 = c.join(Customer_.orders);
        sq.select(this.cb.sum((Expression)o2.get(Order_.quantity)));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery11() {
        String jpql = "select o.id from Order o where o.quantity between (select avg(o2.quantity) from Customer c, in(c.orders) o2) and (select min(o2.quantity) from Customer c, in(c.orders) o2)";
        String expectedSQL = "SELECT t4.id FROM CR_ODR t4 WHERE (t4.quantity >= (SELECT AVG(t1.quantity) FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID) AND t4.quantity <= (SELECT MIN(t3.quantity) FROM CR_CUST t2 INNER JOIN CR_ODR t3 ON t2.id = t3.CUSTOMER_ID))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq1 = q.subquery(Double.class);
        Root c = sq1.from(Customer.class);
        SetJoin o2 = c.join(Customer_.orders);
        sq1.select(this.cb.avg((Expression)o2.get(Order_.quantity)));
        Subquery sq2 = q.subquery(Integer.class);
        Root c2 = sq2.from(Customer.class);
        SetJoin o3 = c2.join(Customer_.orders);
        sq2.select(this.cb.min((Expression)o3.get(Order_.quantity)));
        q.where((Expression)this.cb.between((Expression)o.get(Order_.quantity), sq1.as(Integer.class), (Expression)sq2));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery12() {
        String jpql = "select o.id from Customer c, in(c.orders)o where o.quantity > (select sum(o2.quantity) from c.orders o2)";
        String expectedSQL = "SELECT t1.id FROM CR_CUST t0 INNER JOIN CR_ODR t1 ON t0.id = t1.CUSTOMER_ID WHERE (t1.quantity > (SELECT SUM(t3.quantity) FROM CR_ODR t2, CR_ODR t3 WHERE (t2.id = t3.id) AND (t0.id = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(Customer_.orders);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root c1 = sq.correlate(c);
        SetJoin o2 = c1.join(Customer_.orders);
        sq.select(this.cb.sum((Expression)o2.get(Order_.quantity)));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery13() {
        String jpql = "select o1.id, c.name from Order o1, Customer c where o1.quantity =  any(select o2.quantity from in(c.orders) o2)";
        String crossJoin = this.getDictionary() instanceof DerbyDictionary ? "JOIN CR_CUST t1 ON (1 = 1)" : "CROSS JOIN CR_CUST t1";
        String expectedSQL = "SELECT t0.id, t1.name FROM CR_ODR t0 " + crossJoin + " WHERE (t0.quantity = ANY (" + "SELECT t3.quantity FROM CR_ODR t2, CR_ODR t3 WHERE (t2.id = t3.id) AND (t1.id = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root o1 = q.from(Order.class);
        Root c = q.from(Customer.class);
        q.multiselect(new Selection[]{o1.get(Order_.id), c.get(Customer_.name)});
        Subquery sq = q.subquery(Integer.class);
        Root c1 = sq.correlate(c);
        SetJoin o2 = c1.join(Customer_.orders);
        sq.select((Expression)o2.get(Order_.quantity));
        q.where((Expression)this.cb.equal((Expression)o1.get(Order_.quantity), this.cb.any(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery14() {
        String jpql = "SELECT p, m FROM Publisher p LEFT OUTER JOIN p.magazineCollection m WHERE m.id = (SELECT MAX(m2.id) FROM Magazine m2 WHERE m2.idPublisher.id = p.id AND m2.id = (SELECT MAX(m3.id) FROM Magazine m3 WHERE m3.idPublisher.id = p.id)) ";
        String expectedSQL = "SELECT t0.id, t1.id, t1.date_published, t1.id_publisher, t1.name FROM CR_PSH t0 LEFT OUTER JOIN CR_MG t1 ON t0.id = t1.id_publisher WHERE (t1.id = (SELECT MAX(t2.id) FROM CR_MG t2 WHERE (t2.id_publisher = t0.id AND t2.id = (SELECT MAX(t3.id) FROM CR_MG t3 WHERE (t3.id_publisher = t0.id)))))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root p = q.from(Publisher.class);
        SetJoin m = p.join(Publisher_.magazineCollection, JoinType.LEFT);
        q.multiselect(new Selection[]{p, m});
        Subquery sq = q.subquery(Integer.class);
        Root m2 = sq.from(Magazine.class);
        sq.select(this.cb.max((Expression)m2.get(Magazine_.id)));
        Subquery sq2 = sq.subquery(Integer.class);
        Root m3 = sq2.from(Magazine.class);
        sq2.select(this.cb.max((Expression)m3.get(Magazine_.id)));
        sq2.where((Expression)this.cb.equal((Expression)m3.get(Magazine_.idPublisher).get(Publisher_.id), (Expression)p.get(Publisher_.id)));
        sq.where(new Predicate[]{this.cb.equal((Expression)m2.get(Magazine_.idPublisher).get(Publisher_.id), (Expression)p.get(Publisher_.id)), this.cb.equal((Expression)m2.get(Magazine_.id), (Expression)sq2)});
        q.where((Expression)this.cb.equal((Expression)m.get(Magazine_.id), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery15() {
        String jpql = "select o.id from Order o where o.delivered =(select    CASE WHEN o2.quantity > 10 THEN true     WHEN o2.quantity = 10 THEN false      ELSE false END from Order o2 where o.customer.id = o2.customer.id)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.delivered = (SELECT  CASE  WHEN t1.quantity > ? THEN 1 WHEN t1.quantity = ? THEN 0 ELSE 0 END  FROM CR_ODR t1 WHERE (t0.CUSTOMER_ID = t1.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Object.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        sq.select(this.cb.selectCase().when((Expression)this.cb.gt((Expression)o2.get(Order_.quantity), (Number)10), (Object)true).when((Expression)this.cb.equal((Expression)o2.get(Order_.quantity), (Object)10), (Object)false).otherwise((Object)false));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.delivered), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery16() {
        String jpql = "select o1.id from Order o1 where o1.quantity >  (select o.quantity*2 from LineItem i, Order o where i.quantity > 10 and o.quantity > 1000 and i.id = o.id)";
        String crossJoin = this.getDictionary() instanceof DerbyDictionary ? "JOIN CR_ODR t2 ON (1 = 1)" : "CROSS JOIN CR_ODR t2";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.quantity > (SELECT (t2.quantity * ?) FROM CR_ODR t1 " + crossJoin + ", CR_LI t3 WHERE (" + "t3.quantity > ? AND t2.quantity > ? AND t3.id = t2.id)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o1 = q.from(Order.class);
        q.select((Selection)o1.get(Order_.id));
        Subquery sq = q.subquery(Integer.class);
        Root i = sq.from(LineItem.class);
        Root o = sq.from(Order.class);
        sq.where((Expression)this.cb.and((Expression)this.cb.and((Expression)this.cb.gt((Expression)i.get(LineItem_.quantity), (Number)10), (Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Number)1000)), (Expression)this.cb.equal((Expression)i.get(LineItem_.id), (Expression)o.get(Order_.id))));
        q.where((Expression)this.cb.gt((Expression)o1.get(Order_.quantity), (Expression)sq.select(this.cb.prod((Expression)o.get(Order_.quantity), (Number)2))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery17() {
        String jpql = "select o.id from Order o where o.customer.name = (select substring(o2.customer.name, 3) from Order o2 where o.customer.id = o2.customer.id)";
        String useCast = this.getDictionary() instanceof DerbyDictionary ? "SUBSTR(CAST((t3.name) AS VARCHAR(1000)), 3) " : "SUBSTRING(t3.name, 3) ";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id WHERE (t1.name = (SELECT " + useCast + "FROM CR_ODR t2 INNER JOIN CR_CUST t3 ON t2.CUSTOMER_ID = t3.id " + "WHERE (t0.CUSTOMER_ID = t2.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(String.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        q.where((Expression)this.cb.equal((Expression)o.get(Order_.customer).get(Customer_.name), (Expression)sq.select(this.cb.substring((Expression)o2.get(Order_.customer).get(Customer_.name), 3))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery18() {
        String jpql = "select o.id from Order o where o.orderTs > (select CURRENT_TIMESTAMP from o.lineItems i)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.orderTs > (SELECT CURRENT_TIMESTAMP FROM CR_LI t1, CR_LI t2 WHERE (t1.id = t2.id) AND (t0.id = t1.ORDER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Timestamp.class);
        Root o2 = sq.correlate(o);
        ListJoin i = o2.join(Order_.lineItems);
        q.where((Expression)this.cb.greaterThan(o.get(Order_.orderTs).as(Long.class), sq.select(this.cb.currentTimestamp()).as(Long.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery19() {
        String jpql = "select o.id from Order o where o.quantity > (select SQRT(o.quantity) from Order o where o.delivered = true)";
        String expectedSQL = "SELECT t0.id FROM CR_ODR t0 WHERE (t0.quantity > (SELECT SQRT(t1.quantity) FROM CR_ODR t1 WHERE (t1.delivered = ?)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(Double.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)o2.get(Order_.delivered), (Object)true));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.quantity), (Expression)sq.select(this.cb.sqrt((Expression)o2.get(Order_.quantity)))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery20() {
        String jpql = "select o.id from Order o where o.customer.name in (select CONCAT(o.customer.name, 'XX') from Order o where o.quantity > 10)";
        String useCast = this.getDictionary() instanceof DerbyDictionary ? "(CAST(t1.name AS VARCHAR(1000)) || CAST(? AS VARCHAR(1000))) " : "CONCAT(t1.name,?) ";
        String expectedSQL = "SELECT t2.id FROM CR_ODR t2 INNER JOIN CR_CUST t3 ON t2.CUSTOMER_ID = t3.id WHERE (t3.name IN (SELECT " + useCast + "FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id WHERE (t0.quantity > ?)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        q.select((Selection)o.get(Order_.id));
        Subquery sq = q.subquery(String.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.gt((Expression)o2.get(Order_.quantity), (Number)10));
        q.where((Expression)this.cb.in((Expression)o.get(Order_.customer).get(Customer_.name)).value((Expression)sq.select(this.cb.concat((Expression)o2.get(Order_.customer).get(Customer_.name), "XX"))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery21() {
        String jpql = "select c from Customer c where c.creditRating = (select CASE WHEN o2.quantity > 10 THEN             Customer$CreditRating.POOR         WHEN o2.quantity = 10 THEN             Customer$CreditRating.GOOD         ELSE             Customer$CreditRating.EXCELLENT         END from Order o2    where c.id = o2.customer.id)";
        String expectedSQL = "SELECT t0.id, t0.accountNum, t2.id, t2.city, t2.country, t2.county, t2.state, t2.street, t3.userid, t3.DTYPE, t3.age, t3.compName, t3.creditRating, t3.name, t2.zipCode, t0.balanceOwed, t0.creditRating, t0.filledOrderCount, t0.firstName, t0.lastName, t0.name, t0.status FROM CR_CUST t0 LEFT OUTER JOIN CR_ADDR t2 ON t0.ADDRESS_ID = t2.id LEFT OUTER JOIN CompUser t3 ON t2.id = t3.ADD_ID WHERE (t0.creditRating = (SELECT  CASE  WHEN t1.quantity > ? THEN 0 WHEN t1.quantity = ? THEN 1 ELSE 2 END  FROM CR_ODR t1 WHERE (t0.id = t1.CUSTOMER_ID)))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Object.class);
        Root o2 = sq.from(Order.class);
        sq.where((Expression)this.cb.equal((Expression)c.get(Customer_.id), (Expression)o2.get(Order_.customer).get(Customer_.id)));
        Expression generalCase = this.cb.selectCase().when((Expression)this.cb.gt((Expression)o2.get(Order_.quantity), (Number)10), (Object)Customer.CreditRating.POOR).when((Expression)this.cb.equal((Expression)o2.get(Order_.quantity), (Object)10), (Object)Customer.CreditRating.GOOD).otherwise((Object)Customer.CreditRating.EXCELLENT);
        sq.select(generalCase);
        q.where((Expression)this.cb.equal((Expression)c.get(Customer_.creditRating), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery22() {
        String jpql = "select c from Customer c where c.creditRating = (select COALESCE (c1.creditRating, org.apache.openjpa.persistence.criteria.Customer$CreditRating.POOR) from Customer c1 where c1.name = 'Famzy') order by c.name DESC";
        String expectedSQL = "SELECT t0.id, t0.accountNum, t2.id, t2.city, t2.country, t2.county, t2.state, t2.street, t3.userid, t3.DTYPE, t3.age, t3.compName, t3.creditRating, t3.name, t2.zipCode, t0.balanceOwed, t0.creditRating, t0.filledOrderCount, t0.firstName, t0.lastName, t0.name, t0.status FROM CR_CUST t0 LEFT OUTER JOIN CR_ADDR t2 ON t0.ADDRESS_ID = t2.id LEFT OUTER JOIN CompUser t3 ON t2.id = t3.ADD_ID WHERE (t0.creditRating = (SELECT  COALESCE(t1.creditRating,0) FROM CR_CUST t1 WHERE (t1.name = ?))) ORDER BY t0.name DESC";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)c.get(Customer_.name))});
        Subquery sq = q.subquery(Customer.CreditRating.class);
        Root c1 = sq.from(Customer.class);
        sq.where((Expression)this.cb.equal((Expression)c1.get(Customer_.name), (Object)"Famzy"));
        Expression coalesce = this.cb.coalesce((Expression)c1.get(Customer_.creditRating), (Object)Customer.CreditRating.POOR);
        sq.select(coalesce);
        q.where((Expression)this.cb.equal((Expression)c.get(Customer_.creditRating), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery23() {
        String jpql = "select c from Customer c where c.creditRating = (select NULLIF (c1.creditRating, org.apache.openjpa.persistence.criteria.Customer$CreditRating.POOR) from Customer c1 where c1.name = 'Famzy') order by c.name DESC";
        String expectedSQL = "SELECT t0.id, t0.accountNum, t2.id, t2.city, t2.country, t2.county, t2.state, t2.street, t3.userid, t3.DTYPE, t3.age, t3.compName, t3.creditRating, t3.name, t2.zipCode, t0.balanceOwed, t0.creditRating, t0.filledOrderCount, t0.firstName, t0.lastName, t0.name, t0.status FROM CR_CUST t0 LEFT OUTER JOIN CR_ADDR t2 ON t0.ADDRESS_ID = t2.id LEFT OUTER JOIN CompUser t3 ON t2.id = t3.ADD_ID WHERE (t0.creditRating = (SELECT  NULLIF(t1.creditRating,0) FROM CR_CUST t1 WHERE (t1.name = ?))) ORDER BY t0.name DESC";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)c.get(Customer_.name))});
        Subquery sq = q.subquery(Customer.CreditRating.class);
        Root c1 = sq.from(Customer.class);
        sq.where((Expression)this.cb.equal((Expression)c1.get(Customer_.name), (Object)"Famzy"));
        q.where((Expression)this.cb.equal((Expression)c.get(Customer_.creditRating), (Expression)sq.select(this.cb.nullif((Expression)c1.get(Customer_.creditRating), (Object)Customer.CreditRating.POOR))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery24() {
        String jpql = "select o from Order o where o.count > (select count(o) from Order o)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t2.id, t2.accountNum, t3.id, t3.city, t3.country, t3.county, t3.state, t3.street, t4.userid, t4.DTYPE, t4.age, t4.compName, t4.creditRating, t4.name, t3.zipCode, t2.balanceOwed, t2.creditRating, t2.filledOrderCount, t2.firstName, t2.lastName, t2.name, t2.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 LEFT OUTER JOIN CR_CUST t2 ON t0.CUSTOMER_ID = t2.id LEFT OUTER JOIN CR_ADDR t3 ON t2.ADDRESS_ID = t3.id LEFT OUTER JOIN CompUser t4 ON t3.id = t4.ADD_ID WHERE (t0.cnt > (SELECT COUNT(t1.id) FROM CR_ODR t1))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(Long.class);
        Root o2 = sq.from(Order.class);
        sq.select(this.cb.count((Expression)o2));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.count), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery25() {
        String jpql = "select o from Order o where o.count > (select count(o2) from Order o2)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t2.id, t2.accountNum, t3.id, t3.city, t3.country, t3.county, t3.state, t3.street, t4.userid, t4.DTYPE, t4.age, t4.compName, t4.creditRating, t4.name, t3.zipCode, t2.balanceOwed, t2.creditRating, t2.filledOrderCount, t2.firstName, t2.lastName, t2.name, t2.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 LEFT OUTER JOIN CR_CUST t2 ON t0.CUSTOMER_ID = t2.id LEFT OUTER JOIN CR_ADDR t3 ON t2.ADDRESS_ID = t3.id LEFT OUTER JOIN CompUser t4 ON t3.id = t4.ADD_ID WHERE (t0.cnt > (SELECT COUNT(t1.id) FROM CR_ODR t1))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(Long.class);
        Root o2 = sq.from(Order.class);
        sq.select(this.cb.count((Expression)o2));
        q.where((Expression)this.cb.gt((Expression)o.get(Order_.count), (Expression)sq));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubSelectMaxDateRange() {
        String jpql = "SELECT e,d from Employee e, Dependent d WHERE e.empId = :empid AND d.id.empid = (SELECT MAX (e2.empId) FROM Employee e2) AND d.id.effDate > :minDate AND d.id.effDate < :maxDate ";
        Query jQ = this.em.createQuery(jpql);
        jQ.setParameter("empid", (Object)101L);
        jQ.setParameter("minDate", (Object)new Date(100L));
        jQ.setParameter("maxDate", (Object)new Date(100000L));
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(Employee.class);
        Root d = q.from(Dependent.class);
        q.multiselect(new Selection[]{e, d});
        ParameterExpression empid = this.cb.parameter(Integer.class, "empid");
        ParameterExpression minDate = this.cb.parameter(Date.class, "minDate");
        ParameterExpression maxDate = this.cb.parameter(Date.class, "maxDate");
        Subquery sq = q.subquery(Integer.class);
        Root e2 = sq.from(Employee.class);
        sq.select(this.cb.max((Expression)e2.get(Employee_.empId)));
        Predicate p1 = this.cb.equal((Expression)e.get(Employee_.empId), (Expression)empid);
        Predicate p2 = this.cb.equal((Expression)d.get(Dependent_.id).get(DependentId_.empid), (Expression)sq);
        Predicate p3 = this.cb.greaterThan((Expression)d.get(Dependent_.id).get(DependentId_.effDate), (Expression)minDate);
        Predicate p4 = this.cb.lessThan((Expression)d.get(Dependent_.id).get(DependentId_.effDate), (Expression)maxDate);
        q.where((Expression)this.cb.and((Expression)this.cb.and((Expression)this.cb.and((Expression)p1, (Expression)p2), (Expression)p3), (Expression)p4));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("empid", (Object)101L);
                q.setParameter("minDate", (Object)new Date(100L));
                q.setParameter("maxDate", (Object)new Date(100000L));
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testCorrelatedNestedSubquery1() {
        String jpql = "Select Object (c) From Customer c Where Not Exists (   Select a.id From Account As a Where         a.customer = c  And         exists (select o.id from Order o where o.customer = c and o.count = 1))";
        String expectedSQL = "SELECT t1.id, t1.accountNum, t3.id, t3.city, t3.country, t3.county, t3.state, t3.street, t4.userid, t4.DTYPE, t4.age, t4.compName, t4.creditRating, t4.name, t3.zipCode, t1.balanceOwed, t1.creditRating, t1.filledOrderCount, t1.firstName, t1.lastName, t1.name, t1.status FROM CR_CUST t1 LEFT OUTER JOIN CR_ADDR t3 ON t1.ADDRESS_ID = t3.id LEFT OUTER JOIN CompUser t4 ON t3.id = t4.ADD_ID WHERE (NOT (EXISTS (SELECT t0.id FROM CR_ACCT t0 WHERE (t0.CUSTOMER_ID = t1.id AND EXISTS (SELECT t2.id FROM CR_ODR t2 WHERE (t2.CUSTOMER_ID = t1.id AND t2.cnt = ?))))))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        q.select((Selection)c);
        Subquery sq = q.subquery(Long.class);
        Root a = sq.from(Account.class);
        sq.select((Expression)a.get(Account_.id));
        Subquery sq1 = sq.subquery(Integer.class);
        Root o = sq1.from(Order.class);
        sq1.select((Expression)o.get(Order_.id));
        sq1.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)o.get(Order_.customer), (Expression)c), (Expression)this.cb.equal((Expression)o.get(Order_.count), (Object)1)));
        sq.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)a.get(Account_.customer), (Expression)c), (Expression)this.cb.exists(sq1)));
        q.where((Expression)this.cb.exists(sq).not());
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testCorrelatedNestedSubquery1a() {
        String jpql = "Select Object (o) From Product o Where Not Exists (   Select a.id From Account As a Where         a.product = o  And         exists (select r.id from Request r where r.account = a and r.status = 1))";
        String expectedSQL = "SELECT t1.pid, t1.version, t1.productType FROM CR_PRD t1 WHERE (NOT (EXISTS (SELECT t0.id FROM CR_ACCT t0 WHERE (t0.PRODUCT_PID = t1.pid AND EXISTS (SELECT t2.id FROM Request t2 WHERE (t2.ACCOUNT_ID = t0.id AND t2.status = ?))))))";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Product.class);
        Root o = q.from(Product.class);
        q.select((Selection)o);
        Subquery sq = q.subquery(Long.class);
        Root a = sq.from(Account.class);
        sq.select((Expression)a.get(Account_.id));
        Subquery sq1 = sq.subquery(Integer.class);
        Root r = sq1.from(Request.class);
        sq1.select((Expression)r.get(Request_.id));
        sq1.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)r.get(Request_.account), (Expression)a), (Expression)this.cb.equal((Expression)r.get(Request_.status), (Object)1)));
        sq.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)a.get(Account_.product), (Expression)o), (Expression)this.cb.exists(sq1)));
        q.where((Expression)this.cb.exists(sq).not());
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testPluralCorrelatedJoin1() {
        String jpql = "SELECT o.quantity, o.totalCost*1.08, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = (SELECT o.name from Customer c1 JOIN c1.orders o1 where o.quantity = o1.quantity)";
        String expectedSQL = "SELECT t2.quantity, (t2.totalCost * ?), t1.zipCode FROM CR_CUST t0 INNER JOIN CR_ODR t2 ON t0.id = t2.CUSTOMER_ID INNER JOIN CR_ADDR t1 ON t0.ADDRESS_ID = t1.id WHERE (t1.state = (SELECT t2.name FROM CR_CUST t3 INNER JOIN CR_ODR t4 ON t3.id = t4.CUSTOMER_ID WHERE (t2.quantity = t4.quantity)) AND 1 = 1)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root cust = q.from(Customer.class);
        SetJoin order = cust.joinSet("orders");
        Join address = cust.join("address");
        Subquery sq = q.subquery(String.class);
        Root cust1 = sq.from(Customer.class);
        SetJoin order1 = cust1.joinSet("orders");
        SetJoin corrJoin = sq.correlate(order);
        sq.where((Expression)this.cb.equal((Expression)corrJoin.get(Order_.quantity), (Expression)order1.get(Order_.quantity)));
        q.where((Expression)this.cb.equal((Expression)address.get("state"), (Expression)sq.select((Expression)corrJoin.get(Order_.name))));
        Expression taxedCost = this.cb.prod((Expression)order.get(Order_.totalCost), (Number)1.08);
        q.multiselect(new Selection[]{order.get("quantity"), taxedCost, address.get("zipCode")});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testPluralCorrelatedJoin2() {
        String jpql = "SELECT d.name FROM Department d JOIN d.employees e JOIN e.manager m WHERE m.salary = (SELECT e1.salary from Employee e1 JOIN e1.manager m1 where m.name = m1.name)";
        String expectedSQL = "SELECT t0.name FROM CR_DEPT t0 INNER JOIN CR_DEPT_CR_EMP t1 ON t0.deptNo = t1.DEPARTMENT_DEPTNO INNER JOIN CR_EMP t2 ON t1.EMPLOYEES_EMPID = t2.empId INNER JOIN CR_EMP t6 ON t1.EMPLOYEES_EMPID = t6.empId INNER JOIN CR_MGR t3 ON t2.MANAGER_ID = t3.id INNER JOIN CR_MGR t7 ON t6.MANAGER_ID = t7.id WHERE (t3.salary = (SELECT t4.salary FROM CR_EMP t4 INNER JOIN CR_MGR t5 ON t4.MANAGER_ID = t5.id WHERE (t7.name = t5.name)) AND 1 = 1)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root d = q.from(Department.class);
        SetJoin e = d.joinSet("employees");
        Join m = e.join("manager");
        Subquery sq = q.subquery(Long.class);
        Root e1 = sq.from(Employee.class);
        Join m1 = e1.join("manager");
        Join corrJoin = sq.correlate(m);
        sq.where((Expression)this.cb.equal((Expression)corrJoin.get(Manager_.name), (Expression)m1.get(Manager_.name)));
        q.where((Expression)this.cb.equal((Expression)m.get(Manager_.salary), (Expression)sq.select((Expression)e1.get(Employee_.salary))));
        q.select((Selection)d.get(Department_.name));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testPluralCorrelatedJoin3() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c JOIN c.accounts a WHERE 10000 < ANY (SELECT a1.balance FROM Account a1 WHERE a.owner = a1.owner)";
        String expectedSQL = "SELECT t0.id, t0.cnt, t6.id, t6.accountNum, t7.id, t7.city, t7.country, t7.county, t7.state, t7.street, t8.userid, t8.DTYPE, t8.age, t8.compName, t8.creditRating, t8.name, t7.zipCode, t6.balanceOwed, t6.creditRating, t6.filledOrderCount, t6.firstName, t6.lastName, t6.name, t6.status, t0.delivered, t0.name, t0.orderTs, t0.quantity, t0.totalCost FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id LEFT OUTER JOIN CR_CUST t6 ON t0.CUSTOMER_ID = t6.id INNER JOIN CR_CUST_CR_ACCT t2 ON t1.id = t2.CUSTOMER_ID LEFT OUTER JOIN CR_ADDR t7 ON t6.ADDRESS_ID = t7.id INNER JOIN CR_ACCT t3 ON t2.ACCOUNTS_ID = t3.id INNER JOIN CR_ACCT t4 ON t2.ACCOUNTS_ID = t4.id LEFT OUTER JOIN CompUser t8 ON t7.id = t8.ADD_ID WHERE (? < ANY (SELECT t5.balance FROM CR_ACCT t5 WHERE (t4.OWNER_ID = t5.OWNER_ID)) AND 1 = 1)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        ListJoin a = c.joinList("accounts");
        q.select((Selection)o);
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(Account.class);
        ListJoin corrJoin = sq.correlate(a);
        sq.select((Expression)a1.get(Account_.balance));
        sq.where((Expression)this.cb.equal((Expression)corrJoin.get(Account_.owner), (Expression)a1.get(Account_.owner)));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.any(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testPluralCorrelatedJoin4() {
        String jpql = "SELECT o.quantity FROM Order o JOIN o.customer c JOIN c.accounts a JOIN a.owner owner WHERE 10000 < ANY (SELECT a1.balance FROM Account a1 JOIN a1.owner owner1 WHERE owner.name = owner1.name)";
        String expectedSQL = "SELECT t0.quantity FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id INNER JOIN CR_CUST_CR_ACCT t2 ON t1.id = t2.CUSTOMER_ID INNER JOIN CR_ACCT t3 ON t2.ACCOUNTS_ID = t3.id INNER JOIN CR_ACCT t7 ON t2.ACCOUNTS_ID = t7.id INNER JOIN CR_PSN t4 ON t3.OWNER_ID = t4.id INNER JOIN CR_PSN t8 ON t7.OWNER_ID = t8.id WHERE (? < ANY (SELECT t5.balance FROM CR_ACCT t5 INNER JOIN CR_PSN t6 ON t5.OWNER_ID = t6.id WHERE (t8.name = t6.name)) AND 1 = 1)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        ListJoin a = c.joinList("accounts");
        Join owner = a.join(Account_.owner);
        Subquery sq = q.subquery(Integer.class);
        Root a1 = sq.from(Account.class);
        Join owner1 = a1.join(Account_.owner);
        Join corrJoin = sq.correlate(owner);
        sq.where((Expression)this.cb.equal((Expression)corrJoin.get(Person_.name), (Expression)owner1.get(Person_.name)));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.any(sq.select((Expression)a1.get(Account_.balance)))));
        q.select((Selection)o.get(Order_.quantity));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testPluralCorrelatedJoin5() {
        String jpql = "SELECT o.quantity FROM Order o JOIN o.customer c JOIN c.accounts a WHERE c.name = ANY (SELECT owner.name FROM a.owner owner WHERE owner.id = 1)";
        String expectedSQL = "SELECT t0.quantity FROM CR_ODR t0 INNER JOIN CR_CUST t1 ON t0.CUSTOMER_ID = t1.id INNER JOIN CR_CUST_CR_ACCT t2 ON t1.id = t2.CUSTOMER_ID INNER JOIN CR_ACCT t3 ON t2.ACCOUNTS_ID = t3.id INNER JOIN CR_ACCT t4 ON t2.ACCOUNTS_ID = t4.id WHERE (t1.name = ANY (SELECT t5.name FROM CR_PSN t5 WHERE (t5.id = ? AND t4.OWNER_ID = t5.id)) AND 1 = 1)";
        this.executeAndCompareSQL(jpql, expectedSQL);
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        ListJoin a = c.joinList("accounts");
        Subquery sq = q.subquery(String.class);
        ListJoin a1 = sq.correlate(a);
        Join owner = a1.join(Account_.owner);
        sq.where((Expression)this.cb.equal((Expression)owner.get(Person_.id), (Object)1));
        q.where((Expression)this.cb.equal((Expression)c.get(Customer_.name), this.cb.any(sq.select((Expression)owner.get(Person_.name)))));
        q.select((Selection)o.get(Order_.quantity));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }
}

