/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.Type;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.Account;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.Contact;
import org.apache.openjpa.persistence.criteria.Course;
import org.apache.openjpa.persistence.criteria.CreditCard;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Customer;
import org.apache.openjpa.persistence.criteria.CustomerDetails;
import org.apache.openjpa.persistence.criteria.Customer_;
import org.apache.openjpa.persistence.criteria.Department;
import org.apache.openjpa.persistence.criteria.Employee;
import org.apache.openjpa.persistence.criteria.Exempt;
import org.apache.openjpa.persistence.criteria.Item;
import org.apache.openjpa.persistence.criteria.LineItem;
import org.apache.openjpa.persistence.criteria.Manager;
import org.apache.openjpa.persistence.criteria.Movie;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Order;
import org.apache.openjpa.persistence.criteria.Order_;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.Phone;
import org.apache.openjpa.persistence.criteria.Photo;
import org.apache.openjpa.persistence.criteria.Product;
import org.apache.openjpa.persistence.criteria.Semester;
import org.apache.openjpa.persistence.criteria.Student;
import org.apache.openjpa.persistence.criteria.TransactionHistory;
import org.apache.openjpa.persistence.criteria.VideoStore;
import org.apache.openjpa.persistence.test.AllowFailure;

public class TestMetaModelTypesafeCriteria
extends CriteriaTest {
    protected EntityType<Account> account_ = null;
    protected EmbeddableType<Address> address_ = null;
    protected EmbeddableType<Contact> contact_ = null;
    protected EntityType<Course> course_ = null;
    protected EntityType<CreditCard> creditCard_ = null;
    protected EntityType<Customer> customer_ = null;
    protected EntityType<Department> department_ = null;
    protected EntityType<Employee> employee_ = null;
    protected EntityType<Exempt> exempt_ = null;
    protected EntityType<Item> item_ = null;
    protected EntityType<LineItem> lineItem_ = null;
    protected EntityType<Manager> manager_ = null;
    protected EntityType<Movie> movie_ = null;
    protected EntityType<Order> order_ = null;
    protected EntityType<Person> person_ = null;
    protected EntityType<Phone> phone_ = null;
    protected EntityType<Photo> photo_ = null;
    protected EntityType<Product> product_ = null;
    protected EntityType<Semester> semester_ = null;
    protected EntityType<Student> student_ = null;
    protected EntityType<TransactionHistory> transactionHistory_ = null;
    protected EntityType<VideoStore> videoStore_ = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Metamodel mm = this.em.getMetamodel();
        this.account_ = mm.entity(Account.class);
        this.address_ = mm.embeddable(Address.class);
        TestMetaModelTypesafeCriteria.assertNotNull(this.address_);
        this.contact_ = mm.embeddable(Contact.class);
        this.course_ = mm.entity(Course.class);
        this.creditCard_ = mm.entity(CreditCard.class);
        this.customer_ = mm.entity(Customer.class);
        this.department_ = mm.entity(Department.class);
        this.employee_ = mm.entity(Employee.class);
        this.exempt_ = mm.entity(Exempt.class);
        this.item_ = mm.entity(Item.class);
        this.lineItem_ = mm.entity(LineItem.class);
        this.manager_ = mm.entity(Manager.class);
        this.movie_ = mm.entity(Movie.class);
        this.order_ = mm.entity(Order.class);
        this.person_ = mm.entity(Person.class);
        this.phone_ = mm.entity(Phone.class);
        this.photo_ = mm.entity(Photo.class);
        this.product_ = mm.entity(Product.class);
        this.semester_ = mm.entity(Semester.class);
        this.student_ = mm.entity(Student.class);
        this.transactionHistory_ = mm.entity(TransactionHistory.class);
        this.videoStore_ = mm.entity(VideoStore.class);
    }

    public void testEntityEmbeddableTest() {
        Metamodel mm = this.em.getMetamodel();
        TestMetaModelTypesafeCriteria.assertEquals((Object)mm.managedType(Account.class).getPersistenceType(), (Object)Type.PersistenceType.ENTITY);
        TestMetaModelTypesafeCriteria.assertEquals((Object)mm.managedType(Address.class).getPersistenceType(), (Object)Type.PersistenceType.EMBEDDABLE);
        TestMetaModelTypesafeCriteria.assertNotNull((Object)mm.entity(Account.class));
        TestMetaModelTypesafeCriteria.assertNotNull((Object)mm.embeddable(Address.class));
        try {
            mm.entity(Address.class);
            TestMetaModelTypesafeCriteria.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException iaex) {
            // empty catch block
        }
        try {
            mm.embeddable(Account.class);
            TestMetaModelTypesafeCriteria.fail((String)"Expecting IllegalArgumentException");
        }
        catch (IllegalArgumentException iaex) {
            // empty catch block
        }
        int numEntity = 0;
        int numEmbeddables = 0;
        for (Class<?> clz : this.getDomainClasses()) {
            if (clz.getAnnotation(Embeddable.class) != null) {
                ++numEmbeddables;
                continue;
            }
            if (clz.getAnnotation(Entity.class) == null) continue;
            ++numEntity;
        }
        Set embs = mm.getEmbeddables();
        TestMetaModelTypesafeCriteria.assertEquals((int)embs.size(), (int)numEmbeddables);
        Set ents = mm.getEntities();
        TestMetaModelTypesafeCriteria.assertEquals((int)ents.size(), (int)numEntity);
        Set metaTypes = mm.getManagedTypes();
        TestMetaModelTypesafeCriteria.assertEquals((int)metaTypes.size(), (int)(numEntity + numEmbeddables));
    }

    public void testStringEqualExpression() {
        String jpql = "select c from Customer c where c.name='Autowest Toyota'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root customer = q.from(Customer.class);
        q.select((Selection)customer).where((Expression)this.cb.equal((Expression)customer.get(this.customer_.getSingularAttribute("name", String.class)), (Object)"Autowest Toyota"));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSetAndListJoins() {
        String jpql = "SELECT c.name FROM Customer c JOIN c.orders o JOIN o.lineItems i WHERE i.product.productType = 'printer'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.join(this.customer_.getSet("orders", Order.class));
        ListJoin i = o.join(this.order_.getList("lineItems", LineItem.class));
        q.select((Selection)c.get(Customer_.name)).where((Expression)this.cb.equal((Expression)i.get(this.lineItem_.getSingularAttribute("product", Product.class)).get(this.product_.getSingularAttribute("productType", String.class)), (Object)"printer"));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testLeftSetJoin() {
        String jpql = "SELECT c FROM Customer c LEFT JOIN c.orders o WHERE c.status = 1";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(this.customer_.getSet("orders", Order.class), JoinType.LEFT);
        q.where((Expression)this.cb.equal((Expression)c.get(this.customer_.getSingularAttribute("status", Integer.class)), (Object)1));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testFetchJoins() {
        String jpql = "SELECT d FROM Department d LEFT JOIN FETCH d.employees WHERE d.deptNo = 1";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root d = q.from(Department.class);
        d.fetch((PluralAttribute)this.department_.getSet("employees", Employee.class), JoinType.LEFT);
        q.where((Expression)this.cb.equal((Expression)d.get(this.department_.getSingularAttribute("deptNo", Integer.class)), (Object)1)).select((Selection)d);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    @AllowFailure(message="This is regression.")
    public void testPathNavigation() {
        String jpql = "SELECT p.vendor FROM Employee e JOIN e.contactInfo.phones p  WHERE e.contactInfo.address.zipCode = '95054'";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root e = q.from(Employee.class);
        ListJoin p = e.join(this.employee_.getSingularAttribute("contactInfo", Contact.class)).join(this.contact_.getList("phones", Phone.class));
        q.where((Expression)this.cb.equal((Expression)e.get(this.employee_.getSingularAttribute("contactInfo", Contact.class)).get(this.contact_.getSingularAttribute("address", Address.class)).get(this.address_.getSingularAttribute("zipCode", String.class)), (Object)"95054"));
        q.select((Selection)p.get(this.phone_.getSingularAttribute("vendor", String.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testKeyPathNavigation() {
        String jpql = "SELECT i.name, p FROM Item i JOIN i.photos p WHERE KEY(p) LIKE '%egret%'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root i = q.from(Item.class);
        MapJoin p = i.join(this.item_.getMap("photos", String.class, Photo.class));
        q.multiselect(new Selection[]{i.get(this.item_.getSingularAttribute("name", String.class)), p}).where((Expression)this.cb.like((Expression)p.key(), "%egret%"));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testIndexExpression() {
        String jpql = "SELECT t FROM CreditCard c JOIN c.transactionHistory t WHERE c.customer.accountNum = 321987 AND INDEX(t) BETWEEN 0 AND 9";
        OpenJPACriteriaQuery cq = this.cb.createQuery(TransactionHistory.class);
        Root c = cq.from(CreditCard.class);
        ListJoin t = c.join(this.creditCard_.getList("transactionHistory", TransactionHistory.class));
        Predicate p1 = this.cb.equal((Expression)c.get(this.creditCard_.getSingularAttribute("customer", Customer.class)).get(this.customer_.getSingularAttribute("accountNum", Long.TYPE)), (Object)321987);
        Predicate p2 = this.cb.between(t.index(), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9));
        cq.select((Selection)t).where(new Predicate[]{p1, p2});
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testIsEmptyExpressionOnJoin() {
        String jpql = "SELECT o FROM Order o WHERE o.lineItems IS EMPTY";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Expression lineItems = o.get("lineItems").as(LineItem.class);
        q.where((Expression)this.cb.isEmpty(lineItems.as(List.class)));
        q.select((Selection)o);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testFunctionalExpressionInProjection() {
        String jpql = "SELECT o.quantity, o.totalCost*1.08 AS taxedCost, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.join(this.customer_.getSet("orders", Order.class));
        Join a = c.join(this.customer_.getSingularAttribute("address", Address.class));
        Expression taxedCost = (Expression)this.cb.prod((Expression)o.get(this.order_.getSingularAttribute("totalCost", Double.class)), (Number)1.08).alias("taxedCost");
        q.where(new Predicate[]{this.cb.equal((Expression)a.get(this.address_.getSingularAttribute("state", String.class)), (Object)"CA"), this.cb.equal((Expression)a.get(this.address_.getSingularAttribute("county", String.class)), (Object)"Santa Clara")});
        q.multiselect(new Selection[]{o.get(this.order_.getSingularAttribute("quantity", Integer.class)), taxedCost, a.get(this.address_.getSingularAttribute("zipCode", String.class))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testTypeExpression() {
        String jpql = "SELECT TYPE(e) FROM Employee e WHERE TYPE(e) <> Exempt";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root emp = q.from(Employee.class);
        q.select((Selection)emp.type()).where((Expression)this.cb.notEqual(emp.type(), Exempt.class));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testJoinAndIndexExpression() {
        String jpql = "SELECT w.name FROM Course c JOIN c.studentWaitList w WHERE c.name = 'Calculus' AND INDEX(w) = 0";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root course = q.from(Course.class);
        ListJoin w = course.join(this.course_.getList("studentWaitList", Student.class));
        q.where(new Predicate[]{this.cb.equal((Expression)course.get(this.course_.getSingularAttribute("name", String.class)), (Object)"Calculus"), this.cb.equal(w.index(), (Object)0)}).select((Selection)w.get(this.student_.getSingularAttribute("name", String.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testAggregateExpressionInProjection() {
        String jpql = "SELECT SUM(i.price) FROM Order o JOIN o.lineItems i JOIN o.customer c WHERE c.lastName = 'Smith' AND c.firstName = 'John'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root o = q.from(Order.class);
        ListJoin i = o.join(this.order_.getList("lineItems", LineItem.class));
        Join c = o.join(this.order_.getSingularAttribute("customer", Customer.class));
        q.where(new Predicate[]{this.cb.equal((Expression)c.get(this.customer_.getSingularAttribute("lastName", String.class)), (Object)"Smith"), this.cb.equal((Expression)c.get(this.customer_.getSingularAttribute("firstName", String.class)), (Object)"John")});
        q.select((Selection)this.cb.sum((Expression)i.get(this.lineItem_.getSingularAttribute("price", Double.class))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSizeExpressionInProjection() {
        String jpql = "SELECT SIZE(d.employees) FROM Department d WHERE d.name = 'Sales'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root d = q.from(Department.class);
        q.where((Expression)this.cb.equal((Expression)d.get(this.department_.getSingularAttribute("name", String.class)), (Object)"Sales"));
        SetAttribute employees = this.department_.getDeclaredSet("employees", Employee.class);
        q.select((Selection)this.cb.size(d.get((PluralAttribute)employees)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testCaseExpression() {
        String jpql = "SELECT e.name, CASE WHEN e.rating = 1 THEN e.salary * 1.1 WHEN e.rating = 2 THEN e.salary * 1.2 ELSE e.salary * 1.01 END FROM Employee e WHERE e.department.name = 'Engineering'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(Employee.class);
        q.where((Expression)this.cb.equal((Expression)e.get(this.employee_.getSingularAttribute("department", Department.class)).get(this.department_.getSingularAttribute("name", String.class)), (Object)"Engineering"));
        q.multiselect(new Selection[]{e.get(this.employee_.getSingularAttribute("name", String.class)), this.cb.selectCase().when((Expression)this.cb.equal((Expression)e.get(this.employee_.getSingularAttribute("rating", Integer.class)), (Object)1), this.cb.prod((Expression)e.get(this.employee_.getSingularAttribute("salary", Long.class)), (Number)1.1)).when((Expression)this.cb.equal((Expression)e.get(this.employee_.getSingularAttribute("rating", Integer.class)), (Object)2), this.cb.prod((Expression)e.get(this.employee_.getSingularAttribute("salary", Long.class)), (Number)1.2)).otherwise(this.cb.prod((Expression)e.get(this.employee_.getSingularAttribute("salary", Long.class)), (Number)1.01))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testMemberOfExpression() {
        String jpql = "SELECT p FROM Person p where 'Joe' MEMBER OF p.nickNames";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root p = q.from(Person.class);
        q.multiselect(new Selection[]{p}).where((Expression)this.cb.isMember(this.cb.literal((Object)"Joe"), p.get((PluralAttribute)this.person_.getDeclaredSet("nickNames", String.class))));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testParameters() {
        String jpql = "SELECT c FROM Customer c Where c.status = :stat";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root c = q.from(Customer.class);
        ParameterExpression param = this.cb.parameter(Integer.class, "stat");
        q.multiselect(new Selection[]{c}).where((Expression)this.cb.equal((Expression)c.get(this.customer_.getSingularAttribute("status", Integer.class)), (Object)param));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("stat", (Object)1);
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testKeyExpressionInSelectList() {
        String jpql = "SELECT v.location.street, KEY(i).title, VALUE(i) FROM VideoStore v JOIN v.videoInventory i WHERE v.location.zipCode = '94301' AND VALUE(i) > 0";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root v = q.from(VideoStore.class);
        MapJoin i = v.join(this.videoStore_.getMap("videoInventory", Movie.class, Integer.class));
        q.where(new Predicate[]{this.cb.equal((Expression)v.get(this.videoStore_.getSingularAttribute("location", Address.class)).get(this.address_.getSingularAttribute("zipCode", String.class)), (Object)"94301"), this.cb.gt((Expression)i.value(), (Number)0)});
        q.multiselect(new Selection[]{v.get(this.videoStore_.getSingularAttribute("location", Address.class)).get(this.address_.getSingularAttribute("street", String.class)), i.key().get(this.movie_.getSingularAttribute("title", String.class)), i.value()});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testConstructorInSelectList() {
        String jpql = "SELECT NEW CustomerDetails(c.id, c.status, o.quantity) FROM Customer c JOIN c.orders o WHERE o.quantity > 100";
        OpenJPACriteriaQuery q = this.cb.createQuery(CustomerDetails.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.join(this.customer_.getSet("orders", Order.class));
        q.where((Expression)this.cb.gt((Expression)o.get(this.order_.getSingularAttribute("quantity", Integer.class)), (Number)100));
        q.select((Selection)this.cb.construct(CustomerDetails.class, new Selection[]{c.get(this.customer_.getSingularAttribute("id", Long.class)), c.get(this.customer_.getSingularAttribute("status", Integer.class)), o.get(this.order_.getSingularAttribute("quantity", Integer.class))}));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testUncorrelatedSubqueryWithAggregateProjection() {
        String jpql = "SELECT goodCustomer FROM Customer goodCustomer WHERE goodCustomer.balanceOwed < (SELECT AVG(c.balanceOwed) FROM Customer c)";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root goodCustomer = q.from(Customer.class);
        Subquery sq = q.subquery(Double.class);
        Root c = sq.from(Customer.class);
        q.where((Expression)this.cb.lt((Expression)goodCustomer.get(this.customer_.getSingularAttribute("balanceOwed", Integer.class)), (Expression)sq.select(this.cb.avg((Expression)c.get(this.customer_.getSingularAttribute("balanceOwed", Integer.class))))));
        q.multiselect(new Selection[]{goodCustomer});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueryWithExistsClause() {
        String jpql = "SELECT DISTINCT emp FROM Employee emp WHERE EXISTS (SELECT spouseEmp FROM Employee spouseEmp WHERE spouseEmp = emp.spouse)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        Subquery sq = q.subquery(Employee.class);
        Root spouseEmp = sq.from(Employee.class);
        sq.select((Expression)spouseEmp);
        sq.where((Expression)this.cb.equal((Expression)spouseEmp, (Expression)emp.get(this.employee_.getSingularAttribute("spouse", Employee.class))));
        q.where((Expression)this.cb.exists(sq));
        q.distinct(true);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubqueryWithAllClause() {
        String jpql = "SELECT emp FROM Employee emp WHERE emp.salary > ALL (SELECT m.salary FROM Manager m WHERE m.department = emp.department)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        Subquery sq = q.subquery(BigDecimal.class);
        Root m = sq.from(Manager.class);
        sq.select((Expression)m.get(this.manager_.getSingularAttribute("salary", BigDecimal.class)));
        sq.where((Expression)this.cb.equal((Expression)m.get(this.manager_.getSingularAttribute("department", Department.class)), (Expression)emp.get(this.employee_.getSingularAttribute("department", Department.class))));
        q.where((Expression)this.cb.gt((Expression)emp.get(this.employee_.getSingularAttribute("salary", Long.class)), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testCorrelatedSubqueryWithCount() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM c.orders o) > 10";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c1 = q.from(Customer.class);
        Subquery sq3 = q.subquery(Long.class);
        Root c2 = sq3.correlate(c1);
        SetJoin o = c2.join(this.customer_.getSet("orders", Order.class));
        q.where((Expression)this.cb.gt((Expression)sq3.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testCorrelatedSubqueryWithJoin() {
        String jpql = "SELECT o FROM Order o WHERE 10000 < ALL (SELECT a.balance FROM o.customer c JOIN c.accounts a)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Subquery sq = q.subquery(Integer.class);
        Root o2 = sq.correlate(o);
        Join c = o2.join(this.order_.getSingularAttribute("customer", Customer.class));
        ListJoin a = c.join(this.customer_.getList("accounts", Account.class));
        sq.select((Expression)a.get(this.account_.getSingularAttribute("balance", Integer.class)));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testCorrelatedSubqueryWithAllClause() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE 10000 < ALL (SELECT a.balance FROM c.accounts a)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        Join c = o.join(Order_.customer);
        Subquery sq = q.subquery(Integer.class);
        Join csq = sq.correlate(c);
        ListJoin a = csq.join(this.customer_.getList("accounts", Account.class));
        sq.select((Expression)a.get(this.account_.getSingularAttribute("balance", Integer.class)));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testGroupByAndHaving() {
        String jpql = "SELECT c.status, AVG(c.filledOrderCount), COUNT(c) FROM Customer c GROUP BY c.status HAVING c.status IN (1, 2)";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root c = q.from(Customer.class);
        q.groupBy(new Expression[]{c.get(this.customer_.getSingularAttribute("status", Integer.class))});
        q.having((Expression)this.cb.in((Expression)c.get(this.customer_.getSingularAttribute("status", Integer.class))).value((Object)1).value((Object)2));
        q.multiselect(new Selection[]{c.get(this.customer_.getSingularAttribute("status", Integer.class)), this.cb.avg((Expression)c.get(this.customer_.getSingularAttribute("filledOrderCount", Integer.class))), this.cb.count((Expression)c)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrderingByExpressionNotIncludedInSelection() {
        String jpql = "SELECT o FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity DESC, o.totalCost";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.join(this.customer_.getSet("orders", Order.class));
        Join a = c.join(this.customer_.getSingularAttribute("address", Address.class));
        q.where((Expression)this.cb.equal((Expression)a.get(this.address_.getSingularAttribute("state", String.class)), (Object)"CA"));
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)o.get(this.order_.getSingularAttribute("quantity", Integer.class))), this.cb.asc((Expression)o.get(this.order_.getSingularAttribute("totalCost", Double.class)))});
        q.multiselect(new Selection[]{o});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrderingByExpressionIncludedInSelection() {
        String jpql = "SELECT o.quantity, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity, a.zipCode";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.join(this.customer_.getSet("orders", Order.class));
        Join a = c.join(this.customer_.getSingularAttribute("address", Address.class));
        q.where((Expression)this.cb.equal((Expression)a.get(this.address_.getSingularAttribute("state", String.class)), (Object)"CA"));
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc((Expression)o.get(this.order_.getSingularAttribute("quantity", Integer.class))), this.cb.asc((Expression)a.get(this.address_.getSingularAttribute("zipCode", String.class)))});
        q.multiselect(new Selection[]{o.get(this.order_.getSingularAttribute("quantity", Integer.class)), a.get(this.address_.getSingularAttribute("zipCode", String.class))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrderingWithNumericalExpressionInSelection() {
        String jpql = "SELECT o.quantity, o.totalCost * 1.08 AS taxedCost, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara' ORDER BY o.quantity, taxedCost, a.zipCode";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.join(this.customer_.getSet("orders", Order.class));
        Join a = c.join(this.customer_.getSingularAttribute("address", Address.class));
        Expression taxedCost = (Expression)this.cb.prod((Expression)o.get(this.order_.getSingularAttribute("totalCost", Double.class)), (Number)1.08).alias("taxedCost");
        q.where(new Predicate[]{this.cb.equal((Expression)a.get(this.address_.getSingularAttribute("state", String.class)), (Object)"CA"), this.cb.equal((Expression)a.get(this.address_.getSingularAttribute("county", String.class)), (Object)"Santa Clara")});
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc((Expression)o.get(this.order_.getSingularAttribute("quantity", Integer.class))), this.cb.asc(taxedCost), this.cb.asc((Expression)a.get(this.address_.getSingularAttribute("zipCode", String.class)))});
        q.multiselect(new Selection[]{o.get(this.order_.getSingularAttribute("quantity", Integer.class)), taxedCost, a.get(this.address_.getSingularAttribute("zipCode", String.class))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }
}

