/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.math.BigDecimal;
import java.util.Collection;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.Course;
import org.apache.openjpa.persistence.criteria.CreditCard;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.Customer;
import org.apache.openjpa.persistence.criteria.CustomerDetails;
import org.apache.openjpa.persistence.criteria.Customer_;
import org.apache.openjpa.persistence.criteria.Department;
import org.apache.openjpa.persistence.criteria.Employee;
import org.apache.openjpa.persistence.criteria.Item;
import org.apache.openjpa.persistence.criteria.Manager;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.Order;
import org.apache.openjpa.persistence.criteria.Order_;
import org.apache.openjpa.persistence.criteria.Person;
import org.apache.openjpa.persistence.criteria.TransactionHistory;
import org.apache.openjpa.persistence.criteria.VideoStore;
import org.apache.openjpa.persistence.test.AllowFailure;

public class TestStringCriteria
extends CriteriaTest {
    public void testCriteria() {
        String jpql = "select c from Customer c where c.name='Autowest Toyota'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root customer = q.from(Customer.class);
        Path path = customer.get("name");
        q.select((Selection)customer).where((Expression)this.cb.equal((Expression)customer.get("name"), (Object)"Autowest Toyota"));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testJoins1() {
        String jpql = "SELECT c.name FROM Customer c JOIN c.orders o JOIN o.lineItems i WHERE i.product.productType = 'printer'";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root cust = q.from(Customer.class);
        SetJoin order = cust.joinSet("orders");
        ListJoin item = order.joinList("lineItems");
        q.select((Selection)cust.get(Customer_.name)).where((Expression)this.cb.equal((Expression)item.get("product").get("productType"), (Object)"printer"));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testJoins2() {
        String jpql = "SELECT c FROM Customer c LEFT JOIN c.orders o WHERE c.status = 1";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.joinSet("orders", JoinType.LEFT);
        q.where((Expression)this.cb.equal((Expression)c.get("status"), (Object)1)).select((Selection)c);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testFetchJoins() {
        String jpql = "SELECT d FROM Department d LEFT JOIN FETCH d.employees WHERE d.deptNo = 1";
        OpenJPACriteriaQuery q = this.cb.createQuery(Department.class);
        Root d = q.from(Department.class);
        d.fetch("employees", JoinType.LEFT);
        q.where((Expression)this.cb.equal((Expression)d.get("deptNo"), (Object)1)).select((Selection)d);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    @AllowFailure(message="SQL mismatch. Not analyzed further. Is the CriteriaQuery corect for e.contactInfo.phones?")
    public void testPathNavigation() {
        String jpql = "SELECT p.vendor FROM Employee e JOIN e.contactInfo.phones p  WHERE e.contactInfo.address.zipCode = '95054'";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root e = q.from(Employee.class);
        ListJoin p = e.join("contactInfo").joinList("phones");
        q.where((Expression)this.cb.equal((Expression)e.get("contactInfo").get("address").get("zipCode"), (Object)"95054"));
        q.select((Selection)p.get("vendor").as(String.class));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testKey() {
        String jpql = "SELECT i.name, p FROM Item i JOIN i.photos p WHERE KEY(p) LIKE '%egret%'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root item = q.from(Item.class);
        MapJoin photo = item.joinMap("photos");
        q.multiselect(new Selection[]{item.get("name"), photo}).where((Expression)this.cb.like((Expression)photo.key(), "%egret%"));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testRestrictQueryResult() {
        String jpql = "SELECT t FROM CreditCard c JOIN c.transactionHistory t WHERE c.customer.accountNum = 321987 AND INDEX(t) BETWEEN 0 AND 9";
        OpenJPACriteriaQuery q = this.cb.createQuery(TransactionHistory.class);
        Root c = q.from(CreditCard.class);
        ListJoin t = c.joinList("transactionHistory");
        q.select((Selection)t).where(new Predicate[]{this.cb.equal((Expression)c.get("customer").get("accountNum"), (Object)321987), this.cb.between(t.index(), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(9))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testIsEmpty() {
        String jpql = "SELECT o FROM Order o WHERE o.lineItems IS EMPTY";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.where((Expression)this.cb.isEmpty(o.get("lineItems").as(Collection.class)));
        q.select((Selection)o);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testExpressions() {
        String jpql = "SELECT o.quantity, o.totalCost*1.08 AS taxedCost, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara'";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.joinSet("orders");
        Join a = c.join("address");
        q.where(new Predicate[]{this.cb.equal((Expression)a.get("state"), (Object)"CA"), this.cb.equal((Expression)a.get("county"), (Object)"Santa Clara")});
        Expression productTerm = (Expression)this.cb.toFloat(this.cb.prod(o.get("totalCost").as(Float.class), (Number)1.08)).alias("taxedCost");
        q.multiselect(new Selection[]{o.get("quantity"), productTerm, a.get("zipCode")});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testIndex() {
        String jpql = "SELECT w.name FROM Course c JOIN c.studentWaitList w WHERE c.name = 'Calculus' AND INDEX(w) = 0";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root course = q.from(Course.class);
        ListJoin w = course.joinList("studentWaitList");
        q.where(new Predicate[]{this.cb.equal((Expression)course.get("name"), (Object)"Calculus"), this.cb.equal(w.index(), (Object)0)}).select((Selection)w.get("name").as(String.class));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSum() {
        String jpql = "SELECT SUM(i.price) FROM Order o JOIN o.lineItems i JOIN o.customer c WHERE c.lastName = 'Smith' AND c.firstName = 'John'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Double.class);
        Root o = q.from(Order.class);
        ListJoin i = o.joinList("lineItems");
        Join c = o.join("customer");
        q.where(new Predicate[]{this.cb.equal((Expression)c.get("lastName"), (Object)"Smith"), this.cb.equal((Expression)c.get("firstName"), (Object)"John")});
        q.select((Selection)this.cb.sum(i.get("price").as(Double.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSize() {
        String jpql = "SELECT SIZE(d.employees) FROM Department d WHERE d.name = 'Sales'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root d = q.from(Department.class);
        q.where((Expression)this.cb.equal((Expression)d.get("name"), (Object)"Sales"));
        q.select((Selection)this.cb.size(d.get("employees").as(Collection.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testCase() {
        String jpql = "SELECT e.name, CASE WHEN e.rating = 1 THEN e.salary * 1.1 WHEN e.rating = 2 THEN e.salary * 1.2 ELSE e.salary * 1.01 END FROM Employee e WHERE e.department.name = 'Engineering'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Object[].class);
        Root e = q.from(Employee.class);
        q.where((Expression)this.cb.equal((Expression)e.get("department").get("name"), (Object)"Engineering"));
        q.multiselect(new Selection[]{e.get("name"), this.cb.selectCase().when((Expression)this.cb.equal((Expression)e.get("rating"), (Object)1), this.cb.prod(e.get("salary").as(Float.class), (Number)1.1)).when((Expression)this.cb.equal((Expression)e.get("rating"), (Object)2), this.cb.prod(e.get("salary").as(Float.class), (Number)1.2)).otherwise(this.cb.prod(e.get("salary").as(Float.class), (Number)1.01))});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testLiterals() {
        String jpql = "SELECT p FROM Person p where 'Joe' MEMBER OF p.nickNames";
        OpenJPACriteriaQuery q = this.cb.createQuery(Person.class);
        Root p = q.from(Person.class);
        q.select((Selection)p).where((Expression)this.cb.isMember((Object)"Joe", p.get("nickNames").as(Collection.class)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testParameters() {
        String jpql = "SELECT c FROM Customer c Where c.status = :stat";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c = q.from(Customer.class);
        ParameterExpression param = this.cb.parameter(Integer.class, "stat");
        param.alias("stat");
        q.select((Selection)c).where((Expression)this.cb.equal((Expression)c.get("status"), (Expression)param));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("stat", (Object)1);
            }
        }, (CriteriaQuery<?>)q, jpql);
    }

    public void testSelectList() {
        String jpql = "SELECT v.location.street, KEY(i).title, VALUE(i) FROM VideoStore v JOIN v.videoInventory i WHERE v.location.zipCode = '94301' AND VALUE(i) > 0";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root v = q.from(VideoStore.class);
        MapJoin i = v.joinMap("videoInventory");
        q.where(new Predicate[]{this.cb.equal((Expression)v.get("location").get("zipCode"), (Object)"94301"), this.cb.gt((Expression)i.value(), (Number)0)});
        q.multiselect(new Selection[]{v.get("location").get("street"), i.key().get("title"), i.value()});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void TestContructor() {
        String jpql = "SELECT NEW CustomerDetails(c.id, c.status, o.quantity) FROM Customer c JOIN c.orders o WHERE o.quantity > 100";
        OpenJPACriteriaQuery q = this.cb.createQuery(CustomerDetails.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.joinSet("orders");
        q.where((Expression)this.cb.gt(o.get("quantity").as(Integer.class), (Number)100));
        q.select((Selection)this.cb.construct(CustomerDetails.class, new Selection[]{c.get("id"), c.get("status"), o.get("quantity")}));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery1() {
        String jpql = "SELECT goodCustomer FROM Customer goodCustomer WHERE goodCustomer.balanceOwed < (SELECT AVG(c.balanceOwed) FROM Customer c)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root goodCustomer = q.from(Customer.class);
        Subquery sq = q.subquery(Double.class);
        Root c = sq.from(Customer.class);
        q.where((Expression)this.cb.lt(goodCustomer.get("balanceOwed").as(Double.class), (Expression)sq.select(this.cb.avg(c.get("balanceOwed").as(Double.class)))));
        q.select((Selection)goodCustomer);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery2() {
        String jpql = "SELECT DISTINCT emp FROM Employee emp WHERE EXISTS (SELECT spouseEmp FROM Employee spouseEmp WHERE spouseEmp = emp.spouse)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        Subquery sq1 = q.subquery(Employee.class);
        Root spouseEmp = sq1.from(Employee.class);
        sq1.select((Expression)spouseEmp);
        sq1.where((Expression)this.cb.equal((Expression)spouseEmp, (Expression)emp.get("spouse")));
        q.where((Expression)this.cb.exists(sq1));
        q.select((Selection)emp).distinct(true);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery3() {
        String jpql = "SELECT emp FROM Employee emp WHERE emp.salary > ALL (SELECT m.salary FROM Manager m WHERE m.department = emp.department)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Employee.class);
        Root emp = q.from(Employee.class);
        q.select((Selection)emp);
        Subquery sq = q.subquery(BigDecimal.class);
        Root m = sq.from(Manager.class);
        sq.select(m.get("salary").as(BigDecimal.class));
        sq.where((Expression)this.cb.equal((Expression)m.get("department"), (Expression)emp.get("department")));
        q.where((Expression)this.cb.gt(emp.get("salary").as(BigDecimal.class), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery4() {
        String jpql = "SELECT c FROM Customer c WHERE (SELECT COUNT(o) FROM c.orders o) > 10";
        OpenJPACriteriaQuery q = this.cb.createQuery(Customer.class);
        Root c1 = q.from(Customer.class);
        q.select((Selection)c1);
        Subquery sq3 = q.subquery(Long.class);
        Root c2 = sq3.correlate(c1);
        SetJoin o = c2.joinSet("orders");
        q.where((Expression)this.cb.gt((Expression)sq3.select(this.cb.count((Expression)o)), (Number)10));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery5() {
        String jpql = "SELECT o FROM Order o WHERE 10000 < ALL (SELECT a.balance FROM o.customer c JOIN c.accounts a)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o1 = q.from(Order.class);
        q.select((Selection)o1);
        Subquery sq4 = q.subquery(Integer.class);
        Root o2 = sq4.correlate(o1);
        Join c3 = o2.join("customer");
        ListJoin a = c3.joinList("accounts");
        sq4.select(a.get("balance").as(Integer.class));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq4)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testSubquery6() {
        String jpql = "SELECT o FROM Order o JOIN o.customer c WHERE 10000 < ALL (SELECT a.balance FROM c.accounts a)";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root o = q.from(Order.class);
        q.select((Selection)o);
        Join c = o.join(Order_.customer);
        Subquery sq = q.subquery(Integer.class);
        Join c2 = sq.correlate(c);
        ListJoin a = c2.joinList("accounts");
        sq.select(a.get("balance").as(Integer.class));
        q.where((Expression)this.cb.lt(this.cb.literal((Object)10000), this.cb.all(sq)));
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testGroupByAndHaving() {
        String jpql = "SELECT c.status, AVG(c.filledOrderCount), COUNT(c) FROM Customer c GROUP BY c.status HAVING c.status IN (1, 2)";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        q.groupBy(new Expression[]{c.get("status")});
        q.having((Expression)this.cb.in((Expression)c.get("status")).value((Object)1).value((Object)2));
        q.multiselect(new Selection[]{c.get("status"), this.cb.avg(c.get("filledOrderCount").as(Integer.class)), this.cb.count((Expression)c)});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering1() {
        String jpql = "SELECT o FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity DESC, o.totalCost";
        OpenJPACriteriaQuery q = this.cb.createQuery(Order.class);
        Root c = q.from(Customer.class);
        SetJoin o = c.joinSet("orders");
        Join a = c.join("address");
        q.where((Expression)this.cb.equal((Expression)a.get("state"), (Object)"CA"));
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.desc((Expression)o.get("quantity")), this.cb.asc((Expression)o.get("totalCost"))});
        q.select((Selection)o);
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering2() {
        String jpql = "SELECT o.quantity, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' ORDER BY o.quantity, a.zipCode";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c1 = q.from(Customer.class);
        SetJoin o1 = c1.joinSet("orders");
        Join a1 = c1.join("address");
        q.where((Expression)this.cb.equal((Expression)a1.get("state"), (Object)"CA"));
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc((Expression)o1.get("quantity")), this.cb.asc((Expression)a1.get("zipCode"))});
        q.multiselect(new Selection[]{o1.get("quantity"), a1.get("zipCode")});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }

    public void testOrdering3() {
        String jpql = "SELECT o.quantity, o.totalCost * 1.08 AS taxedCost, a.zipCode FROM Customer c JOIN c.orders o JOIN c.address a WHERE a.state = 'CA' AND a.county = 'Santa Clara' ORDER BY o.quantity, taxedCost, a.zipCode";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root c = q.from(Customer.class);
        SetJoin o = c.joinSet("orders");
        Join a = c.join("address");
        q.where(new Predicate[]{this.cb.equal((Expression)a.get("state"), (Object)"CA"), this.cb.equal((Expression)a.get("county"), (Object)"Santa Clara")});
        Expression productTerm = (Expression)this.cb.toFloat(this.cb.prod(o.get("totalCost").as(Float.class), (Number)1.08)).alias("taxedCost");
        q.orderBy(new javax.persistence.criteria.Order[]{this.cb.asc((Expression)o.get("quantity")), this.cb.asc(productTerm), this.cb.asc((Expression)a.get("zipCode"))});
        q.multiselect(new Selection[]{o.get("quantity"), productTerm, a.get("zipCode")});
        this.assertEquivalence((CriteriaQuery<?>)q, jpql);
    }
}

