/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.openjpa.persistence.criteria.A;
import org.apache.openjpa.persistence.criteria.A_;
import org.apache.openjpa.persistence.criteria.AbstractCriteriaTestCase;
import org.apache.openjpa.persistence.criteria.Address;
import org.apache.openjpa.persistence.criteria.Address_;
import org.apache.openjpa.persistence.criteria.CompUser;
import org.apache.openjpa.persistence.criteria.CompUser_;
import org.apache.openjpa.persistence.criteria.CriteriaTest;
import org.apache.openjpa.persistence.criteria.FemaleUser;
import org.apache.openjpa.persistence.criteria.FemaleUser_;
import org.apache.openjpa.persistence.criteria.MaleUser;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;

public class TestTypeSafeCondExpression
extends CriteriaTest {
    public void testNothingUsingCriteria() {
        String query = "SELECT o FROM CompUser o";
        OpenJPACriteriaQuery cq = this.cb.createQuery(CompUser.class);
        cq.select((Selection)cq.from(CompUser.class));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testBetween() {
        String jpql = "SELECT o.name FROM CompUser o WHERE o.age BETWEEN 19 AND 40 AND o.computerName = 'PC'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.where((Expression)this.cb.and((Expression)this.cb.between((Expression)o.get(CompUser_.age), (Comparable)Integer.valueOf(19), (Comparable)Integer.valueOf(40)), (Expression)this.cb.equal((Expression)o.get(CompUser_.computerName), (Object)"PC")));
        cq.select((Selection)o.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testNotBetween() {
        String jpql = "SELECT o.name FROM CompUser o WHERE o.age NOT BETWEEN 19 AND 40 AND o.computerName= 'PC'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.where((Expression)this.cb.and((Expression)this.cb.between((Expression)o.get(CompUser_.age), (Comparable)Integer.valueOf(19), (Comparable)Integer.valueOf(40)).not(), (Expression)this.cb.equal((Expression)o.get(CompUser_.computerName), (Object)"PC")));
        cq.select((Selection)o.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testInExpr() {
        String jpql = "SELECT o.name FROM CompUser o WHERE o.age IN (29, 40, 10)";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.where((Expression)this.cb.in((Expression)o.get(CompUser_.age)).value((Object)29).value((Object)40).value((Object)10));
        cq.select((Selection)o.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testNotIn() {
        String jpql = "SELECT o.name FROM CompUser o WHERE o.age NOT IN (29, 40, 10)";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.where((Expression)this.cb.in((Expression)o.get(CompUser_.age)).value((Object)29).value((Object)40).value((Object)10).not());
        cq.select((Selection)o.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testLike1() {
        String jpql = "SELECT o.computerName FROM CompUser o WHERE o.name LIKE 'Sha%' AND o.computerName NOT IN ('PC','Laptop')";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.where((Expression)this.cb.and((Expression)this.cb.like((Expression)o.get(CompUser_.name), "Sha%"), (Expression)this.cb.in((Expression)o.get(CompUser_.computerName)).value((Object)"PC").value((Object)"Laptop").not()));
        cq.select((Selection)o.get(CompUser_.computerName));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testLike2() {
        String jpql = "SELECT o.computerName FROM CompUser o WHERE o.name LIKE 'Sha%o_' AND o.computerName NOT IN ('UNIX','DOS')";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.where((Expression)this.cb.and((Expression)this.cb.like((Expression)o.get(CompUser_.name), "Sha%o_"), (Expression)this.cb.in((Expression)o.get(CompUser_.computerName)).value((Object)"UNIX").value((Object)"DOS").not()));
        cq.select((Selection)o.get(CompUser_.computerName));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testLike3() {
        String jpql = "SELECT o.name FROM CompUser o WHERE o.name LIKE '_J%'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.where((Expression)this.cb.like((Expression)o.get(CompUser_.name), "_J%"));
        cq.select((Selection)o.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)cq, jpql);
    }

    public void testLikeWithEscapeCharacter() {
        String query = "SELECT o.name FROM CompUser o WHERE o.name LIKE :name ESCAPE '|'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root c = cq.from(CompUser.class);
        ParameterExpression param = this.cb.parameter(String.class, "name");
        cq.where((Expression)this.cb.like((Expression)c.get(CompUser_.name), (Expression)param, '|'));
        cq.select((Selection)c.get(CompUser_.name));
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("name", (Object)"%|_%");
            }
        }, (CriteriaQuery<?>)cq, query);
    }

    public void testNullExpression() {
        String query = "SELECT o.name FROM CompUser o WHERE o.age IS NOT NULL AND o.computerName = 'PC'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root c = cq.from(CompUser.class);
        cq.where((Expression)this.cb.and((Expression)this.cb.notEqual((Expression)c.get(CompUser_.age), null), (Expression)this.cb.equal((Expression)c.get(CompUser_.computerName), (Object)"PC")));
        cq.select((Selection)c.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testNullExpr2UsingCriteria() {
        String query = "SELECT o.name FROM CompUser o WHERE o.address.country IS NULL";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root c = cq.from(CompUser.class);
        cq.where((Expression)this.cb.equal((Expression)c.get(CompUser_.address).get(Address_.country), null));
        cq.select((Selection)c.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testIsEmptyExprUsingCriteria() {
        String query = "SELECT o.name FROM CompUser o WHERE o.nicknames IS NOT EMPTY";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root o = cq.from(CompUser.class);
        cq.select((Selection)o.get(CompUser_.name));
        cq.where((Expression)this.cb.isEmpty(o.get(CompUser_.nicknames)).not());
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testConstructorExprUsingCriteria() {
        String query = "SELECT NEW org.apache.openjpa.persistence.criteria.MaleUser(c.name, c.computerName, c.address, c.age, c.userid) FROM CompUser c WHERE c.name = 'Seetha'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(MaleUser.class);
        Root c = cq.from(CompUser.class);
        cq.where((Expression)this.cb.equal((Expression)c.get(CompUser_.name), (Object)"Seetha"));
        cq.select((Selection)this.cb.construct(MaleUser.class, new Selection[]{c.get(CompUser_.name), c.get(CompUser_.computerName), c.get(CompUser_.address), c.get(CompUser_.age), c.get(CompUser_.userid)}));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testConcatSubStringFunc1() {
        String query = "select CONCAT('Ablahum', SUBSTRING(e.name, LOCATE('e', e.name), 4)) From CompUser e WHERE e.name='Seetha'";
        OpenJPACriteriaQuery cq = this.cb.createQuery(String.class);
        Root e = cq.from(CompUser.class);
        cq.select((Selection)this.cb.concat("Ablahum", this.cb.substring((Expression)e.get(CompUser_.name), this.cb.locate((Expression)e.get(CompUser_.name), "e"), this.cb.literal((Object)4))));
        cq.where((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Seetha"));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testConcatSubStringFunc2() {
        String query = "select e.address From CompUser e where e.name = 'Seetha' AND e.computerName = CONCAT('Ablahum', SUBSTRING(e.name, LOCATE('e', e.name), 4)) ";
        OpenJPACriteriaQuery cq = this.cb.createQuery(Address.class);
        Root e = cq.from(CompUser.class);
        cq.select((Selection)e.get(CompUser_.address));
        cq.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Seetha"), (Expression)this.cb.equal((Expression)e.get(CompUser_.computerName), this.cb.concat("Ablahum", this.cb.substring((Expression)e.get(CompUser_.name), this.cb.locate((Expression)e.get(CompUser_.name), "e"), this.cb.literal((Object)4))))));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testConcatSubStringFunc3() {
        String query = "select CONCAT('XYZ', SUBSTRING(e.name, LOCATE('e', e.name))) From CompUser e WHERE e.name='Ablahumeeth'";
        OpenJPACriteriaQuery cq = this.cb.createQuery();
        Root e = cq.from(CompUser.class);
        cq.multiselect(new Selection[]{this.cb.concat("XYZ", this.cb.substring((Expression)e.get(CompUser_.name), this.cb.locate((Expression)e.get(CompUser_.name), "e")))});
        cq.where((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Ablahumeeth"));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testConcatSubStringFunc4() {
        String query = "select e.age from CompUser e where e.name = 'Seetha' AND e.computerName = CONCAT('XYZ', SUBSTRING(e.name, LOCATE('e', e.name))) ";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{e.get(CompUser_.age)});
        q.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Seetha"), (Expression)this.cb.equal((Expression)e.get(CompUser_.computerName), this.cb.concat("XYZ", this.cb.substring((Expression)e.get(CompUser_.name), this.cb.locate((Expression)e.get(CompUser_.name), "e"))))));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testConcatFunc() {
        String query = "select CONCAT('', '') From CompUser e WHERE e.name='Seetha'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{this.cb.concat("", this.cb.literal((Object)""))});
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Seetha"));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testTrimFunc1() {
        String query = "select Trim(e.computerName) From CompUser e WHERE e.name='Shannon '";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{this.cb.trim((Expression)e.get(CompUser_.computerName))});
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Shannon "));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testTrimFunc2() {
        String query = "select e.computerName From CompUser e where Trim(e.name) = 'Shannon '";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(CompUser.class);
        q.where((Expression)this.cb.equal(this.cb.trim((Expression)e.get(CompUser_.name)), (Object)"Shannon"));
        q.multiselect(new Selection[]{e.get(CompUser_.computerName)});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testLowerFunc1() {
        String query = "select LOWER(e.name) From CompUser e WHERE e.computerName='UNIX'";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{this.cb.lower((Expression)e.get(CompUser_.name))});
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.computerName), (Object)"UNIX"));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testLowerFunc2() {
        String query = "select e.age From CompUser e where LOWER(e.name) ='ugo'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root e = q.from(CompUser.class);
        q.where((Expression)this.cb.equal(this.cb.lower((Expression)e.get(CompUser_.name)), (Object)"ugo"));
        q.select((Selection)e.get(CompUser_.age));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testUpperFunc1() {
        String query = "select UPPER(e.name) From CompUser e WHERE e.computerName='PC'";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.upper((Expression)e.get(CompUser_.name)));
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.computerName), (Object)"PC"));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testUpperFunc2() {
        String query = "select e.age from CompUser e where UPPER(e.name)='UGO'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root e = q.from(CompUser.class);
        q.where((Expression)this.cb.equal(this.cb.upper((Expression)e.get(CompUser_.name)), (Object)"UGO"));
        q.select((Selection)e.get(CompUser_.age));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testLengthFunc() {
        String query = "SELECT o.name FROM CompUser o WHERE LENGTH(o.address.country) = 3";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root e = q.from(CompUser.class);
        q.where((Expression)this.cb.equal(this.cb.length((Expression)e.get(CompUser_.address).get(Address_.country)), (Object)3));
        q.select((Selection)e.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testArithmFunc1() {
        String query = "select ABS(e.age) From CompUser e WHERE e.name='Seetha'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.abs((Expression)e.get(CompUser_.age)));
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Seetha"));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testArithmFunc2() {
        String query = "select SQRT(e.age) From CompUser e WHERE e.name='Seetha'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Double.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.sqrt((Expression)e.get(CompUser_.age)));
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Seetha"));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testArithmFunc3() {
        String query = "select MOD(e.age, 4) From CompUser e WHERE e.name='Seetha'";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.mod((Expression)e.get(CompUser_.age), Integer.valueOf(4)));
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.name), (Object)"Seetha"));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testArithmFunc4() {
        String query = "SELECT e.name FROM CompUser e WHERE SIZE(e.nicknames) = 6";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root e = q.from(CompUser.class);
        q.where((Expression)this.cb.equal(this.cb.size(e.get(CompUser_.nicknames)), (Object)6));
        q.select((Selection)e.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testGroupByHavingClause() {
        String query = "SELECT c.name FROM CompUser c GROUP BY c.name HAVING c.name LIKE 'S%'";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root e = q.from(CompUser.class);
        q.groupBy(new Expression[]{e.get(CompUser_.name)});
        q.having((Expression)this.cb.like((Expression)e.get(CompUser_.name), "S%"));
        q.select((Selection)e.get(CompUser_.name));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testOrderByClause() {
        String query = "SELECT c.name FROM CompUser c WHERE c.name LIKE 'S%' ORDER BY c.name";
        OpenJPACriteriaQuery q = this.cb.createQuery(String.class);
        Root e = q.from(CompUser.class);
        q.where((Expression)this.cb.like((Expression)e.get(CompUser_.name), "S%"));
        q.select((Selection)e.get(CompUser_.name));
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(CompUser_.name))});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testAVGAggregFunc() {
        String query = "SELECT AVG(e.age) FROM CompUser e";
        OpenJPACriteriaQuery q = this.cb.createQuery(Double.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.avg((Expression)e.get(CompUser_.age)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testCOUNTAggregFunc() {
        String query = "SELECT COUNT(c.name) FROM CompUser c";
        OpenJPACriteriaQuery q = this.cb.createQuery(Long.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.count((Expression)e.get(CompUser_.name)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testMAXAggregFunc() {
        String query = "SELECT DISTINCT MAX(c.age) FROM CompUser c";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.max((Expression)e.get(CompUser_.age))).distinct(true);
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testMINAggregFunc() {
        String query = "SELECT DISTINCT MIN(c.age) FROM CompUser c";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.min((Expression)e.get(CompUser_.age))).distinct(true);
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSUMAggregFunc() {
        String query = "SELECT SUM(c.age) FROM CompUser c";
        OpenJPACriteriaQuery q = this.cb.createQuery(Integer.class);
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.sum((Expression)e.get(CompUser_.age)));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testTypeExpression1() {
        String jpql = "SELECT e FROM CompUser e where TYPE(e) in (:a, :b) ORDER By e.name";
        OpenJPACriteriaQuery cq = this.cb.createQuery(CompUser.class);
        Root e = cq.from(CompUser.class);
        cq.select((Selection)e);
        ParameterExpression param1 = this.cb.parameter(Class.class, "a");
        ParameterExpression param2 = this.cb.parameter(Class.class, "b");
        cq.where((Expression)e.type().in(new Object[]{param1, param2}));
        cq.orderBy(new Order[]{this.cb.asc((Expression)e.get(CompUser_.name))});
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("a", MaleUser.class);
                q.setParameter("b", FemaleUser.class);
            }
        }, (CriteriaQuery<?>)cq, jpql);
    }

    public void testTypeExpression2() {
        String query = "SELECT TYPE(e) FROM CompUser e where TYPE(e) <> :t";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        ParameterExpression param1 = this.cb.parameter(Class.class, "t");
        Expression etype = e.type();
        q.multiselect(new Selection[]{e.type()});
        q.where((Expression)this.cb.equal(e.type(), (Object)param1).not());
        this.assertEquivalence(new AbstractCriteriaTestCase.QueryDecorator(){

            @Override
            public void decorate(Query q) {
                q.setParameter("t", MaleUser.class);
            }
        }, (CriteriaQuery<?>)q, query);
    }

    public void testTypeExpression3() {
        String query = "SELECT e, FemaleUser, a FROM Address a, FemaleUser e where e.address IS NOT NULL";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root a = q.from(Address.class);
        Root e = q.from(FemaleUser.class);
        q.multiselect(new Selection[]{e, this.cb.literal(FemaleUser.class), a});
        q.where((Expression)e.get(FemaleUser_.address).isNotNull());
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testTypeExpression4() {
        String query = "SELECT e FROM CompUser e where TYPE(e) = MaleUser";
        OpenJPACriteriaQuery cq = this.cb.createQuery(CompUser.class);
        Root e = cq.from(CompUser.class);
        cq.select((Selection)e);
        cq.where((Expression)this.cb.equal(e.type(), this.cb.literal(MaleUser.class)));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testTypeExpression5() {
        String query = "SELECT e FROM CompUser e where TYPE(e) in (MaleUser)";
        OpenJPACriteriaQuery cq = this.cb.createQuery(CompUser.class);
        Root e = cq.from(CompUser.class);
        cq.where((Expression)this.cb.in(e.type()).value(MaleUser.class));
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testTypeExpression6() {
        String query = "SELECT e FROM CompUser e where TYPE(e) not in (MaleUser, FemaleUser)";
        OpenJPACriteriaQuery cq = this.cb.createQuery(CompUser.class);
        Root e = cq.from(CompUser.class);
        cq.where((Expression)this.cb.in(e.type()).value(MaleUser.class).value(FemaleUser.class).not());
        this.assertEquivalence((CriteriaQuery<?>)cq, query);
    }

    public void testTypeExpression7() {
        String query = "SELECT TYPE(a.b) FROM A a";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root a = q.from(A.class);
        q.multiselect(new Selection[]{a.get(A_.b).type()});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testTypeExpression8() {
        String query = "SELECT MaleUser FROM A a";
        OpenJPACriteriaQuery q = this.cb.createQuery(Class.class);
        Root a = q.from(A.class);
        q.multiselect(new Selection[]{this.cb.literal(MaleUser.class)});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testTypeExpression9() {
        String query = "SELECT  CASE TYPE(e) WHEN FemaleUser THEN 'Female'  ELSE 'Male' END FROM CompUser e";
        OpenJPACriteriaQuery q = this.cb.createQuery();
        Root e = q.from(CompUser.class);
        q.select((Selection)this.cb.selectCase(e.type()).when(FemaleUser.class, (Object)"Female").otherwise((Object)"Male"));
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testCoalesceExpressions() {
        String query = "SELECT e.name, COALESCE (e.address.country, 'Unknown') FROM CompUser e ORDER BY e.name DESC";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{e.get(CompUser_.name), this.cb.coalesce().value((Expression)e.get(CompUser_.address).get(Address_.country)).value((Object)"Unknown")});
        q.orderBy(new Order[]{this.cb.desc((Expression)e.get(CompUser_.name))});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testNullIfExpressions() {
        String query = "SELECT e.name, NULLIF (e.address.country, 'USA') FROM CompUser e ORDER BY e.name DESC";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{e.get(CompUser_.name), this.cb.nullif((Expression)e.get(CompUser_.address).get(Address_.country), (Object)"USA")});
        q.orderBy(new Order[]{this.cb.desc((Expression)e.get(CompUser_.name))});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSimpleCaseExpression1() {
        String query = "SELECT e.name, e.age+1, CASE e.address.country WHEN 'USA' THEN 'us'  ELSE 'non-us' END, e.address.country  FROM CompUser e";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        Expression cage = this.cb.sum((Expression)e.get(CompUser_.age), (Number)1);
        Expression d2 = this.cb.selectCase((Expression)e.get(CompUser_.address).get(Address_.country)).when((Object)"USA", (Object)"us").otherwise((Object)"non-us");
        q.multiselect(new Selection[]{e.get(CompUser_.name), cage, d2, e.get(CompUser_.address).get(Address_.country)});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSimpleCaseExpression2() {
        String query = "SELECT e.name, e.age+1, CASE e.address.country WHEN 'USA' THEN 'United-States'  ELSE e.address.country  END, e.address.country  FROM CompUser e";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        Expression cage = this.cb.sum((Expression)e.get(CompUser_.age), (Number)1);
        Expression d2 = this.cb.selectCase((Expression)e.get(CompUser_.address).get(Address_.country)).when((Object)"USA", (Object)"United-States").otherwise((Expression)e.get(CompUser_.address).get(Address_.country));
        q.multiselect(new Selection[]{e.get(CompUser_.name), cage, d2, e.get(CompUser_.address).get(Address_.country)});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSimpleCaseExpression3() {
        String query = "SELECT e.name,  CASE TYPE(e) WHEN FemaleUser THEN 'Female'  ELSE 'Male' END FROM CompUser e WHERE e.name like 'S%'  ORDER BY e.name DESC";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{e.get(CompUser_.name), this.cb.selectCase(e.type()).when(FemaleUser.class, (Object)"Female").otherwise((Object)"Male")});
        q.where((Expression)this.cb.like((Expression)e.get(CompUser_.name), "S%"));
        q.orderBy(new Order[]{this.cb.desc((Expression)e.get(CompUser_.name))});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testSimpleCaseExpression4() {
        String query = "SELECT e.name, CASE e.address.country WHEN 'USA' THEN true ELSE false END, e.address.country FROM CompUser e";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        Expression b = this.cb.selectCase((Expression)e.get(CompUser_.address).get(Address_.country)).when((Object)"USA", (Object)true).otherwise((Object)false);
        q.multiselect(new Selection[]{e.get(CompUser_.name), b, e.get(CompUser_.address).get(Address_.country)});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testGeneralCaseExpression1() {
        String query = "SELECT e.name, e.age,  CASE WHEN e.age > 30 THEN e.age - 1  WHEN e.age < 15 THEN e.age + 1 ELSE e.age + 0  END FROM CompUser e";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        Expression cage = this.cb.selectCase().when((Expression)this.cb.gt((Expression)e.get(CompUser_.age), (Number)30), this.cb.diff((Expression)e.get(CompUser_.age), (Number)1)).when((Expression)this.cb.lt((Expression)e.get(CompUser_.age), (Number)15), this.cb.sum((Expression)e.get(CompUser_.age), (Number)1)).otherwise(this.cb.sum((Expression)e.get(CompUser_.age), (Number)0));
        q.multiselect(new Selection[]{e.get(CompUser_.name), e.get(CompUser_.age), cage});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testGeneralCaseExpression2() {
        String query = "SELECT e.name, e.age+1, CASE WHEN e.address.country = 'USA'  THEN 'United-States'  ELSE 'Non United-States'  END, e.address.country  FROM CompUser e";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        Expression d2 = this.cb.selectCase().when((Expression)this.cb.equal((Expression)e.get(CompUser_.address).get(Address_.country), (Object)"USA"), (Object)"United-States").otherwise((Object)"Non United-States");
        Expression cage = this.cb.sum((Expression)e.get(CompUser_.age), (Number)1);
        q.multiselect(new Selection[]{e.get(CompUser_.name), cage, d2, e.get(CompUser_.address).get(Address_.country)});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testGeneralCaseExpression3() {
        String query = " select e.name, CASE WHEN e.age = 11 THEN org.apache.openjpa.persistence.criteria.CompUser$CreditRating.POOR WHEN e.age = 35 THEN org.apache.openjpa.persistence.criteria.CompUser$CreditRating.GOOD ELSE org.apache.openjpa.persistence.criteria.CompUser$CreditRating.EXCELLENT END FROM CompUser e ORDER BY e.age";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{e.get(CompUser_.name), this.cb.selectCase().when((Expression)this.cb.equal((Expression)e.get(CompUser_.age), (Object)11), (Object)CompUser.CreditRating.POOR).when((Expression)this.cb.equal((Expression)e.get(CompUser_.age), (Object)35), (Object)CompUser.CreditRating.GOOD).otherwise((Object)CompUser.CreditRating.EXCELLENT)});
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(CompUser_.age))});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }

    public void testGeneralCaseExpression4() {
        String query = "select e.name, e.creditRating from CompUser e where e.creditRating = (select CASE WHEN e1.age = 11 THEN org.apache.openjpa.persistence.criteria.CompUser$CreditRating.POOR WHEN e1.age = 35 THEN org.apache.openjpa.persistence.criteria.CompUser$CreditRating.GOOD ELSE org.apache.openjpa.persistence.criteria.CompUser$CreditRating.EXCELLENT END from CompUser e1 where e.userid = e1.userid) ORDER BY e.age";
        OpenJPACriteriaQuery q = this.cb.createTupleQuery();
        Root e = q.from(CompUser.class);
        q.multiselect(new Selection[]{e.get(CompUser_.name), e.get(CompUser_.creditRating)});
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(CompUser_.age))});
        Subquery sq = q.subquery(Object.class);
        Root e1 = sq.from(CompUser.class);
        sq.where((Expression)this.cb.equal((Expression)e.get(CompUser_.userid), (Expression)e1.get(CompUser_.userid)));
        q.where((Expression)this.cb.equal((Expression)e.get(CompUser_.creditRating), (Expression)sq.select(this.cb.selectCase().when((Expression)this.cb.equal((Expression)e1.get(CompUser_.age), (Object)11), (Object)CompUser.CreditRating.POOR).when((Expression)this.cb.equal((Expression)e1.get(CompUser_.age), (Object)35), (Object)CompUser.CreditRating.GOOD).otherwise((Object)CompUser.CreditRating.EXCELLENT))));
        q.orderBy(new Order[]{this.cb.asc((Expression)e.get(CompUser_.age))});
        this.assertEquivalence((CriteriaQuery<?>)q, query);
    }
}

