/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria.results;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.PostgresDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.criteria.results.Item;
import org.apache.openjpa.persistence.criteria.results.Item_;
import org.apache.openjpa.persistence.criteria.results.Order;
import org.apache.openjpa.persistence.criteria.results.OrderProducer;
import org.apache.openjpa.persistence.criteria.results.Order_;
import org.apache.openjpa.persistence.criteria.results.Producer;
import org.apache.openjpa.persistence.criteria.results.Shop;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestTypedResults
extends SingleEMFTestCase {
    private static final int N_ORDERS = 15;
    private static final int N_ITEMS_PER_ORDER = 3;
    private static final String[] ORDER_DATES = new String[]{"3/12/2008 1:00 PM", "10/01/2008 1:51 AM", "12/12/2008 10:01 AM", "5/21/2009 3:23 PM"};
    DateFormat df = DateFormat.getDateInstance(3, Locale.US);

    @Override
    public void setUp() throws Exception {
        this.setUp(CLEAR_TABLES, Order.class, Item.class, Shop.class, Producer.class, "openjpa.DynamicEnhancementAgent", "false");
        this.populate();
    }

    public void populate() throws ParseException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Shop s = new Shop();
        s.setId(1L);
        s.setName("eBay.com");
        s.setOrders(new HashSet<Order>());
        for (int i = 1; i <= 15; ++i) {
            Order order = new Order();
            order.setId(i);
            order.setDate(this.df.parse(ORDER_DATES[i % ORDER_DATES.length]));
            order.setFilled(i % 2 == 0);
            order.setShop(s);
            order.setItems(new HashSet<Item>());
            s.getOrders().add(order);
            for (int j = 1; j <= 3; ++j) {
                Item item = new Item();
                item.setOrder(order);
                order.getItems().add(item);
                Producer p = new Producer();
                p.setName("filler");
                p.setItem(item);
                item.setProduct(p);
            }
        }
        em.persist((Object)s);
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTypedJPQLQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query jpqlQuery = em.createQuery("Select o from Order o where o.filled = true");
        List jpqlResults = jpqlQuery.getResultList();
        TestTypedResults.assertEquals((int)7, (int)jpqlResults.size());
        TypedQuery jpqlTypedQuery = em.createQuery("Select o from Order o where o.filled = true", Order.class);
        List jpqlTypedResults = jpqlTypedQuery.getResultList();
        TestTypedResults.assertEquals((int)7, (int)jpqlTypedResults.size());
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Order.class);
        Root order = cq.from(Order.class);
        cq.select((Selection)order).where((Expression)qb.equal((Expression)order.get(Order_.filled), (Object)Boolean.TRUE));
        TypedQuery typedCriteriaQuery = em.createQuery(cq);
        List typedCriteriaResults = typedCriteriaQuery.getResultList();
        TestTypedResults.assertEquals((int)7, (int)typedCriteriaResults.size());
        DBDictionary dict = ((JDBCConfiguration)this.emf.getConfiguration()).getDBDictionaryInstance();
        String sql = "SELECT * FROM CRIT_RES_ORD o WHERE (o.filled = 1)";
        if (dict instanceof PostgresDictionary) {
            sql = "SELECT * FROM CRIT_RES_ORD o WHERE (o.filled = true)";
        }
        Query nativeQ = em.createNativeQuery(sql, Order.class);
        List typedNativeResults = nativeQ.getResultList();
        TestTypedResults.assertEquals((int)7, (int)typedNativeResults.size());
        for (Order o : jpqlResults) {
            TestTypedResults.assertTrue((boolean)jpqlTypedResults.contains(o));
            TestTypedResults.assertTrue((boolean)typedCriteriaResults.contains(o));
            TestTypedResults.assertTrue((boolean)typedNativeResults.contains(o));
        }
        em.close();
    }

    public void testDateQuery() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Date maxDate = this.df.parse(ORDER_DATES[2]);
        Query jpqlQuery = em.createQuery("Select o from Order o where o.date < :maxDate");
        jpqlQuery.setParameter("maxDate", (Object)maxDate);
        List jpqlResults = jpqlQuery.getResultList();
        TestTypedResults.assertEquals((int)7, (int)jpqlResults.size());
        TypedQuery typedJpqlQuery = em.createQuery("Select o from Order o where o.date < :maxDate", Order.class);
        typedJpqlQuery.setParameter("maxDate", (Object)maxDate);
        List typedJpqlResults = typedJpqlQuery.getResultList();
        TestTypedResults.assertEquals((int)7, (int)typedJpqlResults.size());
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = qb.createQuery(Order.class);
        Root order = criteriaQuery.from(Order.class);
        criteriaQuery.select((Selection)order).where((Expression)qb.lessThan((Expression)order.get(Order_.date), (Expression)qb.parameter(Date.class, "maxDate")));
        TypedQuery tq = em.createQuery(criteriaQuery);
        tq.setParameter("maxDate", (Object)maxDate);
        List criteriaResults = tq.getResultList();
        TestTypedResults.assertEquals((int)7, (int)criteriaResults.size());
        Query nativeQuery = em.createNativeQuery("Select * from CRIT_RES_ORD o WHERE (o.cdate < ?1)", Order.class);
        nativeQuery.setParameter(1, (Object)maxDate);
        List nativeResults = nativeQuery.getResultList();
        TestTypedResults.assertEquals((int)7, (int)nativeResults.size());
        for (Order o : jpqlResults) {
            TestTypedResults.assertTrue((boolean)typedJpqlResults.contains(o));
            TestTypedResults.assertTrue((boolean)criteriaResults.contains(o));
            TestTypedResults.assertTrue((boolean)nativeResults.contains(o));
        }
        em.close();
    }

    public void testMultiSelect() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Query jpqlQuery = em.createQuery("SELECT o, p from Order o JOIN o.items i JOIN i.producer p WHERE o.filled = true");
        List jpqlResults = jpqlQuery.getResultList();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = qb.createTupleQuery();
        Root order = criteriaQuery.from(Order.class);
        Join producer = order.join(Order_.items).join(Item_.producer);
        criteriaQuery.select((Selection)qb.tuple(new Selection[]{order, producer}));
        criteriaQuery.where((Expression)qb.equal((Expression)order.get(Order_.filled), (Object)Boolean.TRUE));
        TypedQuery eq = em.createQuery(criteriaQuery);
        List criteriaResults = eq.getResultList();
        CriteriaQuery constructQuery = qb.createQuery(OrderProducer.class);
        Root order2 = constructQuery.from(Order.class);
        Join producer2 = order.join(Order_.items).join(Item_.producer);
        constructQuery.select((Selection)qb.construct(OrderProducer.class, new Selection[]{order2, producer2}));
        constructQuery.where((Expression)qb.equal((Expression)order2.get(Order_.filled), (Object)Boolean.TRUE));
        TypedQuery typedQuery = em.createQuery(constructQuery);
        List constructResults = typedQuery.getResultList();
        TestTypedResults.assertEquals((int)21, (int)jpqlResults.size());
        TestTypedResults.assertEquals((int)21, (int)criteriaResults.size());
        TestTypedResults.assertEquals((int)21, (int)constructResults.size());
        for (Object[] os : jpqlResults) {
            TestTypedResults.assertEquals((int)2, (int)os.length);
            TestTypedResults.assertTrue((boolean)(os[0] instanceof Order));
            TestTypedResults.assertTrue((boolean)(os[1] instanceof Producer));
        }
        for (int i = 0; i < jpqlResults.size(); ++i) {
            Object[] jpqlTuple = (Object[])jpqlResults.get(i);
            Tuple criteriaTuple = (Tuple)criteriaResults.get(i);
            OrderProducer constructTuple = (OrderProducer)constructResults.get(i);
            TestTypedResults.assertEquals((Object)jpqlTuple[0], (Object)criteriaTuple.get(0));
            TestTypedResults.assertEquals((Object)jpqlTuple[1], (Object)criteriaTuple.get(1));
            TestTypedResults.assertEquals((Object)jpqlTuple[0], (Object)constructTuple.getOrder());
            TestTypedResults.assertEquals((Object)jpqlTuple[1], (Object)constructTuple.getProducer());
        }
        em.close();
    }
}

