/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.ArrayList;
import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.common.apps.AttachA;
import org.apache.openjpa.persistence.datacache.common.apps.AttachB;
import org.apache.openjpa.persistence.datacache.common.apps.AttachC;
import org.apache.openjpa.persistence.datacache.common.apps.AttachD;
import org.apache.openjpa.persistence.datacache.common.apps.AttachE;

public class CacheLoadTest
extends AbstractTestCase {
    private EntityManagerFactory emf;
    protected int threadCount = Integer.getInteger("cachetest.threads", 30);
    protected int interationCount = Integer.getInteger("cachetest.iterations", 1000);

    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.QueryCache", "true");
        this.emf = this.getEmf(propsMap);
    }

    @Override
    public void tearDown() throws Exception {
        this.closeEMF(this.emf);
        this.emf = null;
        super.tearDown();
    }

    public void testCacheLoad() throws Exception {
        this.mttest(Integer.getInteger("cachetest.threads", 30), Integer.getInteger("cachetest.iterations", 1000));
        switch ((int)(Math.random() * 4.0)) {
            case 0: {
                this.insert();
                break;
            }
            case 1: {
                this.query();
                break;
            }
            case 2: {
                this.delete();
                break;
            }
            case 3: {
                this.read();
            }
        }
    }

    private int rnd(int num) {
        return CacheLoadTest.randomInt() % num;
    }

    private void insert() throws Exception {
        EntityManager em = this.emf.createEntityManager();
        this.startTx(em);
        for (int i = 0; i < this.rnd(100); ++i) {
            em.persist(CacheLoadTest.randomizeBean(this.rndclass().newInstance()));
        }
        this.endTx(em);
        this.endEm(em);
    }

    private void query() {
        OpenJPAEntityManager em = (OpenJPAEntityManager)this.emf.createEntityManager();
        String[] filters = new String[]{"select from " + AttachA.class.getName() + " where aint > 0", "select from " + AttachA.class.getName() + " where aint < 0", "select from " + AttachB.class.getName() + " where aint > 0", "select from " + AttachB.class.getName() + " where aint < 0", "select from " + AttachC.class.getName() + " where aint > 0", "select from " + AttachC.class.getName() + " where aint < 0"};
        for (int i = 0; i < this.rnd(50); ++i) {
            try {
                new ArrayList(em.createQuery("org.apache.openjpa.kernel.jpql.JPQL", filters[CacheLoadTest.randomInt() % filters.length]).getResultList());
                continue;
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
        this.endEm((EntityManager)em);
    }

    private void delete() {
        try {
            OpenJPAEntityManager em = (OpenJPAEntityManager)this.emf.createEntityManager();
            this.startTx((EntityManager)em);
            for (Object o : em.createExtent(this.rndclass(), Math.random() > 0.5)) {
                if (!(Math.random() > (double)0.6f)) continue;
                em.remove(o);
            }
            this.endTx((EntityManager)em);
            this.endEm((EntityManager)em);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read() {
        OpenJPAEntityManager em = (OpenJPAEntityManager)this.emf.createEntityManager();
        for (Object e : em.createExtent(this.rndclass(), Math.random() > 0.5)) {
        }
        this.endEm((EntityManager)em);
    }

    private Class rndclass() {
        Class[] c = new Class[]{AttachA.class, AttachB.class, AttachC.class, AttachD.class, AttachE.class};
        return c[(int)(Math.random() * (double)c.length)];
    }
}

