/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.datacache.ConcurrentDataCache;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.datacache.DelegatingDataCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.TypesChangedEvent;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestHelper;
import org.apache.openjpa.persistence.datacache.DistributedCacheTest;
import org.apache.openjpa.persistence.datacache.TestLocalCache;
import org.apache.openjpa.persistence.datacache.common.apps.AppIdCacheObject;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectA;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectAChild1;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectAChild2;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectB;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectBChild1;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectC;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectD;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectE;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectF;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectG;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectH;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectInterface;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectJ;
import org.apache.openjpa.persistence.datacache.common.apps.RuntimeTest1;
import org.apache.openjpa.util.CacheMap;
import org.apache.openjpa.util.Id;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.ProxyDate;

public abstract class CacheTest
extends AbstractTestCase {
    private static String ORIG_NAME = "origName";
    private static String NEW_NAME = "newName";
    private static int ORIG_AGE = 30;
    private static String ORIG_PARENT_NAME = "origParentName";
    private static int ORIG_PARENT_AGE = 31;
    private OpenJPAEntityManagerFactory timeoutFactory = null;
    private OpenJPAEntityManagerFactory factory = null;
    private OpenJPAEntityManagerFactory factory2 = null;
    private MetaDataRepository repos;
    private Object oid;
    private Object parentOid;
    private Object oidwithclass;
    private OpenJPAEntityManager em;
    private CacheObjectA a;

    public CacheTest(String test) {
        super(test, "datacachecactusapp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception {
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            Class[] toDelete = new Class[]{CacheObjectA.class, CacheObjectB.class, CacheObjectC.class, CacheObjectD.class, CacheObjectE.class, CacheObjectJ.class, AppIdCacheObject.class};
            for (int i = 0; i < toDelete.length; ++i) {
                this.startTx((EntityManager)em);
                Extent e = em.createExtent(toDelete[i], true);
                Iterator it = e.iterator();
                while (it.hasNext()) {
                    em.remove(it.next());
                }
                this.endTx((EntityManager)em);
            }
        }
        catch (OpenJPAException jpae) {
            Throwable[] ts = jpae.getNestedThrowables();
            for (int i = 0; ts != null && i < ts.length; ++i) {
                ts[i].printStackTrace();
            }
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    protected abstract String[] getConfs();

    protected abstract String[] getConfs2();

    protected boolean isCacheCoherent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        CacheObjectA aparent;
        CacheObjectA a;
        String[] confs = this.getConfs();
        String[] confs2 = this.getConfs2();
        HashMap<String, String> propsMap1 = new HashMap<String, String>();
        for (int i = 0; i < confs.length; i += 2) {
            propsMap1.put(confs[i], confs[i + 1]);
        }
        HashMap<String, String> propsMap2 = new HashMap<String, String>();
        for (int i = 0; i < confs2.length; i += 2) {
            propsMap2.put(confs2[i], confs2[i + 1]);
        }
        this.factory = this.getEmf(propsMap1);
        this.factory2 = this.getEmf(propsMap2);
        this.repos = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.factory).getConfiguration().getMetaDataRepositoryInstance();
        String[] biggerConfs = new String[confs.length + 2];
        System.arraycopy(confs, 0, biggerConfs, 0, confs.length);
        biggerConfs[biggerConfs.length - 2] = "openjpa.DataCacheTimeout";
        biggerConfs[biggerConfs.length - 1] = "1000";
        HashMap<String, String> propsMap3 = new HashMap<String, String>();
        for (int i = 0; i < biggerConfs.length; i += 2) {
            propsMap3.put(biggerConfs[i], biggerConfs[i + 1]);
        }
        this.timeoutFactory = this.getEmf(propsMap3);
        this.clear();
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            a = new CacheObjectA(ORIG_NAME, ORIG_AGE);
            aparent = new CacheObjectA(ORIG_PARENT_NAME, ORIG_PARENT_AGE);
            a.setRelatedObject(aparent);
            LinkedList<CacheObjectA> children = new LinkedList<CacheObjectA>();
            children.add(a);
            aparent.setRelatedCollection(children);
            this.startTx((EntityManager)em);
            em.persist((Object)a);
            em.persist((Object)aparent);
            this.oid = em.getObjectId((Object)a);
            this.oidwithclass = new Id(CacheObjectA.class, this.oid.toString());
            this.parentOid = em.getObjectId((Object)aparent);
            this.endTx((EntityManager)em);
        }
        finally {
            this.endEm((EntityManager)em);
        }
        this.em = this.factory.createEntityManager();
        this.startTx((EntityManager)this.em);
        try {
            this.a = (CacheObjectA)this.em.find(CacheObjectA.class, this.oid);
            CacheObjectA rel = this.a.getRelatedObject();
            rel.getRelatedCollection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.endTx((EntityManager)this.em);
        }
        em = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            a = (CacheObjectA)em.find(CacheObjectA.class, this.oid);
            a.setName(NEW_NAME);
            aparent = (CacheObjectA)em.find(CacheObjectA.class, this.parentOid);
            CacheObjectA a2 = new CacheObjectA(ORIG_NAME, ORIG_AGE);
            a2.setRelatedObject(aparent);
            aparent.getRelatedCollection().add(a2);
            em.persist((Object)a2);
            this.endTx((EntityManager)em);
            this.assertNew(a);
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.endEm((EntityManager)this.em);
        this.em = null;
        this.repos = null;
        try {
            this.closeEMF((EntityManagerFactory)this.factory);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.factory = null;
        try {
            this.closeEMF((EntityManagerFactory)this.factory2);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.factory2 = null;
        try {
            this.closeEMF((EntityManagerFactory)this.timeoutFactory);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
        this.timeoutFactory = null;
        this.oid = null;
        this.parentOid = null;
        this.a = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeletedOneToOneRelations() throws Exception {
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            CacheObjectA a = (CacheObjectA)em.find(CacheObjectA.class, this.oid);
            CacheTest.assertNotNull((Object)a.getRelatedObject());
            em.remove((Object)a.getRelatedObject());
            this.endTx((EntityManager)em);
        }
        finally {
            this.endEm((EntityManager)em);
        }
        OpenJPAEntityManager em2 = this.factory.createEntityManager();
        try {
            CacheObjectA a2 = (CacheObjectA)em2.find(CacheObjectA.class, this.oid);
            CacheTest.assertNull((Object)a2.getRelatedObject());
        }
        finally {
            this.endEm((EntityManager)em2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanCacheExtension() throws Exception {
        Object oid;
        Object o;
        DataCache cache = this.cacheManager(this.factory).getSystemDataCache();
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            o = new CacheObjectB("foo");
            em.persist(o);
            this.endTx((EntityManager)em);
            oid = em.getObjectId(o);
            CacheTest.assertNotNull((Object)oid);
            CacheTest.assertNull((Object)cache.get(oid));
        }
        finally {
            this.endEm((EntityManager)em);
        }
        em = this.factory.createEntityManager();
        try {
            o = em.find(CacheObjectB.class, oid);
            CacheTest.assertNotNull((Object)o);
            CacheTest.assertNull((Object)cache.get(oid));
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    public void testGetCache() {
        DataCache defaultCache = this.cacheManager(this.factory).getDataCache("default", false);
        CacheTest.assertNotNull((Object)defaultCache);
        DataCache cache = this.cacheManager(this.factory).getSystemDataCache();
        CacheTest.assertEquals((Object)defaultCache, (Object)cache);
        ClassMetaData aMeta = this.repos.getMetaData(CacheObjectA.class, null, true);
        ClassMetaData aChild1Meta = this.repos.getMetaData(CacheObjectAChild1.class, null, true);
        ClassMetaData aChild2Meta = this.repos.getMetaData(CacheObjectAChild2.class, null, true);
        ClassMetaData bMeta = this.repos.getMetaData(CacheObjectB.class, null, true);
        ClassMetaData bChild1Meta = this.repos.getMetaData(CacheObjectBChild1.class, null, true);
        ClassMetaData cMeta = this.repos.getMetaData(CacheObjectC.class, null, true);
        ClassMetaData dMeta = this.repos.getMetaData(CacheObjectD.class, null, true);
        ClassMetaData eMeta = this.repos.getMetaData(CacheObjectE.class, null, true);
        cache = aMeta.getDataCache();
        CacheTest.assertEquals((Object)defaultCache, (Object)cache);
        System.out.println("******DataCacheName:" + aChild2Meta.getDataCacheName());
        CacheTest.assertNull((Object)aChild2Meta.getDataCache());
        CacheTest.assertNull((Object)bMeta.getDataCache());
        CacheTest.assertEquals((Object)cMeta.getDataCache(), (Object)dMeta.getDataCache());
        if (dMeta.getDataCache() instanceof ConcurrentDataCache) {
            ConcurrentDataCache dCacheImpl = (ConcurrentDataCache)dMeta.getDataCache();
            CacheTest.assertEquals((int)10, (int)dCacheImpl.getCacheSize());
        }
        CacheTest.assertEquals((Object)aMeta.getDataCache(), (Object)eMeta.getDataCache());
    }

    public void testPrimitives() throws Exception {
        this.assertOld(this.a);
        this.em.refresh((Object)this.a);
        this.assertNew(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExpiredRelations() {
        CacheObjectA a = (CacheObjectA)this.em.find(CacheObjectA.class, this.oid);
        this.em.refresh((Object)a);
        Object relationOid = this.em.getObjectId((Object)a.getRelatedObject());
        relationOid = new Id(CacheObjectA.class, relationOid.toString());
        ClassMetaData meta = this.repos.getMetaData(CacheObjectA.class, null, true);
        DataCache cache = meta.getDataCache();
        cache.remove(relationOid);
        OpenJPAEntityManager em2 = this.factory.createEntityManager();
        try {
            CacheTest.assertTrue((boolean)cache.contains(this.oidwithclass));
            try {
                CacheTest.assertFalse((boolean)cache.contains(relationOid));
            }
            catch (AssertionFailedError e) {
                e.printStackTrace();
            }
        }
        finally {
            this.endEm((EntityManager)em2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPCArrays() throws Exception {
        OpenJPAEntityManager newEm = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)newEm);
            CacheObjectA parent = (CacheObjectA)newEm.find(CacheObjectA.class, this.parentOid);
            CacheObjectA a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            a.setRelatedArray(new CacheObjectA[]{parent, a});
            this.endTx((EntityManager)newEm);
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
        newEm = this.factory.createEntityManager();
        try {
            this.a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            CacheObjectA[] array = this.a.getRelatedArray();
            CacheTest.assertEquals((int)2, (int)array.length);
            CacheTest.assertTrue((boolean)(array[0] instanceof CacheObjectA));
            CacheTest.assertTrue((boolean)(array[1] instanceof CacheObjectA));
            Object arrayOid = newEm.getObjectId((Object)array[0]);
            if (!arrayOid.equals(this.parentOid) && !arrayOid.equals(this.oid)) {
                CacheTest.fail((String)"array does not contain correct oids");
            }
            if (!(arrayOid = newEm.getObjectId((Object)array[1])).equals(this.parentOid) && !arrayOid.equals(this.oid)) {
                CacheTest.fail((String)"array does not contain correct oids");
            }
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringArrays() throws Exception {
        OpenJPAEntityManager newEm = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)newEm);
            CacheObjectA a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            a.setStringArray(new String[]{"string0", "string1", "string2"});
            this.endTx((EntityManager)newEm);
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
        newEm = this.factory.createEntityManager();
        try {
            this.a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            String[] array = this.a.getStringArray();
            CacheTest.assertEquals((int)3, (int)array.length);
            CacheTest.assertEquals((String)"string0", (String)array[0]);
            CacheTest.assertEquals((String)"string1", (String)array[1]);
            CacheTest.assertEquals((String)"string2", (String)array[2]);
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrimitiveArrays() throws Exception {
        OpenJPAEntityManager newEm = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)newEm);
            CacheObjectA a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            a.setPrimitiveArray(new float[]{0.0f, 1.0f, 2.0f});
            this.endTx((EntityManager)newEm);
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
        newEm = this.factory.createEntityManager();
        try {
            this.a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            float[] array = this.a.getPrimitiveArray();
            CacheTest.assertEquals((int)3, (int)array.length);
            CacheTest.assertEquals((float)0.0f, (float)array[0], (float)0.0f);
            CacheTest.assertEquals((float)1.0f, (float)array[1], (float)0.0f);
            CacheTest.assertEquals((float)2.0f, (float)array[2], (float)0.0f);
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateArrays() throws Exception {
        Date[] dateArray;
        CacheObjectA a;
        OpenJPAEntityManager newEm = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)newEm);
            a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            dateArray = new Date[]{new Date(), new Date(), new Date()};
            a.setDateArray(dateArray);
            this.endTx((EntityManager)newEm);
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
        newEm = this.factory.createEntityManager();
        try {
            a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            Date[] array = a.getDateArray();
            if (array[0] == dateArray[0]) {
                CacheTest.fail((String)"date objects are the same");
            }
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDate() throws Exception {
        Date d;
        CacheObjectA a;
        OpenJPAEntityManager newEm = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)newEm);
            a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            d = new Date();
            a.setDate(d);
            this.endTx((EntityManager)newEm);
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
        Thread.sleep(100L);
        newEm = this.factory.createEntityManager();
        try {
            a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
            Date d2 = a.getDate();
            if (d == d2) {
                CacheTest.fail((String)"date objects are the same");
            }
            CacheTest.assertEquals((long)d.getTime(), (long)d2.getTime());
        }
        finally {
            this.endEm((EntityManager)newEm);
        }
    }

    public void testLocale() throws Exception {
        OpenJPAEntityManager newEm = this.factory.createEntityManager();
        this.startTx((EntityManager)newEm);
        CacheObjectA a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
        Locale l = Locale.getDefault();
        a.setLocale(l);
        this.endTx((EntityManager)newEm);
        OpenJPAEntityManager newEm2 = this.factory.createEntityManager();
        a = (CacheObjectA)newEm2.find(CacheObjectA.class, this.oid);
        Locale l2 = a.getLocale();
        if (l != l2) {
            CacheTest.fail((String)"locale objects are not the same.");
        }
        this.endEm((EntityManager)newEm);
        this.endEm((EntityManager)newEm2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicQuery() {
        this.basicQueries((EntityManager)this.factory.createEntityManager(), Boolean.FALSE, 3, 1);
        this.basicQueries((EntityManager)this.factory.createEntityManager(), Boolean.TRUE, 3, 1);
        QueryCache cache = this.cacheManager(this.factory).getSystemQueryCache();
        HashSet<Class> s = new HashSet<Class>();
        s.add(CacheObjectB.class);
        cache.onTypesChanged(new TypesChangedEvent((Object)this, s));
        this.basicQueries((EntityManager)this.factory.createEntityManager(), Boolean.TRUE, 3, 1);
        s.add(CacheObjectA.class);
        cache.onTypesChanged(new TypesChangedEvent((Object)this, s));
        this.basicQueries((EntityManager)this.factory.createEntityManager(), Boolean.FALSE, 3, 1);
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            CacheObjectA a = new CacheObjectA(ORIG_NAME, ORIG_AGE);
            em.persist((Object)a);
            this.endTx((EntityManager)em);
        }
        finally {
            this.endEm((EntityManager)em);
        }
        this.basicQueries((EntityManager)this.factory.createEntityManager(), Boolean.FALSE, 4, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicQueries(EntityManager em, Boolean inCache, int allSize, int origSize) {
        try {
            Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
            Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectA.class.getSimpleName() + " a"));
            q.setCandidateExtent(broker.newExtent(CacheObjectA.class, false));
            long start = System.currentTimeMillis();
            this.assertInCache(q, inCache);
            List l = (List)q.execute();
            this.iterate(l);
            long q1p1 = System.currentTimeMillis() - start;
            CacheTest.assertEquals((int)allSize, (int)l.size());
            start = System.currentTimeMillis();
            List l2 = (List)q.execute();
            this.iterate(l2);
            long q1p2 = System.currentTimeMillis() - start;
            CacheTest.assertEquals((int)allSize, (int)l2.size());
            q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name,a.age from " + CacheObjectA.class.getSimpleName() + " a where a.name = :n AND a.age = :a"));
            q.setCandidateExtent(broker.newExtent(CacheObjectA.class, false));
            start = System.currentTimeMillis();
            this.assertInCache(q, inCache, new Object[]{ORIG_NAME, new Integer(ORIG_AGE)});
            l = (List)q.execute(new Object[]{ORIG_NAME, new Integer(ORIG_AGE)});
            this.iterate(l);
            long q2p1 = System.currentTimeMillis() - start;
            CacheTest.assertEquals((int)origSize, (int)l.size());
            start = System.currentTimeMillis();
            l2 = (List)q.execute(new Object[]{ORIG_NAME, new Integer(ORIG_AGE)});
            this.iterate(l2);
            long q2p2 = System.currentTimeMillis() - start;
            CacheTest.assertEquals((int)origSize, (int)l2.size());
        }
        finally {
            this.endEm(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCacheableClass() {
        Broker broker = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.factory).newBroker();
        try {
            Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectB.class.getSimpleName() + " a"));
            Collection c = (Collection)q.execute();
            this.iterate(c);
            this.assertInCache(q, Boolean.TRUE);
        }
        finally {
            this.close(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCacheableAccessPath() {
        Broker broker = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.factory).newBroker();
        try {
            Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectA.class.getSimpleName() + " a where a.relatedB.str = 'foo'"));
            q.setCandidateExtent(broker.newExtent(CacheObjectA.class, false));
            Collection c = (Collection)q.execute();
            this.iterate(c);
            this.assertInCache(q, Boolean.TRUE);
        }
        finally {
            this.close(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCacheableSubclasses1() {
        Broker broker = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.factory).newBroker();
        try {
            Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectA.class.getSimpleName() + " a"));
            Collection c = (Collection)q.execute();
            this.iterate(c);
            this.assertInCache(q, Boolean.FALSE);
        }
        finally {
            this.close(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCacheableSubclasses2() {
        Broker broker = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.factory).newBroker();
        try {
            Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a from " + CacheObjectA.class.getSimpleName() + " a"));
            q.setCandidateExtent(broker.newExtent(CacheObjectA.class, false));
            Collection c = (Collection)q.execute();
            this.iterate(c);
            this.assertInCache(q, Boolean.TRUE);
        }
        finally {
            this.close(broker);
        }
    }

    public void testCacheNames() {
        this.assertCacheName(CacheObjectA.class, "default");
        this.assertCacheName(CacheObjectAChild1.class, "default");
        this.assertCacheName(CacheObjectAChild2.class, null);
        this.assertCacheName(CacheObjectB.class, null);
        this.assertCacheName(CacheObjectE.class, "default");
        this.assertCacheName(CacheObjectF.class, "default");
        this.assertCacheName(CacheObjectG.class, "default");
        this.assertCacheName(CacheObjectH.class, "default");
        this.assertCacheName(CacheObjectJ.class, "default");
        this.assertCacheName(AppIdCacheObject.class, "default");
    }

    private void assertCacheName(Class cls, String cacheName) {
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManagerFactory)this.factory, (Class)cls);
        if (cacheName == null) {
            CacheTest.assertNull((Object)meta.getDataCache());
        } else {
            CacheTest.assertNotNull((Object)meta.getDataCache());
            CacheTest.assertEquals((String)cacheName, (String)meta.getDataCache().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCache2() {
        DataCache cache;
        OpenJPAEntityManager em1;
        block4: {
            em1 = this.factory.createEntityManager();
            OpenJPAEntityManager em2 = null;
            try {
                CacheObjectA a1 = (CacheObjectA)em1.find(CacheObjectA.class, this.oid);
                em2 = this.factory2.createEntityManager();
                CacheObjectA a2 = (CacheObjectA)em2.find(CacheObjectA.class, this.oid);
                MetaDataRepository repos2 = ((OpenJPAEntityManagerFactorySPI)this.factory2).getConfiguration().getMetaDataRepositoryInstance();
                ClassMetaData meta = repos2.getMetaData(CacheObjectA.class, em2.getClassLoader(), true);
                cache = meta.getDataCache();
                CacheTest.assertTrue((boolean)cache.contains(this.oidwithclass));
                this.startTx((EntityManager)em1);
                a1.setName(a1.getName() + " changed");
                this.endTx((EntityManager)em1);
                if (em2 == null) break block4;
            }
            catch (Throwable throwable) {
                if (em2 != null) {
                    this.endEm((EntityManager)em2);
                }
                this.endEm((EntityManager)em1);
                throw throwable;
            }
            this.endEm((EntityManager)em2);
        }
        this.endEm((EntityManager)em1);
        if (!this.isCacheCoherent() && this.factory != this.factory2) {
            CacheTest.assertFalse((String)("key " + this.oid + " was in cache; should not have been"), (boolean)cache.contains(this.oidwithclass));
            return;
        }
        CacheTest.assertTrue((String)("key " + this.oid + " was not in cache; should have been"), (boolean)cache.contains(this.oidwithclass));
    }

    public void testTimeouts1() throws Exception {
        this.timeoutsTest1(30);
    }

    public void timeoutsTest1(int tries) throws Exception {
        Exception e = null;
        for (int i = 0; i < tries; ++i) {
            try {
                this.timeoutsHelper(this.factory);
                return;
            }
            catch (Exception ex) {
                e = ex;
                continue;
            }
        }
        throw e;
    }

    public void testTimeouts2() throws Exception {
        this.timeoutsTest2(30);
    }

    public void timeoutsTest2(int tries) throws Exception {
        AssertionFailedError e = null;
        for (int i = 0; i < tries; ++i) {
            try {
                this.timeoutsHelper(this.timeoutFactory);
                return;
            }
            catch (AssertionFailedError afe) {
                e = afe;
                continue;
            }
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutsHelper(OpenJPAEntityManagerFactory factory) throws Exception {
        OpenJPAEntityManager em = factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            Date startTime = new Date();
            CacheObjectE e = new CacheObjectE("e");
            em.persist((Object)e);
            CacheObjectF f = new CacheObjectF("f");
            em.persist((Object)f);
            CacheObjectG g = new CacheObjectG("g");
            em.persist((Object)g);
            CacheObjectH h = new CacheObjectH("h");
            em.persist((Object)h);
            this.endTx((EntityManager)em);
            Date persistTime = new Date();
            Object[] ids = new Object[]{new Id(CacheObjectE.class, em.getObjectId((Object)e).toString()), new Id(CacheObjectF.class, em.getObjectId((Object)f).toString()), new Id(CacheObjectG.class, em.getObjectId((Object)g).toString()), new Id(CacheObjectH.class, em.getObjectId((Object)h).toString())};
            Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
            Query q1 = broker.newQuery("javax.persistence.JPQL", (Object)("select a from " + CacheObjectE.class.getSimpleName() + " a"));
            q1.setCandidateExtent(broker.newExtent(CacheObjectE.class, false));
            this.iterate((Collection)q1.execute());
            this.assertInCache(q1, Boolean.TRUE);
            Query q2 = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectF.class.getSimpleName() + " a"));
            this.iterate((Collection)q2.execute());
            this.assertInCache(q2, Boolean.TRUE);
            Date currentTime = new Date();
            long diff = currentTime.getTime() - startTime.getTime();
            long diff2 = currentTime.getTime() - persistTime.getTime();
            long sleep = 0L;
            this.getLog().info((Object)("CacheTest.timeoutsHelper() testing all are still in the cache, elapsed time=" + diff));
            DataCache cache = this.cacheManager(factory).getDataCache("default", false);
            diff = Math.max(diff, diff2);
            if (diff < 450L) {
                this.checkCache(cache, ids, new boolean[]{true, true, true, true});
            } else {
                this.getLog().warn((Object)("CacheTest.timeoutsHelper() skipping checkCache(all, <500) because diff=" + diff + " and diff2=" + diff2));
            }
            currentTime = new Date();
            diff = currentTime.getTime() - startTime.getTime();
            diff2 = currentTime.getTime() - persistTime.getTime();
            sleep = Math.min(800L - diff, 800L - diff2);
            if (sleep < 0L) {
                this.getLog().warn((Object)("CacheTest.timeoutsHelper() skipping sleep for checkCache(h=500) because sleep=" + sleep));
            } else if (sleep > 10L) {
                this.getLog().info((Object)("CacheTest.timeoutsHelper() testing h to be dropped by waiting sleep=" + sleep));
                Thread.currentThread();
                Thread.sleep(700L);
                Thread.yield();
            } else {
                sleep = 0L;
            }
            currentTime = new Date();
            diff = currentTime.getTime() - startTime.getTime();
            diff2 = currentTime.getTime() - persistTime.getTime();
            diff = Math.max(diff, diff2);
            if (diff > 600L && diff < 900L) {
                this.checkCache(cache, ids, new boolean[]{true, true, true, false});
            } else {
                this.getLog().warn((Object)("CacheTest.timeoutsHelper() skipping checkCache(h=500) because diff=" + diff + " and diff2=" + diff2));
            }
            boolean eStatus = ((OpenJPAEntityManagerFactorySPI)factory).getConfiguration().getDataCacheTimeout() <= 0;
            currentTime = new Date();
            diff = currentTime.getTime() - startTime.getTime();
            diff2 = currentTime.getTime() - persistTime.getTime();
            diff = Math.max(diff, diff2);
            sleep = 2000L - diff;
            if (sleep < 0L) {
                this.getLog().warn((Object)("CacheTest.timeoutsHelper() skipping sleep for checkCache(f=000) because sleep=" + sleep));
            } else if (sleep > 10L) {
                this.getLog().info((Object)("CacheTest.timeoutsHelper() testing f to be dropped by waiting sleep=" + sleep));
                Thread.currentThread();
                Thread.sleep(sleep);
                Thread.yield();
            } else {
                sleep = 0L;
            }
            currentTime = new Date();
            diff = currentTime.getTime() - startTime.getTime();
            diff2 = currentTime.getTime() - persistTime.getTime();
            diff = Math.max(diff, diff2);
            if (diff < 4900L) {
                this.checkCache(cache, ids, new boolean[]{eStatus, false, true, false});
            } else {
                this.getLog().warn((Object)("CacheTest.timeoutsHelper() skipping checkCache(f=1000) because diff=" + diff));
            }
            this.assertInCache(q1, eStatus ? Boolean.TRUE : Boolean.FALSE);
            this.assertInCache(q2, Boolean.FALSE);
            currentTime = new Date();
            diff = currentTime.getTime() - startTime.getTime();
            diff2 = currentTime.getTime() - persistTime.getTime();
            diff = Math.max(diff, diff2);
            sleep = 6000L - diff;
            if (sleep > 0L) {
                this.getLog().info((Object)("CacheTest.timeoutsHelper() testing g to be dropped by waiting sleep=" + sleep));
                Thread.currentThread();
                Thread.sleep(sleep);
                Thread.yield();
            }
            this.checkCache(cache, ids, new boolean[]{eStatus, false, false, false});
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    public void testQueryTimeouts() throws Exception {
        this.queryTimeoutsHelper(this.factory);
        this.queryTimeoutsHelper(this.timeoutFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryTimeoutsHelper(OpenJPAEntityManagerFactory factory) throws Exception {
        OpenJPAEntityManager em = factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            Date startTime = new Date();
            CacheObjectE e = new CacheObjectE("e");
            em.persist((Object)e);
            CacheObjectF f = new CacheObjectF("f");
            em.persist((Object)f);
            this.endTx((EntityManager)em);
            Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
            Query q1 = broker.newQuery("javax.persistence.JPQL", (Object)"SELECT a FROM CacheObjectE a");
            q1.setCandidateExtent(broker.newExtent(CacheObjectE.class, false));
            this.iterate((Collection)q1.execute());
            this.assertInCache(q1, Boolean.TRUE);
            Query q2 = broker.newQuery("javax.persistence.JPQL", (Object)"SELECT a FROM CacheObjectF a");
            this.iterate((Collection)q2.execute());
            this.assertInCache(q2, Boolean.TRUE);
            boolean eTimedOut = ((OpenJPAEntityManagerFactorySPI)factory).getConfiguration().getDataCacheTimeout() > 0;
            Date currentTime = new Date();
            long diff = currentTime.getTime() - startTime.getTime();
            long sleep = 2000L - diff;
            if (sleep > 0L) {
                this.getLog().trace((Object)("CacheTest.queryTimeoutsHelper() testing f to be dropped by waiting sleep=" + sleep));
                Thread.currentThread();
                Thread.sleep(sleep);
                Thread.yield();
            }
            this.assertInCache(q1, eTimedOut ? Boolean.FALSE : Boolean.TRUE);
            this.assertInCache(q2, Boolean.FALSE);
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryImplicitEvictions() throws Exception {
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            int attempts;
            RuntimeTest1[] helperObjs = new RuntimeTest1[]{new RuntimeTest1(), new RuntimeTest1(), new RuntimeTest1(), new RuntimeTest1(), new RuntimeTest1()};
            this.startTx((EntityManager)em);
            em.persist((Object)helperObjs[0]);
            em.persist((Object)helperObjs[1]);
            em.persist((Object)helperObjs[2]);
            em.persist((Object)helperObjs[3]);
            em.persist((Object)helperObjs[4]);
            this.endTx((EntityManager)em);
            DataCache cache = this.cacheManager(this.factory).getDataCache("default", false);
            if (!this.isOpenJPACache(cache)) {
                this.bug(627, "Tangosol cache impl needs modernization");
                return;
            }
            if (cache instanceof DelegatingDataCache) {
                cache = ((DelegatingDataCache)cache).getInnermostDelegate();
            }
            if (cache instanceof ConcurrentDataCache) {
                CacheMap map = ((ConcurrentDataCache)cache).getCacheMap();
                map.setCacheSize(3);
                map.setSoftReferenceSize(0);
            }
            this.startTx((EntityManager)em);
            CacheObjectH h = new CacheObjectH("h");
            em.persist((Object)h);
            CacheObjectJ j = new CacheObjectJ("j", h);
            em.persist((Object)j);
            this.endTx((EntityManager)em);
            Object hoid = em.getObjectId((Object)h);
            Object joid = em.getObjectId((Object)j);
            Id hoidwithclass = new Id(CacheObjectH.class, hoid.toString());
            Id joidwithclass = new Id(CacheObjectJ.class, joid.toString());
            this.endEm((EntityManager)em);
            for (attempts = 0; attempts < 100 && !cache.contains((Object)joidwithclass); ++attempts) {
                em = this.factory.createEntityManager();
                if (!cache.contains((Object)hoidwithclass)) {
                    em.find(CacheObjectH.class, hoid);
                }
                if (!cache.contains((Object)joidwithclass)) {
                    em.find(CacheObjectJ.class, joid);
                }
                this.endEm((EntityManager)em);
            }
            CacheTest.assertTrue((String)"Could not get queried objects into cache", (attempts < 100 ? 1 : 0) != 0);
            em = this.factory.createEntityManager();
            Broker broker = JPAFacadeHelper.toBroker((EntityManager)em);
            Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectJ.class.getSimpleName() + " a where a.str = 'h'"));
            this.iterate((Collection)q.execute());
            this.assertInCache(q, Boolean.TRUE);
            this.endEm((EntityManager)em);
            for (attempts = 0; attempts < 100 && cache.contains((Object)joidwithclass); ++attempts) {
                em = this.factory.createEntityManager();
                for (int i = 0; i < 5; ++i) {
                    em.find(RuntimeTest1.class, em.getObjectId((Object)helperObjs[i]));
                }
                this.endEm((EntityManager)em);
            }
            CacheTest.assertTrue((String)"Could not kick queried objects out of cache", (attempts < 100 ? 1 : 0) != 0);
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllegedConcurrentModificationException() throws Exception {
        CacheObjectE e;
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManager)em, CacheObjectE.class);
            if (!this.isOpenJPACache(meta.getDataCache())) {
                return;
            }
            this.startTx((EntityManager)em);
            e = new CacheObjectE("e");
            em.persist((Object)e);
            this.endTx((EntityManager)em);
        }
        finally {
            this.endEm((EntityManager)em);
        }
        em = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            OpenJPAQuery q = em.createQuery("select a FROM " + CacheObjectE.class.getSimpleName() + " a where a.str = 'e'");
            e = (CacheObjectE)q.getResultList().iterator().next();
            e.setStr("e2");
            e.setStr("e3");
            this.endTx((EntityManager)em);
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    private boolean isOpenJPACache(DataCache cache) {
        if (cache instanceof DelegatingDataCache) {
            cache = ((DelegatingDataCache)cache).getInnermostDelegate();
        }
        return cache instanceof ConcurrentDataCache;
    }

    private void checkCache(DataCache cache, Object[] ids, boolean[] stati) {
        CacheTestHelper.checkCache(this, cache, ids, stati);
    }

    private void assertInCache(Query q, Boolean inCache) {
        CacheTestHelper.assertInCache(this, q, inCache);
    }

    private void assertInCache(Query q, Boolean inCache, Object[] args) {
        CacheTestHelper.assertInCache(this, q, inCache, args);
    }

    private void iterate(Collection c) {
        CacheTestHelper.iterate(c);
    }

    public void testInterface() throws Exception {
        OpenJPAEntityManager newEm = this.factory.createEntityManager();
        this.startTx((EntityManager)newEm);
        CacheObjectA a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
        CacheObjectC c = new CacheObjectC("blah");
        a.setRelatedInterface(c);
        this.endTx((EntityManager)newEm);
        Object cId = newEm.getObjectId((Object)c);
        this.endEm((EntityManager)newEm);
        newEm = this.factory.createEntityManager();
        a = (CacheObjectA)newEm.find(CacheObjectA.class, this.oid);
        CacheObjectInterface c2 = a.getRelatedInterface();
        CacheTest.assertNotNull((Object)c2);
        CacheTest.assertEquals((Object)cId, (Object)newEm.getObjectId((Object)c2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueriesOnCollectionsDontUseCache() {
        List c;
        OpenJPAQuery q;
        OpenJPAEntityManager em = this.factory.createEntityManager();
        try {
            this.startTx((EntityManager)em);
            CacheObjectE e = new CacheObjectE("e");
            em.persist((Object)e);
            this.endTx((EntityManager)em);
        }
        finally {
            this.endEm((EntityManager)em);
        }
        em = this.factory.createEntityManager();
        try {
            q = em.createQuery("select a FROM " + CacheObjectE.class.getSimpleName() + " a where a.str = 'e'");
            c = new ArrayList(q.getResultList());
            CacheTest.assertEquals((int)1, (int)c.size());
            q.closeAll();
        }
        finally {
            this.endEm((EntityManager)em);
        }
        try {
            em = this.factory.createEntityManager();
            q = em.createQuery("select a FROM " + CacheObjectE.class.getSimpleName() + " a where a.str = 'e'");
            q.setCandidateCollection(new ArrayList(0));
            c = q.getResultList();
            CacheTest.assertEquals((int)0, (int)c.size());
            q.closeAll();
        }
        finally {
            this.endEm((EntityManager)em);
        }
    }

    public void testDFGFieldsLoaded1() {
        this.dfgFieldsLoadedHelper(false);
    }

    public void testDFGFieldsLoaded2() {
        this.dfgFieldsLoadedHelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dfgFieldsLoadedHelper(boolean related) {
        OpenJPAEntityManager em = this.factory.createEntityManager();
        this.startTx((EntityManager)em);
        try {
            OpenJPAQuery q = em.createQuery("select a FROM " + CacheObjectA.class.getSimpleName() + " a where a.name = :pName").setParameter("pName", (Object)ORIG_NAME);
            ArrayList c = new ArrayList(q.getResultList());
            CacheTest.assertEquals((int)1, (int)c.size());
            CacheObjectA a = (CacheObjectA)c.iterator().next();
            if (related) {
                a.getRelatedArray();
            }
            em.detach((Object)a);
            CacheTest.assertEquals((String)ORIG_NAME, (String)a.getName());
            q.closeAll();
        }
        finally {
            this.rollbackTx((EntityManager)em);
            this.endEm((EntityManager)em);
        }
    }

    public void testCachedQueryClosureReleasesResources() {
        OpenJPAEntityManager initEm = this.factory.createEntityManager();
        this.startTx((EntityManager)initEm);
        CacheObjectE e = new CacheObjectE("e");
        initEm.persist((Object)e);
        this.endTx((EntityManager)initEm);
        this.endEm((EntityManager)initEm);
        Broker broker = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.factory).newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectE.class.getSimpleName() + " a where a.str = 'e'"));
        Collection c = (Collection)q.execute();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            iter.next();
        }
        CacheTest.assertEquals((int)1, (int)c.size());
        this.assertInCache(q, Boolean.TRUE);
        ImplHelper.close((Object)c);
        broker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMutableSCOsAreConverted() {
        OpenJPAEntityManager em0 = this.factory.createEntityManager();
        OpenJPAEntityManager em1 = this.factory.createEntityManager();
        this.startTx((EntityManager)em0);
        CacheObjectA a = (CacheObjectA)em0.find(CacheObjectA.class, this.oid);
        Date d = new Date();
        a.setDate(d);
        this.endTx((EntityManager)em0);
        DataCache cache = this.cacheManager(this.factory).getDataCache("default", false);
        CacheTest.assertTrue((boolean)cache.contains(this.oidwithclass));
        cache.remove(this.oidwithclass);
        a = (CacheObjectA)em1.find(CacheObjectA.class, this.oid);
        CacheTest.assertTrue((boolean)cache.contains(this.oidwithclass));
        try {
            DataCachePCData data = cache.get(this.oidwithclass);
            ClassMetaData meta = ((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)this.factory)).getConfiguration().getMetaDataRepositoryInstance().getMetaData(a.getClass(), null, false);
            FieldMetaData fmd = meta.getField("date");
            d = (Date)data.getData(fmd.getIndex());
            Broker broker = JPAFacadeHelper.toBroker((EntityManager)em1);
            OpenJPAStateManager sm = broker.getStateManager((Object)a);
            CacheTest.assertTrue((sm == ((ProxyDate)a.getDate()).getOwner() ? 1 : 0) != 0);
            CacheTest.assertEquals(Date.class, d.getClass());
        }
        finally {
            this.endEm((EntityManager)em0);
            this.endEm((EntityManager)em1);
        }
    }

    public void testEmptyResultsAreCached() {
        Broker broker = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)this.factory).newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a where a.name = 'testEmptyResultsAreCached'"));
        Collection c = (Collection)q.execute();
        CacheTest.assertEquals((int)0, (int)c.size());
        this.assertInCache(q, Boolean.TRUE);
        broker.close();
    }

    private void doassertTrue(EntityManager em, String name, int age) throws Exception {
        CacheObjectA a = (CacheObjectA)em.find(CacheObjectA.class, this.oid);
        CacheTest.assertTrue((boolean)name.equals(a.getName()));
        CacheTest.assertTrue((a.getAge() == (long)age ? 1 : 0) != 0);
        this.endEm(em);
    }

    private void assertNew(CacheObjectA a) {
        CacheTest.assertTrue((boolean)NEW_NAME.equals(a.getName()));
        CacheTest.assertTrue(((long)ORIG_AGE == a.getAge() ? 1 : 0) != 0);
    }

    private void assertOld(CacheObjectA a) {
        CacheTest.assertTrue((boolean)ORIG_NAME.equals(a.getName()));
        CacheTest.assertTrue(((long)ORIG_AGE == a.getAge() ? 1 : 0) != 0);
    }

    private DataCacheManager cacheManager(OpenJPAEntityManagerFactory factory) {
        return CacheTestHelper.cacheManager(JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)factory));
    }

    private void close(EntityManager em) {
        this.rollbackTx(em);
        this.endEm(em);
    }

    private void close(Broker broker) {
        if (broker.isActive()) {
            broker.rollback();
        }
        broker.close();
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String type = args[i];
            CacheTest c = type.equals("tcp") ? new DistributedCacheTest("time test", ConcurrentDataCache.class) : (type.equals("jms") ? new DistributedCacheTest("time test", ConcurrentDataCache.class) : new TestLocalCache("time test"));
            c.setUp();
            long start = System.currentTimeMillis();
            int count = 1000;
            for (int j = 0; j < count; ++j) {
                super.doassertTrue((EntityManager)c.factory.createEntityManager(), NEW_NAME, ORIG_AGE);
            }
            System.out.println(count + " iterations in " + (System.currentTimeMillis() - start) + " millis");
            c.tearDown();
        }
    }
}

