/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Collection;
import java.util.Iterator;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestBroker;

class CacheTestHelper {
    CacheTestHelper() {
    }

    static void checkCache(AbstractTestCase tc, DataCache cache, Object[] ids, boolean[] stati) {
        for (int i = 0; i < ids.length; ++i) {
            if (stati[i]) {
                AbstractTestCase.assertTrue((String)("id " + i + " (" + ids[i] + ") was not in cache; should have been"), (boolean)cache.contains(ids[i]));
                continue;
            }
            AbstractTestCase.assertFalse((String)("id " + i + " (" + ids[i] + ") was in cache; should not have been"), (boolean)cache.contains(ids[i]));
        }
    }

    static void assertInCache(AbstractTestCase tc, Query q, Boolean inCache) {
        CacheTestHelper.assertInCache(tc, q, inCache, new Object[0]);
    }

    static void assertInCache(AbstractTestCase tc, Query query, Boolean inCache, Object[] args) {
        QueryKey qk = QueryKey.newInstance((Query)query, (Object[])args);
        Broker broker = query.getBroker();
        BrokerFactory factory = broker.getBrokerFactory();
        QueryCache qc = CacheTestHelper.cacheManager(factory).getSystemQueryCache();
        if (inCache == Boolean.FALSE && qc.get(qk) != null) {
            AbstractTestCase.fail((String)"query should not be in cache; was.");
        } else if (inCache == Boolean.TRUE || inCache == null && qc.get(qk) != null) {
            Object res;
            Object object = res = args == null ? query.execute() : query.execute(args);
            if (inCache == Boolean.TRUE && !CacheTestHelper.isCachedResult(res, inCache, query.getBroker())) {
                AbstractTestCase.fail((String)"query should be in cache; was not.");
            } else if (inCache == null && CacheTestHelper.isCachedResult(res, inCache, query.getBroker())) {
                AbstractTestCase.fail((String)"query should not be returned to user; was.");
            }
            query.closeAll();
        }
    }

    private static boolean isCachedResult(Object res, Boolean expected, Broker broker) {
        if (!(broker instanceof CacheTestBroker)) {
            throw new IllegalArgumentException("Broker was not set to be a CacheTestBroker, making it impossible to verify if query result is cached");
        }
        if (res instanceof Collection) {
            return res instanceof CacheTestBroker.CachedQueryResult;
        }
        return expected;
    }

    static void iterate(Collection c) {
        int count = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
    }

    static DataCacheManager cacheManager(BrokerFactory factory) {
        return factory.getConfiguration().getDataCacheManagerInstance();
    }
}

