/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.openjpa.datacache.ConcurrentQueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.QueryResult;

public class SerializingConcurrentQueryCache
extends ConcurrentQueryCache {
    private static final long serialVersionUID = 1L;
    public static String SERIALIZING_CONCURRENT_QUERY_CACHE = SerializingConcurrentQueryCache.class.getName();

    public QueryResult get(QueryKey key) {
        return SerializingConcurrentQueryCache.roundtrip(super.get(SerializingConcurrentQueryCache.roundtrip(key)));
    }

    public QueryResult put(QueryKey qk, QueryResult oids) {
        SerializingConcurrentQueryCache.roundtrip(qk);
        SerializingConcurrentQueryCache.roundtrip(oids);
        return SerializingConcurrentQueryCache.roundtrip(super.put(qk, oids));
    }

    private static <T> T roundtrip(T o) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(o);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
            return (T)in.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

