/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.Cache;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.CachedEntityStatistics;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestBulkUpdatesDataCacheEviction
extends SingleEMFTestCase {
    Object[] props = new Object[]{CLEAR_TABLES, CachedEntityStatistics.class, "openjpa.DataCache", "true"};
    Object[] noEvictProps = new Object[]{CLEAR_TABLES, CachedEntityStatistics.class, "openjpa.DataCache", "true(EvictOnBulkUpdate=false)"};

    @Override
    public void setUp() throws Exception {
        super.setUp(this.props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdate() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Cache cache = this.emf.getCache();
        try {
            CachedEntityStatistics e = this.createEntity((EntityManager)em);
            TestBulkUpdatesDataCacheEviction.assertTrue((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            em.clear();
            String update = "UPDATE CachedEntityStatistics s SET s.firstName = :name WHERE s.id = :id";
            String name = "name_" + System.currentTimeMillis();
            em.getTransaction().begin();
            TestBulkUpdatesDataCacheEviction.assertEquals((int)1, (int)em.createQuery(update).setParameter("name", (Object)name).setParameter("id", (Object)e.getId()).executeUpdate());
            em.getTransaction().commit();
            TestBulkUpdatesDataCacheEviction.assertFalse((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            CachedEntityStatistics postUpdate = (CachedEntityStatistics)em.find(CachedEntityStatistics.class, (Object)e.getId());
            TestBulkUpdatesDataCacheEviction.assertEquals((String)name, (String)postUpdate.getFirstName());
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Cache cache = this.emf.getCache();
        try {
            CachedEntityStatistics e = this.createEntity((EntityManager)em);
            TestBulkUpdatesDataCacheEviction.assertTrue((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            em.clear();
            String delete = "DELETE FROM CachedEntityStatistics s WHERE s.id = :id";
            em.getTransaction().begin();
            TestBulkUpdatesDataCacheEviction.assertEquals((int)1, (int)em.createQuery(delete).setParameter("id", (Object)e.getId()).executeUpdate());
            em.getTransaction().commit();
            TestBulkUpdatesDataCacheEviction.assertFalse((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            CachedEntityStatistics postUpdate = (CachedEntityStatistics)em.find(CachedEntityStatistics.class, (Object)e.getId());
            TestBulkUpdatesDataCacheEviction.assertNull((Object)postUpdate);
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateNoEvict() {
        OpenJPAEntityManagerFactorySPI emf = this.createNamedEMF(this.getPersistenceUnitName(), this.noEvictProps);
        Cache cache = emf.getCache();
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        try {
            CachedEntityStatistics e = this.createEntity((EntityManager)em);
            TestBulkUpdatesDataCacheEviction.assertTrue((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            em.clear();
            String update = "UPDATE CachedEntityStatistics s SET s.firstName = :name WHERE s.id = :id";
            String name = "name_" + System.currentTimeMillis();
            em.getTransaction().begin();
            TestBulkUpdatesDataCacheEviction.assertEquals((int)1, (int)em.createQuery(update).setParameter("name", (Object)name).setParameter("id", (Object)e.getId()).executeUpdate());
            em.getTransaction().commit();
            TestBulkUpdatesDataCacheEviction.assertTrue((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            CachedEntityStatistics postUpdate = (CachedEntityStatistics)em.find(CachedEntityStatistics.class, (Object)e.getId());
            TestBulkUpdatesDataCacheEviction.assertNotEquals(name, postUpdate.getFirstName());
        }
        finally {
            emf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteNoEvict() throws Exception {
        OpenJPAEntityManagerFactorySPI emf = this.createNamedEMF(this.getPersistenceUnitName(), this.noEvictProps);
        Cache cache = emf.getCache();
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        try {
            CachedEntityStatistics e = this.createEntity((EntityManager)em);
            TestBulkUpdatesDataCacheEviction.assertTrue((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            em.clear();
            String delete = "DELETE FROM CachedEntityStatistics s WHERE s.id = :id";
            em.getTransaction().begin();
            TestBulkUpdatesDataCacheEviction.assertEquals((int)1, (int)em.createQuery(delete).setParameter("id", (Object)e.getId()).executeUpdate());
            em.getTransaction().commit();
            TestBulkUpdatesDataCacheEviction.assertTrue((boolean)cache.contains(CachedEntityStatistics.class, (Object)e.getId()));
            em.clear();
            CachedEntityStatistics postUpdate = (CachedEntityStatistics)em.find(CachedEntityStatistics.class, (Object)e.getId());
            TestBulkUpdatesDataCacheEviction.assertNotNull((Object)postUpdate);
        }
        finally {
            em.close();
        }
    }

    private CachedEntityStatistics createEntity(EntityManager em) {
        em.getTransaction().begin();
        CachedEntityStatistics e = new CachedEntityStatistics();
        em.persist((Object)e);
        em.getTransaction().commit();
        return e;
    }
}

