/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.RollbackException;
import javax.sql.DataSource;
import org.apache.openjpa.event.RemoteCommitEvent;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.datacache.OptimisticLockInstance;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDataCacheOptimisticLockRecovery
extends SingleEMFTestCase {
    private int pk;
    private int remoteCommitEventStaleCount = 0;
    private Object staleOid;

    @Override
    public void setUp() {
        this.setUp("openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", OptimisticLockInstance.class);
        this.emf.getConfiguration().getRemoteCommitEventManager().addListener(new RemoteCommitListener(){

            public void afterCommit(RemoteCommitEvent e) {
                if (e.getPayloadType() == 3) {
                    TestDataCacheOptimisticLockRecovery.this.remoteCommitEventStaleCount++;
                    TestDataCacheOptimisticLockRecovery.this.staleOid = e.getUpdatedObjectIds().iterator().next();
                }
            }

            public void close() {
            }
        });
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OptimisticLockInstance oli = new OptimisticLockInstance("foo");
        em.persist((Object)oli);
        em.getTransaction().commit();
        this.pk = oli.getPK();
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimisticLockRecovery() throws SQLException {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OptimisticLockInstance oli = (OptimisticLockInstance)em.find(OptimisticLockInstance.class, (Object)this.pk);
        Object oid = JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)JPAFacadeHelper.getMetaData((Object)oli), (Object)OpenJPAPersistence.cast((EntityManager)em).getObjectId((Object)oli));
        int firstOpLockValue = oli.getOpLock();
        em.lock((Object)oli, LockModeType.READ);
        int secondOpLockValue = firstOpLockValue + 1;
        OpenJPAEntityManagerFactorySPI emf = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManager)em).getEntityManagerFactory();
        DataSource ds = (DataSource)emf.getConfiguration().getConnectionFactory();
        Connection c = ds.getConnection();
        c.setAutoCommit(false);
        PreparedStatement ps = c.prepareStatement("UPDATE OPTIMISTIC_LOCK_INSTANCE SET OPLOCK = ? WHERE PK = ?");
        ps.setInt(1, secondOpLockValue);
        ps.setInt(2, this.pk);
        TestDataCacheOptimisticLockRecovery.assertEquals((int)1, (int)ps.executeUpdate());
        c.commit();
        try {
            em.getTransaction().commit();
            TestDataCacheOptimisticLockRecovery.fail((String)"tx should have failed due to out-of-band oplock change");
        }
        catch (RollbackException re) {
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        TestDataCacheOptimisticLockRecovery.assertEquals((int)1, (int)this.remoteCommitEventStaleCount);
        TestDataCacheOptimisticLockRecovery.assertEquals((Object)oid, (Object)this.staleOid);
        em.close();
        em = this.emf.createEntityManager();
        oli = (OptimisticLockInstance)em.find(OptimisticLockInstance.class, (Object)this.pk);
        TestDataCacheOptimisticLockRecovery.assertEquals((String)"data cache is not being cleared when oplock violations occur", (int)secondOpLockValue, (int)oli.getOpLock());
        em.getTransaction().begin();
        em.lock((Object)oli, LockModeType.READ);
        try {
            em.getTransaction().commit();
        }
        catch (RollbackException e) {
            throw e;
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
    }

    public void testExpectedOptimisticLockException() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.lock(em.find(OptimisticLockInstance.class, (Object)this.pk), LockModeType.READ);
        OpenJPAEntityManagerSPI em2 = this.emf.createEntityManager();
        em2.getTransaction().begin();
        em2.lock(em2.find(OptimisticLockInstance.class, (Object)this.pk), LockModeType.WRITE);
        em2.getTransaction().commit();
        em2.close();
        try {
            em.getTransaction().commit();
            TestDataCacheOptimisticLockRecovery.fail((String)"write lock in em2 should trigger an optimistic lock failure");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        em.close();
    }
}

