/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestBroker;
import org.apache.openjpa.persistence.datacache.common.apps.FlushDataCacheObject;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestFlushDataCache
extends AbstractTestCase {
    public TestFlushDataCache(String str) {
        super(str, "datacachecactusapp");
    }

    public void setUp() {
        this.deleteAll(FlushDataCacheObject.class);
    }

    public void testQueryFlushPlusDataCache() {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.FlushBeforeQueries", "true");
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        try {
            Class.forName("org.apache.openjpa.persistence.datacache.CacheTestBroker", true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            // empty catch block
        }
        EntityManager em = emf.createEntityManager();
        this.startTx(em);
        FlushDataCacheObject o = new FlushDataCacheObject();
        o.setString("foo");
        em.persist((Object)o);
        this.endTx(em);
        this.endEm(em);
        em = emf.createEntityManager();
        this.startTx(em);
        List c = em.createQuery("select a FROM " + FlushDataCacheObject.class.getSimpleName() + " a where a.string = 'foo'").getResultList();
        TestFlushDataCache.assertEquals((int)1, (int)c.size());
        em.remove(c.iterator().next());
        c = em.createQuery("select a FROM " + FlushDataCacheObject.class.getSimpleName() + " a where a.string = 'foo'").getResultList();
        TestFlushDataCache.assertEquals((int)0, (int)c.size());
        this.endTx(em);
        this.endEm(em);
    }

    public void testEmptyCommit() {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.FlushBeforeQueries", "true");
        propsMap.put("openjpa.BrokerImpl", CacheTestBroker.class.getName());
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        EntityManager em = emf.createEntityManager();
        this.startTx(em);
        this.endTx(em);
        this.endEm(em);
    }
}

