/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.TypedQuery;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.entities.ContactInfo;
import org.apache.openjpa.persistence.datacache.entities.Person;
import org.apache.openjpa.persistence.datacache.entities.Phone;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestJPAEmbeddableDataCache
extends SingleEMFTestCase {
    Object[] params = new Object[]{Person.class, ContactInfo.class, Phone.class, "openjpa.DataCache", "true", CLEAR_TABLES};

    @Override
    protected void setUp(Object ... props) {
        super.setUp(this.params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            Person p = this.loadPerson();
            String sql = "SELECT p.ci FROM Person p WHERE p.id = :id";
            TypedQuery query = em.createQuery(sql, ContactInfo.class);
            query.setParameter("id", (Object)p.getId());
            query.getSingleResult();
            em.clear();
            query = em.createQuery(sql, ContactInfo.class);
            query.setParameter("id", (Object)p.getId());
            query.getSingleResult();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Person loadPerson() {
        Person p = null;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            p = new Person();
            ContactInfo ci = new ContactInfo();
            Phone phone = new Phone();
            p.setCi(ci);
            ci.setPhone(phone);
            phone.setOwner(p);
            p.setFirst("first");
            p.setMiddle("middle");
            p.setLast("last");
            phone.setNumber("507-555-1076");
            phone.setSomethingElse("something-" + System.currentTimeMillis());
            ci.setCity("cittttY");
            ci.setStreet("street-" + System.currentTimeMillis());
            ci.setZip("90210");
            em.getTransaction().begin();
            em.persist((Object)p);
            em.persist((Object)phone);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        return p;
    }
}

