/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestBroker;
import org.apache.openjpa.persistence.datacache.CacheTestHelper;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectA;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectAChild1;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestJPQL2Queries
extends AbstractTestCase {
    private BrokerFactory _factory;

    public TestJPQL2Queries(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        this.deleteAll(CacheObjectA.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.BrokerImpl", CacheTestBroker.class.getName());
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        this._factory = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf);
        Broker broker = this._factory.newBroker();
        broker.begin();
        for (int i = 0; i < 50; ++i) {
            broker.persist((Object)new CacheObjectAChild1("", "JPQL2Queries", i), null);
        }
        broker.commit();
        broker.close();
        CacheTestHelper.cacheManager(this._factory).getSystemQueryCache().clear();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this._factory.close();
            this._factory = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testUpperRange() {
        this.rangeTestHelper(0, 10);
    }

    public void testLowerRange() {
        this.rangeTestHelper(5, 50);
    }

    public void testBothRanges() {
        this.rangeTestHelper(20, 28);
    }

    private void rangeTestHelper(int start, int end) {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        q.setRange((long)start, (long)end);
        CacheTestHelper.assertInCache(this, q, Boolean.FALSE);
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        TestJPQL2Queries.assertEquals((int)(end - start), (int)c.size());
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        broker.close();
        broker = this._factory.newBroker();
        q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        q.setRange((long)start, (long)end);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        TestJPQL2Queries.assertEquals((int)(end - start), (int)c.size());
        q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        q.setRange((long)start, (long)(end - 1));
        CacheTestHelper.assertInCache(this, q, Boolean.FALSE);
        c = (Collection)q.execute();
        TestJPQL2Queries.assertEquals((int)(end - start - 1), (int)c.size());
        broker.close();
    }

    public void testResultClassIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        q.setResultType(Object.class);
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
    }
}

