/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestBroker;
import org.apache.openjpa.persistence.datacache.CacheTestHelper;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectA;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectAChild1;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectB;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectWithExternalizedFields;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestJPQL2ResultsAndResultClasses
extends AbstractTestCase {
    private BrokerFactory _factory;

    public TestJPQL2ResultsAndResultClasses(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        this.deleteAll(CacheObjectA.class);
        this.deleteAll(CacheObjectWithExternalizedFields.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.BrokerImpl", CacheTestBroker.class.getName());
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        this._factory = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf);
        Broker broker = this._factory.newBroker();
        try {
            broker.begin();
        }
        catch (Exception e) {
            System.out.println("Exception in TestJPQL2ResultsAndResultClasses setup : \n" + this.getStackTrace(e));
        }
        int j = 0;
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                ++j;
            }
            CacheObjectAChild1 o = new CacheObjectAChild1("", "results-" + j, i);
            broker.persist((Object)o, null);
            o.setDate(new Date());
            o.setDateArray(new Date[]{new Date(10L), new Date(20L)});
            if (i >= 5) continue;
            o.setRelatedB(new CacheObjectB());
        }
        CacheObjectWithExternalizedFields o = new CacheObjectWithExternalizedFields();
        broker.persist((Object)o, null);
        o.setCls(Broker.class);
        broker.commit();
        broker.close();
        CacheTestHelper.cacheManager(this._factory).getSystemQueryCache().clear();
    }

    @Override
    public void tearDown() throws Exception {
        this._factory.close();
        this._factory = null;
        super.tearDown();
    }

    public void testAggregateResultIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select max(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        Object o = q.execute();
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, o.getClass());
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        o = q.execute();
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, o.getClass());
    }

    public void testAggregateNonUniqueResultIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select max(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        q.setUnique(false);
        List res = (List)q.execute();
        TestJPQL2ResultsAndResultClasses.assertEquals((int)1, (int)res.size());
        Object o = res.get(0);
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, o.getClass());
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        res = (List)q.execute();
        TestJPQL2ResultsAndResultClasses.assertEquals((int)1, (int)res.size());
        o = res.get(0);
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, o.getClass());
    }

    public void testProjectionResultIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.age FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object o = c.iterator().next();
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, o.getClass());
    }

    public void testProjectionOfThisIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object o = c.iterator().next();
        TestJPQL2ResultsAndResultClasses.assertEquals(CacheObjectAChild1.class, o.getClass());
        TestJPQL2ResultsAndResultClasses.assertNotNull((Object)broker.getObjectId(o));
    }

    public void testProjectionResultWithThisIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name,a FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object[] result = (Object[])c.iterator().next();
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)result.length);
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, result[0].getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals(CacheObjectAChild1.class, result[1].getClass());
        TestJPQL2ResultsAndResultClasses.assertNotNull((Object)broker.getObjectId(result[1]));
    }

    public void testNullProjectionValues() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.locale FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        TestJPQL2ResultsAndResultClasses.assertNull(c.iterator().next());
    }

    public void testNullAndNotNullProjectionValues() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name,a.locale FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object[] result = (Object[])c.iterator().next();
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)result.length);
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, result[0].getClass());
        TestJPQL2ResultsAndResultClasses.assertNull((Object)result[1]);
    }

    public void XXXtestNullAggregateValues() {
    }

    public void testMultipleAggregateResultIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select max(a.age), avg(a.age), count(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        Object o = q.execute();
        TestJPQL2ResultsAndResultClasses.assertEquals(Object[].class, o.getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals((int)3, (int)((Object[])o).length);
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, ((Object[])o)[0].getClass());
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        o = q.execute();
        TestJPQL2ResultsAndResultClasses.assertEquals(Object[].class, o.getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals((int)3, (int)((Object[])o).length);
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, ((Object[])o)[0].getClass());
    }

    public void testFieldUsedTwice() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.age, avg(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a  group by a.age"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
    }

    public void testAggregateAndProjection() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name, avg(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a  group by a.name"));
        List l = (List)q.execute();
        CacheTestHelper.iterate(l);
        TestJPQL2ResultsAndResultClasses.assertEquals(Object[].class, l.get(0).getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)((Object[])l.get(0)).length);
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, ((Object[])l.get(0))[0].getClass());
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        l = (List)q.execute();
        TestJPQL2ResultsAndResultClasses.assertEquals(Object[].class, l.get(0).getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)((Object[])l.get(0)).length);
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, ((Object[])l.get(0))[0].getClass());
    }

    public void testResultClassIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("Select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        q.setResultType(Object.class);
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
    }

    public void testGroupingIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select max(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a  group by a.name"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object o = c.iterator().next();
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, o.getClass());
    }

    public void testAggregateProjectionGroupingIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name, max(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a  group by a.name"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object[] result = (Object[])c.iterator().next();
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)result.length);
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, result[0].getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, result[1].getClass());
    }

    public void testUniqueResultsAreCachedAndConsistent() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a FROM " + CacheObjectAChild1.class.getSimpleName() + " a  where a.age =1"));
        q.setUnique(true);
        CacheObjectAChild1 a = (CacheObjectAChild1)q.execute();
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        CacheObjectAChild1 a2 = (CacheObjectAChild1)q.execute();
        TestJPQL2ResultsAndResultClasses.assertTrue((a == a2 ? 1 : 0) != 0);
    }

    public void testMutableProjectionFieldsAreCopied() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.date FROM " + CacheObjectAChild1.class.getSimpleName() + " a  where a.age=1"));
        q.setUnique(true);
        Date d0 = (Date)q.execute();
        Date d1 = (Date)q.execute();
        TestJPQL2ResultsAndResultClasses.assertNotSame((Object)d0, (Object)d1);
        Date d2 = (Date)q.execute();
        TestJPQL2ResultsAndResultClasses.assertNotSame((Object)d1, (Object)d2);
    }

    public void testArrayProjectionFieldsAreNotCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.dateArray FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        try {
            q.execute();
            TestJPQL2ResultsAndResultClasses.fail((String)"Allowed array projection query.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCollectionProjectionFieldsAreNotCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.stringColl FROM " + CacheObjectAChild1.class.getSimpleName() + " a"));
        try {
            q.execute();
            TestJPQL2ResultsAndResultClasses.fail((String)"Allowed array projection query.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testExternalizedSingleValueFieldIsNotCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.cls FROM " + CacheObjectWithExternalizedFields.class.getSimpleName() + " a"));
        q.setUnique(true);
        Object o = q.execute();
        CacheTestHelper.assertInCache(this, q, Boolean.FALSE);
    }

    public void testMutatedQueryReturnsNewResults() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.name, max(a.age) FROM " + CacheObjectAChild1.class.getSimpleName() + " a group by a.name"));
        List l = (List)q.execute();
        CacheTestHelper.iterate(l);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        l = (List)q.execute();
        Object[] result = (Object[])l.get(0);
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)result.length);
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, result[0].getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, result[1].getClass());
        q.setQuery((Object)("select max(a.age),a.name FROM " + CacheObjectAChild1.class.getSimpleName() + " a group by a.name"));
        CacheTestHelper.assertInCache(this, q, Boolean.FALSE);
        l = (List)q.execute();
        result = (Object[])l.get(0);
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)result.length);
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, result[0].getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, result[1].getClass());
        CacheTestHelper.iterate(l);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        l = (List)q.execute();
        result = (Object[])l.get(0);
        TestJPQL2ResultsAndResultClasses.assertEquals((int)2, (int)result.length);
        TestJPQL2ResultsAndResultClasses.assertEquals(Long.class, result[0].getClass());
        TestJPQL2ResultsAndResultClasses.assertEquals(String.class, result[1].getClass());
    }

    public void XXXtestExternalizedContainerFieldIsExternalized() {
    }

    public void XXXtestSerializedSingleValueFieldIsSerialized() {
    }

    public void XXXtestSerializedContainerFieldIsSerialized() {
    }

    public void XXXtestCustomMappedSingleValueFieldIsHandled() {
    }

    public void XXXtestCustomMappedContainerFieldIsHandled() {
    }

    private static int deleteAll(Broker broker, Class clazz, boolean subclasses) {
        boolean useDeleteByQuery = false;
        Extent extent = broker.newExtent(clazz, subclasses);
        List list = extent.list();
        int size = list.size();
        broker.deleteAll((Collection)list, null);
        return size;
    }
}

