/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestBroker;
import org.apache.openjpa.persistence.datacache.CacheTestHelper;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectAChild1;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectE;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectJ;
import org.apache.openjpa.persistence.datacache.common.apps.SelfReferencingCacheTestObject;
import org.apache.openjpa.persistence.test.AllowFailure;
import org.apache.openjpa.util.UserException;

@AllowFailure(message="surefire excluded")
public class TestJPQLRelationProjections
extends AbstractTestCase {
    private BrokerFactory _factory;

    public TestJPQLRelationProjections(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        this.deleteAll(CacheObjectJ.class);
        this.deleteAll(CacheObjectE.class);
        this.deleteAll(SelfReferencingCacheTestObject.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.BrokerImpl", CacheTestBroker.class.getName());
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        this._factory = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf);
        Broker broker = this._factory.newBroker();
        try {
            broker.begin();
        }
        catch (Exception e) {
            TestJPQLRelationProjections.fail((String)("Set up failed due to exception : \n" + this.getStackTrace(e)));
        }
        int j = 0;
        for (int i = 0; i < 6; ++i) {
            CacheObjectE e = i < 3 ? new CacheObjectE(i + "") : null;
            if (i % 2 == 0) {
                ++j;
            }
            broker.persist((Object)new CacheObjectJ("projections-" + j, e), null);
        }
        broker.persist((Object)new SelfReferencingCacheTestObject("foo", new SelfReferencingCacheTestObject("bar", null)), null);
        broker.commit();
        broker.close();
        CacheTestHelper.cacheManager(this._factory).getSystemQueryCache().clear();
    }

    @Override
    public void tearDown() throws Exception {
        this._factory.close();
        this._factory = null;
        super.tearDown();
    }

    public void testNullRelatedPCIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.e FROM " + CacheObjectJ.class.getSimpleName() + " a where a.e is null"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        TestJPQLRelationProjections.assertNull(c.iterator().next());
    }

    public void testNullRelatedPCAndProjectionIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.str,a.e FROM " + CacheObjectJ.class.getSimpleName() + " a where a.e is null"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object[] result = (Object[])c.iterator().next();
        TestJPQLRelationProjections.assertEquals((int)2, (int)result.length);
        TestJPQLRelationProjections.assertEquals(String.class, result[0].getClass());
        TestJPQLRelationProjections.assertNull((Object)result[1]);
    }

    public void testNonNullRelatedPCIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.e FROM " + CacheObjectJ.class.getSimpleName() + " a where a.e  is not null"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        TestJPQLRelationProjections.assertEquals(CacheObjectE.class, c.iterator().next().getClass());
    }

    public void testNonNullRelatedPCAndProjectionIsCached() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.str,a.e FROM " + CacheObjectJ.class.getSimpleName() + " a where a.e is not null"));
        Collection c = (Collection)q.execute();
        CacheTestHelper.iterate(c);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        c = (Collection)q.execute();
        Object[] result = (Object[])c.iterator().next();
        TestJPQLRelationProjections.assertEquals((int)2, (int)result.length);
        TestJPQLRelationProjections.assertEquals(String.class, result[0].getClass());
        TestJPQLRelationProjections.assertEquals(CacheObjectE.class, result[1].getClass());
    }

    public void testEmbeddedFields() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select embedded FROM " + SelfReferencingCacheTestObject.class.getSimpleName() + " a where a.str='foo'"));
        List l = null;
        try {
            l = (List)q.execute();
            TestJPQLRelationProjections.assertEquals(CacheObjectAChild1.class, l.get(0).getClass());
        }
        catch (UserException ue) {
            ue.printStackTrace();
            return;
        }
        CacheTestHelper.iterate(l);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        l = (List)q.execute();
        TestJPQLRelationProjections.assertEquals(CacheObjectAChild1.class, l.get(0).getClass());
    }

    public void testNonNullRelationOfSameTypeAsCandidate() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.o FROM " + SelfReferencingCacheTestObject.class.getSimpleName() + " a where a.o IS NOT NULL"));
        List l = (List)q.execute();
        TestJPQLRelationProjections.assertEquals(SelfReferencingCacheTestObject.class, l.get(0).getClass());
        TestJPQLRelationProjections.assertEquals((String)"bar", (String)((SelfReferencingCacheTestObject)l.get(0)).getStr());
        CacheTestHelper.iterate(l);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        l = (List)q.execute();
        TestJPQLRelationProjections.assertEquals(SelfReferencingCacheTestObject.class, l.get(0).getClass());
        TestJPQLRelationProjections.assertEquals((String)"bar", (String)((SelfReferencingCacheTestObject)l.get(0)).getStr());
    }

    public void testNullRelationOfSameTypeAsCandidate() {
        Broker broker = this._factory.newBroker();
        Query q = broker.newQuery("javax.persistence.JPQL", (Object)("select a.o FROM " + SelfReferencingCacheTestObject.class.getSimpleName() + " a where a.o IS NULL"));
        List l = (List)q.execute();
        TestJPQLRelationProjections.assertNull(l.get(0));
        CacheTestHelper.iterate(l);
        CacheTestHelper.assertInCache(this, q, Boolean.TRUE);
        l = (List)q.execute();
        TestJPQLRelationProjections.assertNull(l.get(0));
    }
}

