/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.EntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.datacache.common.apps.M2MEntityE;
import org.apache.openjpa.persistence.datacache.common.apps.M2MEntityF;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestM2MInDataCache
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        this.setUp("openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", M2MEntityE.class, M2MEntityF.class, CLEAR_TABLES);
    }

    public void populate(EntityManager em) {
        em.getTransaction().begin();
        M2MEntityE e1 = new M2MEntityE();
        e1.setId(1);
        e1.setName("ABC");
        em.persist((Object)e1);
        M2MEntityE e2 = new M2MEntityE();
        e2.setId(2);
        e2.setName("DEF");
        em.persist((Object)e2);
        M2MEntityF f1 = new M2MEntityF();
        f1.setId(10);
        em.persist((Object)f1);
        M2MEntityF f2 = new M2MEntityF();
        f2.setId(20);
        em.persist((Object)f2);
        e1.getEntityF().put(f1.getId(), f1);
        e1.getEntityF().put(f2.getId(), f2);
        e2.getEntityF().put(f1.getId(), f1);
        e2.getEntityF().put(f2.getId(), f2);
        f1.getEntityE().put(e1.getName(), e1);
        f1.getEntityE().put(e2.getName(), e2);
        f2.getEntityE().put(e1.getName(), e1);
        f2.getEntityE().put(e2.getName(), e2);
        em.getTransaction().commit();
    }

    public void validateGraph(M2MEntityE e1, M2MEntityE e2, M2MEntityF f1, M2MEntityF f2) {
        TestM2MInDataCache.assertNotNull((Object)e1);
        TestM2MInDataCache.assertNotNull((Object)e2);
        TestM2MInDataCache.assertNotNull((Object)f1);
        TestM2MInDataCache.assertNotNull((Object)f2);
        TestM2MInDataCache.assertEquals((Object)f1, (Object)e1.getEntityF().get(f1.getId()));
        TestM2MInDataCache.assertEquals((Object)f2, (Object)e1.getEntityF().get(f2.getId()));
        TestM2MInDataCache.assertEquals((Object)f1, (Object)e2.getEntityF().get(f1.getId()));
        TestM2MInDataCache.assertEquals((Object)f2, (Object)e2.getEntityF().get(f2.getId()));
        TestM2MInDataCache.assertEquals((Object)e1, (Object)f1.getEntityE().get(e1.getName()));
        TestM2MInDataCache.assertEquals((Object)e2, (Object)f1.getEntityE().get(e2.getName()));
        TestM2MInDataCache.assertEquals((Object)e1, (Object)f2.getEntityE().get(e1.getName()));
        TestM2MInDataCache.assertEquals((Object)e2, (Object)f2.getEntityE().get(e2.getName()));
    }

    public void testM2MDataCache() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.populate((EntityManager)em);
        em.close();
        em = this.emf.createEntityManager();
        M2MEntityE e1a = (M2MEntityE)em.find(M2MEntityE.class, (Object)1);
        TestM2MInDataCache.assertNotNull(e1a.getEntityF());
        M2MEntityE e2a = (M2MEntityE)em.find(M2MEntityE.class, (Object)2);
        TestM2MInDataCache.assertNotNull(e2a.getEntityF());
        M2MEntityF f1a = (M2MEntityF)em.find(M2MEntityF.class, (Object)10);
        TestM2MInDataCache.assertNotNull(f1a.getEntityE());
        M2MEntityF f2a = (M2MEntityF)em.find(M2MEntityF.class, (Object)20);
        TestM2MInDataCache.assertNotNull(f2a.getEntityE());
        em.close();
    }

    public void testEagerFetch() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.populate((EntityManager)em);
        em.close();
        em = this.emf.createEntityManager();
        OpenJPAEntityManager ojEm = OpenJPAPersistence.cast((EntityManager)em);
        ojEm.getFetchPlan().addField(M2MEntityE.class, "entityf");
        ojEm.getFetchPlan().addField(M2MEntityF.class, "entitye");
        M2MEntityE e1 = (M2MEntityE)em.find(M2MEntityE.class, (Object)1);
        M2MEntityE e2 = (M2MEntityE)em.find(M2MEntityE.class, (Object)2);
        M2MEntityF f1 = (M2MEntityF)em.find(M2MEntityF.class, (Object)10);
        M2MEntityF f2 = (M2MEntityF)em.find(M2MEntityF.class, (Object)20);
        this.validateGraph(e1, e2, f1, f2);
    }
}

