/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.datacache.OrderedOneManyChild;
import org.apache.openjpa.persistence.datacache.OrderedOneManyParent;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestOrderbyInDataCache
extends SingleEMFTestCase {
    private long pid;

    @Override
    public void setUp() {
        this.setUp("openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm", OrderedOneManyParent.class, OrderedOneManyChild.class, CLEAR_TABLES);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OrderedOneManyParent prt = new OrderedOneManyParent();
        prt.setName("Maria");
        em.persist((Object)prt);
        for (int i = 4; i > 1; --i) {
            OrderedOneManyChild child = new OrderedOneManyChild();
            child.setId(i);
            child.setName("child" + i);
            child.setParent(prt);
            prt.getChildren().add(child);
            em.persist((Object)child);
        }
        em.getTransaction().commit();
        this.pid = prt.getId();
        em.close();
    }

    public void testGetChildList() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        OrderedOneManyParent prt = (OrderedOneManyParent)em.find(OrderedOneManyParent.class, (Object)this.pid);
        TestOrderbyInDataCache.assertEquals((int)3, (int)prt.getChildren().size());
        for (int i = 1; i < 4; ++i) {
            TestOrderbyInDataCache.assertEquals((String)("child" + (i + 1)), (String)prt.getChildren().get(i - 1).getName());
        }
        em.close();
    }

    public void testInsertChild() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OrderedOneManyParent prt = (OrderedOneManyParent)em.find(OrderedOneManyParent.class, (Object)this.pid);
        OrderedOneManyChild child = new OrderedOneManyChild();
        child.setId(1L);
        child.setName("child1");
        child.setParent(prt);
        prt.getChildren().add(child);
        em.persist((Object)child);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        prt = (OrderedOneManyParent)em.find(OrderedOneManyParent.class, (Object)this.pid);
        TestOrderbyInDataCache.assertEquals((int)4, (int)prt.getChildren().size());
        for (int i = 1; i < 5; ++i) {
            TestOrderbyInDataCache.assertEquals((String)("child" + i), (String)prt.getChildren().get(i - 1).getName());
        }
        em.close();
    }

    public void testUpdateChildName() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        OrderedOneManyChild child = (OrderedOneManyChild)em.find(OrderedOneManyChild.class, (Object)4);
        child.setName("child1");
        em.persist((Object)child);
        em.getTransaction().commit();
        OrderedOneManyParent prt = (OrderedOneManyParent)em.find(OrderedOneManyParent.class, (Object)this.pid);
        TestOrderbyInDataCache.assertEquals((int)3, (int)prt.getChildren().size());
        for (int i = 1; i < 4; ++i) {
            TestOrderbyInDataCache.assertEquals((String)("child" + i), (String)prt.getChildren().get(i - 1).getName());
        }
        em.close();
    }
}

