/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.datacache.ConcurrentQueryCache;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CascadeChild;
import org.apache.openjpa.persistence.datacache.CascadeParent;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectE;

public class TestQueryResultSize
extends AbstractTestCase {
    private EntityManagerFactory _pmf;
    private OpenJPAEntityManager pm;

    public TestQueryResultSize(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        System.out.println("****Deleted Records " + this.deleteAll(CacheObjectE.class));
        this.deleteAll(CascadeParent.class);
        this.deleteAll(CascadeChild.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.QueryCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        this._pmf = this.getEmf(propsMap);
    }

    public void test() {
        CacheObjectE pc1 = new CacheObjectE();
        pc1.setStr("pc1");
        this.pm = (OpenJPAEntityManager)this._pmf.createEntityManager();
        this.startTx((EntityManager)this.pm);
        this.pm.persist((Object)pc1);
        this.endTx((EntityManager)this.pm);
        this.pm.getFetchPlan().setQueryResultCacheEnabled(false);
        OpenJPAQuery q = this.pm.createQuery("select a FROM " + CacheObjectE.class.getSimpleName() + " a where a.str = 'pc1'");
        List res = q.getResultList();
        TestQueryResultSize.assertEquals((int)0, (int)this.getQueryCacheSize());
        this.endEm((EntityManager)this.pm);
        System.out.println("****Deleted Records " + this.deleteAll(CacheObjectE.class));
    }

    private int getQueryCacheSize() {
        return ((ConcurrentQueryCache)OpenJPAPersistence.cast((EntityManagerFactory)this.pm.getEntityManagerFactory()).getQueryResultCache().getDelegate()).getCacheMap().size();
    }

    public void testCrossJoinQueryCache() {
        this.pm = (OpenJPAEntityManager)this._pmf.createEntityManager();
        this.startTx((EntityManager)this.pm);
        CascadeParent p = new CascadeParent();
        p.setName("p1");
        CascadeChild c = new CascadeChild();
        c.setName("p1");
        p.setChild(c);
        this.pm.persist((Object)p);
        this.endTx((EntityManager)this.pm);
        String jpql = "select p.name, c.name from CascadeParent p, CascadeChild c where p.name = c.name and p.name = 'p1'";
        OpenJPAQuery query = this.pm.createQuery(jpql);
        List result1 = query.getResultList();
        TestQueryResultSize.assertEquals((int)1, (int)result1.size());
        this.startTx((EntityManager)this.pm);
        c.setName("c1");
        this.endTx((EntityManager)this.pm);
        List result2 = query.getResultList();
        TestQueryResultSize.assertEquals((int)0, (int)result2.size());
        this.endEm((EntityManager)this.pm);
    }
}

