/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.CacheTestHelper;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectAChild1;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestResultShapes
extends AbstractTestCase {
    private Broker _broker;

    public TestResultShapes(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        this.deleteAll(CacheObjectAChild1.class);
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        OpenJPAEntityManagerFactory emf = this.getEmf(propsMap);
        BrokerFactory factory = JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)emf);
        Broker broker = factory.newBroker();
        broker.begin();
        broker.persist((Object)new CacheObjectAChild1("foo", "foo", 0), null);
        broker.persist((Object)new CacheObjectAChild1("bar", "bar", 1), null);
        broker.commit();
        broker.close();
        this._broker = factory.newBroker();
    }

    @Override
    public void tearDown() throws Exception {
        this._broker.close();
        this._broker = null;
        super.tearDown();
    }

    public void testCollectionOfSingleValuedProjection() {
        ArrayList<String> ac = new ArrayList<String>();
        ac.add("age");
        ArrayList<Class<Long>> bd = new ArrayList<Class<Long>>();
        bd.add(Long.class);
        this.arrayHelper(false, bd, ac, true);
        this.mapHelper(false, bd, ac, true);
        this.rawHelper(false, Long.class, "age", true);
    }

    public void testUniqueSingleValuedProjection() {
        ArrayList<String> ac = new ArrayList<String>();
        ac.add("age");
        ArrayList<Class<Long>> bd = new ArrayList<Class<Long>>();
        bd.add(Long.class);
        this.arrayHelper(true, bd, ac, true);
        this.mapHelper(true, bd, ac, true);
        this.rawHelper(true, Long.class, "age", true);
    }

    public void testCollectionOfMultiValuedProjection() {
        ArrayList<String> ac = new ArrayList<String>();
        ac.add("age");
        ac.add("name");
        ArrayList<Class> bd = new ArrayList<Class>();
        bd.add(Long.class);
        bd.add(String.class);
        this.arrayHelper(false, bd, ac, true);
        this.mapHelper(false, bd, ac, true);
    }

    public void testUniqueMultiValuedProjection() {
        ArrayList<String> ac = new ArrayList<String>();
        ac.add("age");
        ac.add("name");
        ArrayList<Class> bd = new ArrayList<Class>();
        bd.add(Long.class);
        bd.add(String.class);
        this.arrayHelper(true, bd, ac, true);
        this.mapHelper(true, bd, ac, true);
    }

    public void testUncachedQueryHasCorrectShape() {
        ArrayList<String> ac = new ArrayList<String>();
        ac.add("age");
        ac.add("name");
        ArrayList<Class> bd = new ArrayList<Class>();
        bd.add(Long.class);
        bd.add(String.class);
        this._broker.getFetchConfiguration().setQueryCacheEnabled(false);
        this.arrayHelper(false, bd, ac, false);
        this.mapHelper(false, bd, ac, false);
        this.rawHelper(false, Object[].class, "age, a.name", false);
    }

    private void arrayHelper(boolean unique, Collection recordClasses, Collection results, boolean inCache) {
        Iterator iter;
        Query q = this.setUpQuery(unique, results);
        q.setResultType(Object[].class);
        if (unique) {
            this.arrayResultHelper(q.execute(), recordClasses, inCache);
        } else {
            iter = ((List)q.execute()).iterator();
            while (iter.hasNext()) {
                this.arrayResultHelper(iter.next(), recordClasses, inCache);
            }
        }
        CacheTestHelper.assertInCache(this, q, new Boolean(inCache));
        if (unique) {
            this.arrayResultHelper(q.execute(), recordClasses, inCache);
        } else {
            iter = ((List)q.execute()).iterator();
            while (iter.hasNext()) {
                this.arrayResultHelper(iter.next(), recordClasses, inCache);
            }
        }
    }

    private void arrayResultHelper(Object result, Collection recordClasses, boolean inCache) {
        TestResultShapes.assertEquals(Object[].class, result.getClass());
        Object[] os = (Object[])result;
        TestResultShapes.assertEquals((int)recordClasses.size(), (int)os.length);
        for (int i = 0; i < recordClasses.size(); ++i) {
            TestResultShapes.assertEquals(((ArrayList)recordClasses).get(i), os[i].getClass());
        }
    }

    private void mapHelper(boolean unique, Collection recordClasses, Collection results, boolean inCache) {
        Iterator iter;
        Query q = this.setUpQuery(unique, results);
        System.out.println("Query String " + q.getQueryString());
        Collection coll = null;
        if (q.execute() != null && q.execute() instanceof Collection) {
            coll = (Collection)q.execute();
        }
        System.out.println("Type of q.execute is : " + q.execute().getClass());
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            System.out.println("Query result is " + it.next().getClass());
        }
        q.setResultType(HashMap.class);
        if (unique) {
            this.mapResultHelper(q.execute(), recordClasses, results, inCache);
        } else {
            iter = ((Collection)q.execute()).iterator();
            while (iter.hasNext()) {
                this.mapResultHelper(iter.next(), recordClasses, results, inCache);
            }
        }
        CacheTestHelper.assertInCache(this, q, new Boolean(inCache));
        if (unique) {
            this.mapResultHelper(q.execute(), recordClasses, results, inCache);
        } else {
            iter = ((List)q.execute()).iterator();
            while (iter.hasNext()) {
                this.mapResultHelper(iter.next(), recordClasses, results, inCache);
            }
        }
    }

    private void mapResultHelper(Object result, Collection recordClasses, Collection results, boolean inCache) {
        TestResultShapes.assertEquals(HashMap.class, result.getClass());
        HashMap m = (HashMap)result;
        TestResultShapes.assertEquals((int)recordClasses.size(), (int)m.size());
        for (int i = 0; i < recordClasses.size(); ++i) {
            TestResultShapes.assertEquals((String)("Map Contents " + m.toString() + " result: " + result + " loop size: " + recordClasses.size() + "Value of m.get(results[i]) " + m.get(((ArrayList)results).get(i).getClass())), ((ArrayList)recordClasses).get(i), m.get("jpqlalias" + (i + 1)).getClass());
        }
    }

    private void rawHelper(boolean unique, Class recordClass, String result, boolean inCache) {
        Iterator iter;
        ArrayList<String> l = new ArrayList<String>();
        l.add(result);
        ArrayList<String> res = result == null ? null : l;
        Query q = this.setUpQuery(unique, res);
        if (unique) {
            TestResultShapes.assertEquals((Object)recordClass, q.execute().getClass());
        } else {
            q.setUnique(unique);
            iter = ((List)q.execute()).iterator();
            while (iter.hasNext()) {
                TestResultShapes.assertEquals((Object)recordClass, iter.next().getClass());
            }
        }
        CacheTestHelper.assertInCache(this, q, new Boolean(inCache));
        if (unique) {
            TestResultShapes.assertEquals((Object)recordClass, q.execute().getClass());
        } else {
            iter = ((List)q.execute()).iterator();
            while (iter.hasNext()) {
                TestResultShapes.assertEquals((Object)recordClass, iter.next().getClass());
            }
        }
    }

    private Query setUpQuery(boolean unique, Collection results) {
        String filter = "select";
        ArrayList resultsl = (ArrayList)results;
        if (results != null) {
            String resultString = "";
            for (int i = 0; i < resultsl.size(); ++i) {
                resultString = resultString + "a." + resultsl.get(i);
                if (i >= results.size() - 1) continue;
                resultString = resultString + ", ";
            }
            filter = filter + " " + resultString;
            filter = filter + " from " + CacheObjectAChild1.class.getSuperclass().getSimpleName() + " a";
        } else {
            filter = filter + " a from " + CacheObjectAChild1.class.getSuperclass().getSimpleName() + " a";
        }
        if (unique) {
            filter = filter + " where a.age = 0";
        }
        System.out.println("****Query: " + filter);
        Query q = this._broker.newQuery("javax.persistence.JPQL", (Object)filter);
        q.setUnique(unique);
        q.setCandidateType(CacheObjectAChild1.class, false);
        return q;
    }
}

