/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.StoreCache;
import org.apache.openjpa.persistence.StoreCacheImpl;
import org.apache.openjpa.persistence.datacache.CachedEntityStatistics;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestStatistics
extends SingleEMFTestCase {
    private static final boolean L2Cached = true;
    private static final boolean L1Cached = true;
    private static final String cls = CachedEntityStatistics.class.getName();
    Object[] p = new Object[]{CLEAR_TABLES, CachedEntityStatistics.class, "openjpa.DataCache", "true(EnableStatistics=true)", "openjpa.QueryCache", "true"};
    private EntityManager em;
    private StoreCache cache;
    CacheStatistics stats;

    @Override
    public void setUp() {
        super.setUp(this.p);
        this.cache = this.emf.getStoreCache();
        TestStatistics.assertNotNull((Object)this.cache);
        this.stats = this.cache.getStatistics();
        TestStatistics.assertNotNull((Object)this.stats);
        this.em = this.emf.createEntityManager();
        this.stats.reset();
        this.em.clear();
    }

    public void testDefaultSettings() {
        Object[] props = new Object[]{"openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm"};
        OpenJPAEntityManagerFactorySPI emf1 = this.createNamedEMF("second-persistence-unit", props);
        TestStatistics.assertFalse((boolean)emf1.getStoreCache().getStatistics().isEnabled());
        this.closeEMF((EntityManagerFactory)emf1);
    }

    public void testSimpleFind() {
        int hit = 0;
        int read = 0;
        int write = 0;
        CachedEntityStatistics person = this.createData(false, false);
        this.em.clear();
        this.cache.getStatistics().reset();
        TestStatistics.assertTrue((boolean)this.cache.getStatistics().isEnabled());
        Integer pid = person.getId();
        this.assertCached(person, pid, false, true);
        CachedEntityStatistics p = (CachedEntityStatistics)this.em.find(CachedEntityStatistics.class, (Object)pid);
        TestStatistics.assertion(cls, ++hit, ++read, write, this.stats);
        this.em.find(CachedEntityStatistics.class, (Object)-1);
        ++read;
        this.assertCached(p, pid, true, true);
    }

    public void testFind() {
        int hit = 0;
        int evict = 0;
        int read = 0;
        int write = 0;
        CachedEntityStatistics person = this.createData(true, true);
        this.em.clear();
        this.cache.evictAll();
        this.cache.getStatistics().reset();
        TestStatistics.assertTrue((boolean)this.cache.getStatistics().isEnabled());
        TestStatistics.assertion(cls, hit, read, write, this.stats);
        Integer pid = person.getId();
        CachedEntityStatistics p = (CachedEntityStatistics)this.em.find(CachedEntityStatistics.class, (Object)pid);
        ++read;
        ++read;
        ++write;
        ++write;
        ++write;
        ++write;
        TestStatistics.assertion(cls, hit, ++read, ++write, this.stats);
        this.em.clear();
        this.em.find(CachedEntityStatistics.class, (Object)person.getEagerList().toArray(new CachedEntityStatistics[0])[0].getId());
        ++read;
        ++hit;
        this.em.clear();
        person = (CachedEntityStatistics)this.em.find(CachedEntityStatistics.class, (Object)pid);
        ++read;
        ++read;
        ++hit;
        ++hit;
        TestStatistics.assertion(cls, ++hit, ++read, write, this.stats);
        this.em.clear();
        this.cache.evict(CachedEntityStatistics.class, (Object)person.getEagerList().toArray(new CachedEntityStatistics[0])[0].getId());
        ++evict;
        p = (CachedEntityStatistics)this.em.find(CachedEntityStatistics.class, (Object)pid);
        ++read;
        ++read;
        ++hit;
        TestStatistics.assertion(cls, ++hit, ++read, ++write, this.stats);
        TestStatistics.assertEquals((int)1, (int)p.getLazyList().size());
        ++write;
        TestStatistics.assertion(cls, hit, ++read, ++write, this.stats);
        this.em.clear();
        this.em.find(CachedEntityStatistics.class, (Object)p.getLazyList().toArray(new CachedEntityStatistics[0])[0].getId());
        TestStatistics.assertion(cls, ++hit, ++read, write, this.stats);
    }

    public void testMultipleUnits() {
        Object[] props = new String[]{"openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm"};
        OpenJPAEntityManagerFactorySPI emf1 = this.createNamedEMF("test", props);
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF("empty-pu", props);
        TestStatistics.assertNotSame((Object)emf1, (Object)emf2);
        TestStatistics.assertNotSame((Object)emf1.getStoreCache(), (Object)emf2.getStoreCache());
        TestStatistics.assertNotSame((Object)emf1.getStoreCache().getStatistics(), (Object)emf2.getStoreCache().getStatistics());
        TestStatistics.assertNotSame((Object)((StoreCacheImpl)emf1.getStoreCache()).getDelegate(), (Object)((StoreCacheImpl)emf2.getStoreCache()).getDelegate());
        this.closeEMF((EntityManagerFactory)emf1);
        this.closeEMF((EntityManagerFactory)emf2);
    }

    public void testPersist() {
        int hit = 0;
        int read = 0;
        int write = 0;
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)new CachedEntityStatistics());
        this.em.getTransaction().commit();
        TestStatistics.assertion(cls, hit, read, ++write, this.stats);
        CachedEntityStatistics root = new CachedEntityStatistics();
        root.addEager(new CachedEntityStatistics());
        root.addEager(new CachedEntityStatistics());
        root.addLazy(new CachedEntityStatistics());
        root.addLazy(new CachedEntityStatistics());
        this.em.getTransaction().begin();
        this.em.persist((Object)root);
        this.em.getTransaction().commit();
        TestStatistics.assertion(cls, hit, read, write += 5, this.stats);
    }

    public void testRefresh() {
        int hit = 0;
        int read = 0;
        int write = 0;
        CachedEntityStatistics e = new CachedEntityStatistics();
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)e);
        this.em.getTransaction().commit();
        TestStatistics.assertion(cls, hit, read, ++write, this.stats);
        this.em.refresh((Object)e);
        TestStatistics.assertion(cls, hit, ++read, write, this.stats);
        this.em.clear();
    }

    public void testMerge() {
        int hit = 0;
        int read = 0;
        int write = 0;
        CachedEntityStatistics e = new CachedEntityStatistics();
        this.em = this.emf.createEntityManager();
        this.em.getTransaction().begin();
        this.em.persist((Object)e);
        this.em.getTransaction().commit();
        TestStatistics.assertion(cls, hit, read, ++write, this.stats);
        this.em.clear();
        this.cache.evictAll();
        this.em.getTransaction().begin();
        this.em.merge((Object)e);
        this.em.getTransaction().commit();
        TestStatistics.assertion(cls, hit, read, write, this.stats);
    }

    CachedEntityStatistics createData(boolean lazy, boolean eager) {
        this.em.getTransaction().begin();
        CachedEntityStatistics p = new CachedEntityStatistics();
        if (lazy) {
            p.addLazy(new CachedEntityStatistics());
        }
        if (eager) {
            p.addEager(new CachedEntityStatistics());
            p.addEager(new CachedEntityStatistics());
        }
        this.em.persist((Object)p);
        this.em.getTransaction().commit();
        return p;
    }

    long[] snapshot() {
        return new long[]{this.stats.getReadCount(), this.stats.getHitCount(), this.stats.getWriteCount()};
    }

    private static final void assertion(String cls, int hit, int read, int write, CacheStatistics stats) {
        if (cls == null) {
            throw new RuntimeException("invalid assertion. Null class");
        }
        try {
            TestStatistics.assertEquals((String)"Hit count doesn't match", (long)hit, (long)stats.getHitCount(cls));
            TestStatistics.assertEquals((String)"Read count doesn't match", (long)read, (long)stats.getReadCount(cls));
            TestStatistics.assertEquals((String)"Write count doesn't match", (long)write, (long)stats.getWriteCount(cls));
        }
        catch (AssertionFailedError t) {
            System.out.println("hit : " + stats.getHitCount(cls) + " read: " + stats.getReadCount(cls) + " write: " + stats.getWriteCount(cls));
            throw t;
        }
    }

    void assertDelta(long[] before, long[] after, long readDelta, long hitDelta, long writeDelta) {
        TestStatistics.assertEquals((String)"READ count mismatch", (long)readDelta, (long)(after[0] - before[0]));
        TestStatistics.assertEquals((String)"HIT count mismatch", (long)hitDelta, (long)(after[1] - before[1]));
        TestStatistics.assertEquals((String)"WRITE count mismatch", (long)writeDelta, (long)(after[2] - before[2]));
    }

    void assertCached(Object o, Object oid, boolean l1, boolean l2) {
        boolean l1a = this.em.contains(o);
        boolean l2a = this.cache.contains(o.getClass(), oid);
        if (l1 != l1a) {
            TestStatistics.fail((String)("Expected " + (l1 ? "" : "not") + " to find instance " + o.getClass().getSimpleName() + ":" + oid + " in L1 cache"));
        }
        if (l2 != l2a) {
            TestStatistics.fail((String)("Expected " + (l2 ? "" : "not") + " to find instance " + o.getClass().getSimpleName() + ":" + oid + " in L2 cache"));
        }
    }

    void print(String msg, CacheStatistics stats) {
        System.err.println(msg + stats + " H:" + stats.getHitCount() + " R:" + stats.getReadCount() + " W:" + stats.getWriteCount());
    }
}

