/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.datacache.common.apps.CacheObjectA;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestUniteratedQueryResult
extends AbstractTestCase {
    private EntityManagerFactory _pmf;

    public TestUniteratedQueryResult(String test) {
        super(test, "datacachecactusapp");
    }

    public void setUp() {
        System.out.println("****Deleted Records " + this.deleteAll(CacheObjectA.class));
        HashMap<String, String> propsMap = new HashMap<String, String>();
        propsMap.put("openjpa.DataCache", "true");
        propsMap.put("openjpa.QueryCache", "true");
        propsMap.put("openjpa.RemoteCommitProvider", "sjvm");
        propsMap.put("openjpa.FetchBatchSize", "0");
        this._pmf = this.getEmf(propsMap);
    }

    public void test() {
        CacheObjectA pc1 = new CacheObjectA();
        pc1.setName("pc1");
        CacheObjectA pc2 = new CacheObjectA();
        pc2.setName("pc2");
        OpenJPAEntityManager pm = (OpenJPAEntityManager)this._pmf.createEntityManager();
        this.startTx((EntityManager)pm);
        pm.persist((Object)pc1);
        pm.persist((Object)pc2);
        this.endTx((EntityManager)pm);
        Object oid1 = pm.getObjectId((Object)pc1);
        Object oid2 = pm.getObjectId((Object)pc2);
        this.endEm((EntityManager)pm);
        pm = (OpenJPAEntityManager)this._pmf.createEntityManager();
        OpenJPAQuery q = pm.createQuery("select a FROM " + CacheObjectA.class.getSimpleName() + " a where a.name = 'pc1'");
        List res = q.getResultList();
        OpenJPAEntityManager pm2 = (OpenJPAEntityManager)this._pmf.createEntityManager();
        this.startTx((EntityManager)pm2);
        pc1 = (CacheObjectA)pm2.find(CacheObjectA.class, oid1);
        pc2 = (CacheObjectA)pm2.find(CacheObjectA.class, oid2);
        pc1.setName("pc2");
        pc2.setName("pc1");
        this.endTx((EntityManager)pm2);
        TestUniteratedQueryResult.assertEquals((int)1, (int)res.size());
        Iterator itr = res.iterator();
        while (itr.hasNext()) {
            TestUniteratedQueryResult.assertEquals((Object)oid1, (Object)pm2.getObjectId(itr.next()));
        }
        this.endEm((EntityManager)pm2);
        this.endEm((EntityManager)pm);
        pm = (OpenJPAEntityManager)this._pmf.createEntityManager();
        q = pm.createQuery("select a FROM " + CacheObjectA.class.getSimpleName() + " a where a.name = 'pc1'");
        res = q.getResultList();
        TestUniteratedQueryResult.assertEquals((Object)oid2, (Object)pm.getObjectId(res.iterator().next()));
        this.endEm((EntityManager)pm);
    }
}

