/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.datacache.stats;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.jdbc.query.domain.Customer;
import org.apache.openjpa.persistence.jdbc.query.domain.Order;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestStatistics
extends SingleEMFTestCase {
    private CacheStatistics stats;

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, Customer.class, Order.class, "openjpa.DataCache", "true", "openjpa.RemoteCommitProvider", "sjvm");
        this.startCaching(Customer.class);
        this.startCaching(Order.class);
        TestStatistics.assertTrue((boolean)((EntityManagerImpl)this.emf.createEntityManager()).getBroker().getPopulateDataCache());
        this.stats = this.emf.getStoreCache().getStatistics();
        TestStatistics.assertNotNull((Object)this.stats);
    }

    void startCaching(Class<?> cls) {
        ClassMetaData meta = this.emf.getConfiguration().getMetaDataRepositoryInstance().getMetaData(cls, null, true);
        meta.setDataCacheName("default");
    }

    public void testPerfectCache() {
        int nCustomer = 20;
        int nOrder = 10;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int j = 0; j < nCustomer; ++j) {
            Customer customer = new Customer();
            customer.setName("Customer-" + j);
            for (int k = 0; k < nOrder; ++k) {
                Order order = new Order();
                order.setAmount(100);
                customer.addOrder(order);
                em.persist((Object)order);
            }
            em.persist((Object)customer);
        }
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        Query query = em.createQuery("select c from Customer c");
        for (int i = 0; i < 10; ++i) {
            em.clear();
            this.stats.reset();
            List result = query.getResultList();
            for (Customer c : result) {
                c.getOrders();
            }
            TestStatistics.assertEquals((long)this.stats.getReadCount(), (long)this.stats.getHitCount());
            TestStatistics.assertEquals((long)0L, (long)this.stats.getWriteCount());
        }
        em.getTransaction().commit();
        em.close();
    }

    void assertStatistics(CacheStatistics stats, long[] expected) {
        TestStatistics.assertEquals((long)expected[0], (long)stats.getReadCount());
        TestStatistics.assertEquals((long)expected[1], (long)stats.getHitCount());
        TestStatistics.assertEquals((long)expected[2], (long)stats.getWriteCount());
    }

    void print(CacheStatistics stats) {
    }
}

