/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import java.util.List;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.delimited.identifiers.EntityH;
import org.apache.openjpa.persistence.delimited.identifiers.EntityI;
import org.apache.openjpa.persistence.delimited.identifiers.EntityI2;
import org.apache.openjpa.persistence.delimited.identifiers.EntityI3;
import org.apache.openjpa.persistence.delimited.identifiers.EntityI4;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestDelimitedJoinAnnotation
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    EntityH entityH;
    EntityI entityI;
    EntityI2 entityI2;
    EntityI3 entityI3;
    EntityI4 entityI4;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DerbyDictionary.class, DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(EntityH.class, EntityI.class, EntityI2.class, EntityI3.class, EntityI4.class, DROP_TABLES);
        TestDelimitedJoinAnnotation.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestDelimitedJoinAnnotation.assertNotNull((Object)this.em);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
        super.tearDown();
    }

    @Override
    protected OpenJPAEntityManagerFactorySPI createEMF(Object ... props) {
        return this.createNamedEMF("delimited-identifiers", props);
    }

    public void createHandI(int id) {
        this.entityH = new EntityH(id);
        this.entityH.setName("eh");
        this.entityH.setSecName("secName1");
        this.entityI = new EntityI(id);
        this.entityI.setName("ei");
        this.entityI2 = new EntityI2(id);
        this.entityI2.setName("ei2");
        this.entityI3 = new EntityI3(id);
        this.entityI3.setName("ei3");
        this.entityI4 = new EntityI4(id);
        this.entityI4.setName("ei4");
        this.entityH.addEntityI(this.entityI);
        this.entityI.addEntityH(this.entityH);
        this.entityH.setEntityI2(this.entityI2);
        this.entityH.addMapValues(this.entityI3, this.entityI4);
        this.entityH.addMap2Values(this.entityI4, this.entityI3);
        this.entityI2.setEntityI3(this.entityI3);
    }

    public void testCreate() {
        ++this.id;
        this.createHandI(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityH);
        this.em.persist((Object)this.entityI);
        this.em.persist((Object)this.entityI2);
        this.em.persist((Object)this.entityI3);
        this.em.persist((Object)this.entityI4);
        this.em.getTransaction().commit();
        this.runQueries();
    }

    private void runQueries() {
        this.em.clear();
        this.queryJoinTable();
        this.em.clear();
        this.queryJoinColumn();
        this.em.clear();
        this.querySecondaryTableValue();
        this.em.clear();
        this.queryMapValue();
    }

    private void queryJoinTable() {
        String query = "SELECT h FROM EntityH h JOIN h.entityIs i WHERE i.name = 'ei'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestDelimitedJoinAnnotation.assertEquals((int)1, (int)results.size());
    }

    private void queryJoinColumn() {
        String query = "SELECT h FROM EntityH h JOIN h.entityI2 i2 WHERE i2.name = 'ei2'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestDelimitedJoinAnnotation.assertEquals((int)1, (int)results.size());
    }

    private void querySecondaryTableValue() {
        String query = "SELECT h FROM EntityH h WHERE h.secName = 'secName1'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestDelimitedJoinAnnotation.assertEquals((int)1, (int)results.size());
    }

    private void queryMapValue() {
        String query = "SELECT h FROM EntityH h, IN(h.map2) m WHERE m.name = 'ei3'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestDelimitedJoinAnnotation.assertEquals((int)1, (int)results.size());
    }
}

