/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers;

import java.util.List;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.delimited.identifiers.EntityF;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestManualDelimId
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    EntityF entityF;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DB2Dictionary.class, DerbyDictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(EntityF.class, DROP_TABLES);
        TestManualDelimId.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestManualDelimId.assertNotNull((Object)this.em);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
        super.tearDown();
    }

    public void createEntityF() {
        this.entityF = new EntityF("fName");
        this.entityF.setNonDelimName("fNonDelimName");
        this.entityF.setSecName("sec name");
        this.entityF.addCollectionSet("xxx");
        this.entityF.addCollectionSet("yyy");
        this.entityF.addCollectionDelimSet("aaa");
        this.entityF.addCollectionDelimSet("bbb");
        this.entityF.addCollectionMap("aaa", "xxx");
        this.entityF.addCollectionMap("bbb", "yyy");
        this.entityF.addDelimCollectionMap("www", "xxx");
        this.entityF.addDelimCollectionMap("yyy", "zzz");
    }

    public void testCreateF() {
        this.createEntityF();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityF);
        this.em.getTransaction().commit();
        this.runQueries();
    }

    public void testCreateF2() {
        this.createEntityF();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityF);
        this.em.getTransaction().commit();
    }

    private void runQueries() {
        this.em.clear();
        this.queryOnEntityOnly();
        this.em.clear();
        this.queryOnColumnValue();
        this.em.clear();
        this.queryCollection();
    }

    private void queryOnEntityOnly() {
        String query = "SELECT DISTINCT f FROM EntityF f";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestManualDelimId.assertEquals((int)1, (int)results.size());
    }

    private void queryOnColumnValue() {
        String query = "SELECT DISTINCT f FROM EntityF f WHERE f.name = 'fName'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestManualDelimId.assertEquals((int)1, (int)results.size());
    }

    private void queryCollection() {
        String query = "SELECT DISTINCT f FROM EntityF f, IN(f.collectionDelimSet) s WHERE s = 'aaa'";
        OpenJPAQuery q = this.em.createQuery(query);
        List results = q.getResultList();
        TestManualDelimId.assertEquals((int)1, (int)results.size());
    }
}

