/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers.xml;

import java.util.List;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DerbyDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.delimited.identifiers.xml.Car;
import org.apache.openjpa.persistence.delimited.identifiers.xml.Car2;
import org.apache.openjpa.persistence.delimited.identifiers.xml.Chevrolet;
import org.apache.openjpa.persistence.delimited.identifiers.xml.Chevrolet2;
import org.apache.openjpa.persistence.delimited.identifiers.xml.Pontiac;
import org.apache.openjpa.persistence.delimited.identifiers.xml.Pontiac2;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestXmlDelimIdResultSets
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    int id = 0;
    Car car;
    Pontiac pontiac;
    Chevrolet chevrolet;
    Car2 car2;
    Pontiac2 pontiac2;
    Chevrolet2 chevrolet2;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DerbyDictionary.class, DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(Car.class, Pontiac.class, Chevrolet.class, Car2.class, Pontiac2.class, Chevrolet2.class, DROP_TABLES);
        TestXmlDelimIdResultSets.assertNotNull((Object)this.emf);
        this.em = this.emf.createEntityManager();
        TestXmlDelimIdResultSets.assertNotNull((Object)this.em);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
        super.tearDown();
    }

    @Override
    protected String getPersistenceUnitName() {
        return "delimited-identifiers-result-set-xml";
    }

    private void createChevrolet(int id) {
        this.chevrolet = new Chevrolet(id);
        this.chevrolet.setModel("Malibu");
        this.chevrolet.setColor("black");
        this.chevrolet.setModelYear("2009");
    }

    private void createPontiac(int id) {
        this.pontiac = new Pontiac(id);
        this.pontiac.setModel("G6");
        this.pontiac.setColor("red");
        this.pontiac.setModelYear("2005");
    }

    public void testCreate() {
        ++this.id;
        this.createPontiac(this.id);
        ++this.id;
        this.createChevrolet(this.id);
        this.em.getTransaction().begin();
        this.em.persist((Object)this.pontiac);
        this.em.persist((Object)this.chevrolet);
        this.em.getTransaction().commit();
        this.runQueries();
    }

    private void runQueries() {
        this.em.clear();
        this.resultSetQuery();
    }

    private void resultSetQuery() {
        String query = "SELECT c.id, c.\"car model\", c.\"car color\", c.\"discr col\", c.\"model year\" FROM \"XmlCar\" c ";
        OpenJPAQuery q = this.em.createNativeQuery(query, "XmlCarResultSet");
        List results = q.getResultList();
        TestXmlDelimIdResultSets.assertEquals((int)2, (int)results.size());
        for (Object[] result : results) {
            TestXmlDelimIdResultSets.assertEquals((int)2, (int)result.length);
            TestXmlDelimIdResultSets.assertTrue((boolean)(result[0] instanceof Car2));
            TestXmlDelimIdResultSets.assertTrue((boolean)(result[1] instanceof String));
            Car2 car2 = (Car2)result[0];
            String modelYear = (String)result[1];
            if (car2.getModel().equals("G6")) {
                TestXmlDelimIdResultSets.assertEquals((String)"2005", (String)modelYear);
                continue;
            }
            if (!car2.getModel().equals("Malibu")) continue;
            TestXmlDelimIdResultSets.assertEquals((String)"2009", (String)modelYear);
        }
    }
}

