/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.delimited.identifiers.xml;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.delimited.identifiers.xml.EntityB;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestXmlDelimIdSeqGen
extends SQLListenerTestCase {
    OpenJPAEntityManager em;
    JDBCConfiguration conf;
    DBDictionary dict;
    boolean supportsNativeSequence = false;
    EntityB entityB;

    @Override
    public void setUp() throws Exception {
        this.setSupportedDatabases(DB2Dictionary.class);
        if (this.isTestsDisabled()) {
            return;
        }
        super.setUp(EntityB.class, DROP_TABLES);
        TestXmlDelimIdSeqGen.assertNotNull((Object)this.emf);
        this.conf = (JDBCConfiguration)this.emf.getConfiguration();
        this.dict = this.conf.getDBDictionaryInstance();
        boolean bl = this.supportsNativeSequence = this.dict.nextSequenceQuery != null;
        if (this.supportsNativeSequence) {
            this.em = this.emf.createEntityManager();
            TestXmlDelimIdSeqGen.assertNotNull((Object)this.em);
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
            this.em = null;
        }
        this.dict = null;
        this.conf = null;
        super.tearDown();
    }

    @Override
    protected String getPersistenceUnitName() {
        return "delimited-identifiers-seq-gen-xml";
    }

    public void createEntityB() {
        this.entityB = new EntityB("b name");
    }

    public void testSeqGen() {
        if (!this.supportsNativeSequence) {
            return;
        }
        this.createEntityB();
        this.em.getTransaction().begin();
        this.em.persist((Object)this.entityB);
        this.em.getTransaction().commit();
        int genId = this.entityB.getId();
        this.em.clear();
        this.em.getTransaction().begin();
        EntityB bA = (EntityB)this.em.find(EntityB.class, (Object)genId);
        TestXmlDelimIdSeqGen.assertEquals((String)"b name", (String)bA.getName());
        this.em.getTransaction().commit();
        this.em.close();
    }
}

