/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.detach.Entity20;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDetachNoProxy
extends SingleEMFTestCase {
    private static final int numEntities = 3;
    private static final String PROXY = new String("$proxy");
    private Log _log;

    @Override
    public void setUp() {
        this.setUp(DROP_TABLES, Entity20.class);
        this._log = this.emf.getConfiguration().getLog("test");
        this.createEntities(3);
    }

    private void createEntities(int count) {
        Entity20 e20 = null;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        for (int i = 0; i < count; ++i) {
            e20 = new Entity20(i);
            em.persist((Object)e20);
        }
        em.getTransaction().commit();
        em.close();
    }

    public void testDetach20() {
        Integer id = new Integer(0);
        OpenJPAEntityManagerFactorySPI emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"NoProxy2New", (String)"org/apache/openjpa/persistence/detach/persistence2.xml");
        TestDetachNoProxy.assertNotNull((Object)emf2);
        Log log = emf2.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            log.trace((Object)"***** testDetach20() *****");
        }
        if (log.isTraceEnabled()) {
            Compatibility compat = emf2.getConfiguration().getCompatibilityInstance();
            TestDetachNoProxy.assertNotNull((Object)compat);
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        OpenJPAEntityManagerSPI em = emf2.createEntityManager();
        em.clear();
        Entity20 e20 = (Entity20)em.find(Entity20.class, (Object)id);
        if (log.isTraceEnabled()) {
            log.trace((Object)"** testDetach20() - after find");
        }
        TestDetachNoProxy.assertTrue((boolean)em.contains((Object)e20));
        TestDetachNoProxy.assertFalse((boolean)em.isDetached((Object)e20));
        this.verifySerializable(e20, true, false);
        em.detach((Object)e20);
        if (log.isTraceEnabled()) {
            log.trace((Object)"** testDetach20() - after detach");
        }
        TestDetachNoProxy.assertFalse((boolean)em.contains((Object)e20));
        TestDetachNoProxy.assertTrue((boolean)em.isDetached((Object)e20));
        this.verifySerializable(e20, true, false);
        em.close();
        this.closeEMF((EntityManagerFactory)emf2);
    }

    public void testDetachCopy20() {
        Integer id = new Integer(0);
        OpenJPAEntityManagerFactorySPI emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"NoProxy2New", (String)"org/apache/openjpa/persistence/detach/persistence2.xml");
        TestDetachNoProxy.assertNotNull((Object)emf2);
        Log log = emf2.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            log.trace((Object)"***** testDetachCopy20() *****");
        }
        if (log.isTraceEnabled()) {
            Compatibility compat = emf2.getConfiguration().getCompatibilityInstance();
            TestDetachNoProxy.assertNotNull((Object)compat);
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        OpenJPAEntityManagerSPI em = emf2.createEntityManager();
        em.clear();
        Entity20 e20 = (Entity20)em.find(Entity20.class, (Object)id);
        if (log.isTraceEnabled()) {
            log.trace((Object)"** testDetachCopy20() - after find");
        }
        TestDetachNoProxy.assertTrue((boolean)em.contains((Object)e20));
        TestDetachNoProxy.assertFalse((boolean)em.isDetached((Object)e20));
        this.verifySerializable(e20, true, false);
        Entity20 e20copy = (Entity20)em.detachCopy((Object)e20);
        if (log.isTraceEnabled()) {
            log.trace((Object)"** TestDetachCopy20() - after detachCopy");
        }
        TestDetachNoProxy.assertTrue((boolean)em.contains((Object)e20));
        TestDetachNoProxy.assertFalse((boolean)em.isDetached((Object)e20));
        this.verifySerializable(e20, true, false);
        TestDetachNoProxy.assertFalse((boolean)em.contains((Object)e20copy));
        TestDetachNoProxy.assertTrue((boolean)em.isDetached((Object)e20copy));
        this.verifySerializable(e20copy, false, false);
        em.close();
        this.closeEMF((EntityManagerFactory)emf2);
    }

    public void testDetachAll20() {
        Entity20 e20;
        int i;
        OpenJPAEntityManagerFactorySPI emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"NoProxy2New", (String)"org/apache/openjpa/persistence/detach/persistence2.xml");
        TestDetachNoProxy.assertNotNull((Object)emf2);
        Log log = emf2.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            log.trace((Object)"***** testDetachAll20() *****");
        }
        if (log.isTraceEnabled()) {
            Compatibility compat = emf2.getConfiguration().getCompatibilityInstance();
            TestDetachNoProxy.assertNotNull((Object)compat);
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        OpenJPAEntityManagerSPI em = emf2.createEntityManager();
        em.clear();
        ArrayList<Entity20> e20List = new ArrayList<Entity20>(3);
        for (i = 0; i < 3; ++i) {
            e20 = (Entity20)em.find(Entity20.class, (Object)new Integer(i));
            e20List.add(e20);
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testDetachAll20() - after find Entity20(" + i + ")"));
            }
            TestDetachNoProxy.assertTrue((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertFalse((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, false);
        }
        em.detachAll(new Object[]{e20List.get(0), e20List.get(1), e20List.get(2)});
        for (i = 0; i < 3; ++i) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testDetachAll20() - after EM.detachAll() verify e20List(" + i + ")"));
            }
            e20 = (Entity20)e20List.get(i);
            TestDetachNoProxy.assertFalse((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertTrue((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, false);
        }
        em.close();
        this.closeEMF((EntityManagerFactory)emf2);
    }

    public void testClear10Compat() {
        Entity20 e20;
        int i;
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"NoProxy1Compat", (String)"org/apache/openjpa/persistence/detach/persistence1.xml");
        TestDetachNoProxy.assertNotNull((Object)emf1);
        Log log = emf1.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            log.trace((Object)"***** testClear10Compat() *****");
        }
        if (log.isTraceEnabled()) {
            Compatibility compat = emf1.getConfiguration().getCompatibilityInstance();
            TestDetachNoProxy.assertNotNull((Object)compat);
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        OpenJPAEntityManagerSPI em = emf1.createEntityManager();
        em.clear();
        ArrayList<Entity20> e20List = new ArrayList<Entity20>(3);
        for (i = 0; i < 3; ++i) {
            e20 = (Entity20)em.find(Entity20.class, (Object)new Integer(i));
            e20List.add(e20);
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testClear10Compat() - after find Entity20(" + i + ")"));
            }
            TestDetachNoProxy.assertTrue((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertFalse((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, false);
        }
        em.clear();
        for (i = 0; i < 3; ++i) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testClear10Compat() - after EM.clear() verify Entity20(" + i + ")"));
            }
            e20 = (Entity20)e20List.get(i);
            TestDetachNoProxy.assertFalse((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertTrue((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, true);
        }
        em.close();
        this.closeEMF((EntityManagerFactory)emf1);
    }

    public void testClear20Compat() {
        Entity20 e20;
        int i;
        OpenJPAEntityManagerFactorySPI emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"NoProxy2Compat", (String)"org/apache/openjpa/persistence/detach/persistence2.xml");
        TestDetachNoProxy.assertNotNull((Object)emf2);
        Log log = emf2.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            log.trace((Object)"***** testClear20Compat() *****");
        }
        if (log.isTraceEnabled()) {
            Compatibility compat = emf2.getConfiguration().getCompatibilityInstance();
            TestDetachNoProxy.assertNotNull((Object)compat);
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        OpenJPAEntityManagerSPI em = emf2.createEntityManager();
        em.clear();
        ArrayList<Entity20> e20List = new ArrayList<Entity20>(3);
        for (i = 0; i < 3; ++i) {
            e20 = (Entity20)em.find(Entity20.class, (Object)new Integer(i));
            e20List.add(e20);
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testClear20Compat() - after find Entity20(" + i + ")"));
            }
            TestDetachNoProxy.assertTrue((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertFalse((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, false);
        }
        em.clear();
        for (i = 0; i < 3; ++i) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testClear20Compat() - after EM.clear() verify Entity20(" + i + ")"));
            }
            e20 = (Entity20)e20List.get(i);
            TestDetachNoProxy.assertFalse((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertTrue((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, true);
        }
        em.close();
        this.closeEMF((EntityManagerFactory)emf2);
    }

    public void testClear20New() {
        Entity20 e20;
        int i;
        OpenJPAEntityManagerFactorySPI emf2 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"NoProxy2New", (String)"org/apache/openjpa/persistence/detach/persistence2.xml");
        TestDetachNoProxy.assertNotNull((Object)emf2);
        Log log = emf2.getConfiguration().getLog("test");
        if (log.isTraceEnabled()) {
            log.trace((Object)"***** testClear20New() *****");
        }
        if (log.isTraceEnabled()) {
            Compatibility compat = emf2.getConfiguration().getCompatibilityInstance();
            TestDetachNoProxy.assertNotNull((Object)compat);
            log.trace((Object)("FlushBeforeDetach=" + compat.getFlushBeforeDetach()));
            log.trace((Object)("CopyOnDetach=" + compat.getCopyOnDetach()));
            log.trace((Object)("CascadeWithDetach=" + compat.getCascadeWithDetach()));
            log.trace((Object)("IgnoreDetachedStateFieldForProxySerialization=" + compat.getIgnoreDetachedStateFieldForProxySerialization()));
        }
        OpenJPAEntityManagerSPI em = emf2.createEntityManager();
        em.clear();
        ArrayList<Entity20> e20List = new ArrayList<Entity20>(3);
        for (i = 0; i < 3; ++i) {
            e20 = (Entity20)em.find(Entity20.class, (Object)new Integer(i));
            e20List.add(e20);
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testClear20New() - after find Entity20(" + i + ")"));
            }
            TestDetachNoProxy.assertTrue((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertFalse((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, false);
        }
        em.clear();
        for (i = 0; i < 3; ++i) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("** testClear20New() - after EM.clear() verify Entity20(" + i + ")"));
            }
            e20 = (Entity20)e20List.get(i);
            TestDetachNoProxy.assertFalse((boolean)em.contains((Object)e20));
            TestDetachNoProxy.assertTrue((boolean)em.isDetached((Object)e20));
            this.verifySerializable(e20, true, false);
        }
        em.close();
        this.closeEMF((EntityManagerFactory)emf2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySerializable(Entity20 e20, boolean usesProxyBefore, boolean usesProxyAfter) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        byte[] e20bytes = null;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"verifySerializable() - before serialize");
        }
        this.verifyEntities(e20, usesProxyBefore);
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(e20);
            e20bytes = baos.toByteArray();
        }
        catch (IOException e) {
            TestDetachNoProxy.fail((String)e.toString());
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {}
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(e20bytes);
        ObjectInputStream ois = null;
        Entity20 e20new = null;
        try {
            ois = new ObjectInputStream(bais);
            e20new = (Entity20)ois.readObject();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"verifySerializable() - after deserialize");
            }
            this.verifyEntities(e20new, usesProxyAfter);
        }
        catch (IOException e) {
            TestDetachNoProxy.fail((String)e.toString());
        }
        catch (ClassNotFoundException e) {
            TestDetachNoProxy.fail((String)e.toString());
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void verifyEntities(Entity20 e20, boolean usesProxy) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("verifyEntities() - asserting expected proxy usage is " + usesProxy));
            this.printClassNames(e20);
        }
        TestDetachNoProxy.assertTrue((String)("Expected sqlDate endsWith($proxy) to return " + usesProxy), (usesProxy == e20.getDate().getClass().getCanonicalName().endsWith(PROXY) ? 1 : 0) != 0);
        TestDetachNoProxy.assertTrue((String)("Expected sqlTime endsWith($proxy) to return " + usesProxy), (usesProxy == e20.getTime().getClass().getCanonicalName().endsWith(PROXY) ? 1 : 0) != 0);
        TestDetachNoProxy.assertTrue((String)("Expected sqlTimestamp endsWith($proxy) to return " + usesProxy), (usesProxy == e20.getTimestamp().getClass().getCanonicalName().endsWith(PROXY) ? 1 : 0) != 0);
    }

    private void printClassNames(Entity20 e20) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("sqlDate = " + e20.getDate().getClass().getCanonicalName()));
            this._log.trace((Object)("sqlTime = " + e20.getTime().getClass().getCanonicalName()));
            this._log.trace((Object)("sqlTimestamp = " + e20.getTimestamp().getClass().getCanonicalName()));
        }
    }
}

