/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach;

import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detach.IntVersionEntity;
import org.apache.openjpa.persistence.detach.NoVersionEntity;
import org.apache.openjpa.persistence.detach.TimestampVersionEntity;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestDetachReloadProp
extends SQLListenerTestCase {
    IntVersionEntity intVer;
    TimestampVersionEntity tsVer;
    NoVersionEntity noVer;
    int id;
    Compatibility compat;

    @Override
    public void setUp() {
        this.setUp(IntVersionEntity.class, TimestampVersionEntity.class, NoVersionEntity.class);
        this.compat = this.emf.getConfiguration().getCompatibilityInstance();
        ++this.id;
        this.create(this.id);
        this.persist();
    }

    private void create(int id) {
        this.intVer = new IntVersionEntity(id);
        this.intVer.setName("xxx");
        this.tsVer = new TimestampVersionEntity(id);
        this.tsVer.setName("yyy");
        this.intVer.setE2(this.tsVer);
        this.noVer = new NoVersionEntity(id);
        this.noVer.setName("zzz");
    }

    private void persist() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)this.noVer);
        em.persist((Object)this.intVer);
        em.getTransaction().commit();
        em.close();
        em = null;
    }

    public void testReloadTrue() {
        this.compat.setReloadOnDetach(true);
        this.detachProcessing();
    }

    public void testReloadFalse() {
        this.compat.setReloadOnDetach(false);
        this.detachProcessing();
    }

    private void detachProcessing() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.intVer = (IntVersionEntity)em.find(IntVersionEntity.class, (Object)this.id);
        this.tsVer = (TimestampVersionEntity)em.find(TimestampVersionEntity.class, (Object)this.id);
        this.noVer = (NoVersionEntity)em.find(NoVersionEntity.class, (Object)this.id);
        em.detach((Object)this.intVer);
        em.detach((Object)this.tsVer);
        em.detach((Object)this.noVer);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.intVer = (IntVersionEntity)em.find(IntVersionEntity.class, (Object)this.id);
        this.tsVer = (TimestampVersionEntity)em.find(TimestampVersionEntity.class, (Object)this.id);
        this.noVer = (NoVersionEntity)em.find(NoVersionEntity.class, (Object)this.id);
        em.getTransaction().commit();
        em.close();
    }
}

