/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detach;

import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detach.IntVersionEntity;
import org.apache.openjpa.persistence.detach.IntegerVersionEntity;
import org.apache.openjpa.persistence.detach.NoVersionEntity;
import org.apache.openjpa.persistence.detach.TimestampVersionEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestMergeNoStateManager
extends SingleEMFTestCase {
    Object[] args = new Object[]{TimestampVersionEntity.class, IntVersionEntity.class, NoVersionEntity.class, IntegerVersionEntity.class, CLEAR_TABLES};
    IntVersionEntity _ive;
    NoVersionEntity _nve;
    IntegerVersionEntity _integerVe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        super.setUp(this.args);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            if (em.find(IntVersionEntity.class, (Object)1) == null) {
                em.getTransaction().begin();
                this._ive = new IntVersionEntity(1);
                this._nve = new NoVersionEntity(1);
                this._integerVe = new IntegerVersionEntity(1);
                em.persist((Object)this._ive);
                em.persist((Object)this._nve);
                em.persist((Object)this._integerVe);
                em.getTransaction().commit();
            }
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            String updatedName = "updatedName_" + System.currentTimeMillis();
            IntVersionEntity detachedIve = new IntVersionEntity(this._ive.getId());
            NoVersionEntity detachedNve = new NoVersionEntity(this._nve.getId());
            IntegerVersionEntity detachedIntegerVe = new IntegerVersionEntity(this._integerVe.getId());
            detachedIntegerVe.setName(updatedName);
            detachedNve.setName(updatedName);
            detachedIve.setName(updatedName);
            em.getTransaction().begin();
            em.merge((Object)detachedIntegerVe);
            em.merge((Object)detachedNve);
            em.merge((Object)detachedIve);
            em.getTransaction().commit();
            em.clear();
            detachedIntegerVe = (IntegerVersionEntity)em.find(IntegerVersionEntity.class, (Object)this._integerVe.getId());
            detachedNve = (NoVersionEntity)em.find(NoVersionEntity.class, (Object)this._nve.getId());
            detachedIve = (IntVersionEntity)em.find(IntVersionEntity.class, (Object)this._ive.getId());
            TestMergeNoStateManager.assertEquals((String)detachedIntegerVe.getName(), (String)updatedName);
            TestMergeNoStateManager.assertEquals((String)detachedNve.getName(), (String)updatedName);
            TestMergeNoStateManager.assertEquals((String)detachedIve.getName(), (String)updatedName);
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().commit();
            }
            em.close();
        }
    }
}

