/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import java.util.ArrayList;
import org.apache.openjpa.jdbc.kernel.EntityF;
import org.apache.openjpa.jdbc.kernel.EntityG;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestCascadeMerge
extends SingleEMFTestCase {
    private EntityG enG1;
    private EntityG enG2;

    @Override
    public void setUp() {
        this.setUp(CLEAR_TABLES, EntityF.class, EntityG.class);
        this.createTestData();
    }

    private void createTestData() {
        this.enG1 = new EntityG();
        this.enG1.setId(1);
        this.enG2 = new EntityG();
        this.enG2.setId(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadeMerge() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        try {
            em.getTransaction().begin();
            EntityF enF = new EntityF();
            enF.setId(1);
            em.persist((Object)enF);
            em.getTransaction().commit();
            em.close();
            em = this.emf.createEntityManager();
            em.getTransaction().begin();
            EntityF enF1 = (EntityF)em.find(EntityF.class, (Object)1);
            this.enG1.setEntityF(enF1);
            this.enG2.setEntityF(enF1);
            ArrayList<EntityG> l = new ArrayList<EntityG>();
            l.add(this.enG1);
            l.add(this.enG2);
            enF1.setListG(l);
            em.merge((Object)this.enG1);
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

