/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.detachment;

import junit.textui.TestRunner;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.detachment.model.SimpleA;
import org.apache.openjpa.persistence.detachment.model.SimpleB;
import org.apache.openjpa.persistence.detachment.model.SimpleC;
import org.apache.openjpa.persistence.detachment.model.SimpleRef;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestNoCascadeOneToManyMerge
extends SingleEMFTestCase {
    private int a_id;

    @Override
    public void setUp() {
        this.setUp(SimpleA.class, SimpleRef.class, SimpleB.class, SimpleC.class, CLEAR_TABLES);
        this.createEntities();
    }

    private void createEntities() {
        SimpleA a = new SimpleA();
        a.setName("a1");
        SimpleB b = new SimpleB();
        b.setName("b1");
        a.addB(b);
        SimpleC c1 = new SimpleC();
        c1.setName("c1");
        b.addC(c1);
        SimpleC c2 = new SimpleC();
        c2.setName("c2");
        b.addC(c2);
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)a);
        em.getTransaction().commit();
        em.close();
        this.a_id = a.getId();
    }

    public void testMergeAttached() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SimpleA a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        TestNoCascadeOneToManyMerge.assertNotNull((Object)a);
        SimpleB b = new SimpleB();
        b.setName("b2");
        a.addB(b);
        SimpleC c = new SimpleC();
        c.setName("c3");
        b.addC(c);
        c = new SimpleC();
        c.setName("c4");
        b.addC(c);
        em.getTransaction().begin();
        a = (SimpleA)em.merge((Object)a);
        em.getTransaction().commit();
        em.close();
        TestNoCascadeOneToManyMerge.assertEquals((int)2, (int)a.getBs().size());
    }

    public void testMergeDetached() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        SimpleA a = (SimpleA)em.find(SimpleA.class, (Object)this.a_id);
        TestNoCascadeOneToManyMerge.assertNotNull((Object)a);
        TestNoCascadeOneToManyMerge.assertEquals((int)1, (int)a.getBs().size());
        em.close();
        SimpleB b = new SimpleB();
        b.setName("b2");
        a.addB(b);
        SimpleC c = new SimpleC();
        c.setName("c3");
        b.addC(c);
        c = new SimpleC();
        c.setName("c4");
        b.addC(c);
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        a = (SimpleA)em.merge((Object)a);
        em.getTransaction().commit();
        em.close();
        TestNoCascadeOneToManyMerge.assertEquals((int)2, (int)a.getBs().size());
    }

    public static void main(String[] args) {
        TestRunner.run(TestNoCascadeOneToManyMerge.class);
    }
}

