/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.discriminator;

import java.util.List;
import javax.persistence.Query;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.discriminator.CharAbstractEntity;
import org.apache.openjpa.persistence.discriminator.CharLeafEntity;
import org.apache.openjpa.persistence.discriminator.CharRootEntity;
import org.apache.openjpa.persistence.discriminator.IntegerAbstractEntity;
import org.apache.openjpa.persistence.discriminator.IntegerLeafEntity;
import org.apache.openjpa.persistence.discriminator.IntegerRootEntity;
import org.apache.openjpa.persistence.discriminator.StringAbstractEntity;
import org.apache.openjpa.persistence.discriminator.StringLeafEntity;
import org.apache.openjpa.persistence.discriminator.StringRootEntity;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestDiscriminatorTypes
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(CharAbstractEntity.class, CharLeafEntity.class, CharRootEntity.class, IntegerAbstractEntity.class, IntegerLeafEntity.class, IntegerRootEntity.class, StringAbstractEntity.class, StringLeafEntity.class, StringRootEntity.class, CLEAR_TABLES);
    }

    public void testCharDiscriminators() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Discriminator discrim = this.getMapping("CharAbstractEntity").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)new Character('C'), (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)2, (int)discrim.getJavaType());
        discrim = this.getMapping("chrLeaf").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)new Character('c'), (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)2, (int)discrim.getJavaType());
        discrim = this.getMapping("CharRootEntity").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)new Character('R'), (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)2, (int)discrim.getJavaType());
        CharLeafEntity leaf = new CharLeafEntity();
        CharRootEntity root = new CharRootEntity();
        em.getTransaction().begin();
        em.persist((Object)leaf);
        em.persist((Object)root);
        em.getTransaction().commit();
        em.refresh((Object)leaf);
        em.refresh((Object)root);
        em.clear();
        CharLeafEntity leaf2 = (CharLeafEntity)em.find(CharLeafEntity.class, (Object)leaf.getId());
        CharRootEntity root2 = (CharRootEntity)em.find(CharRootEntity.class, (Object)root.getId());
        TestDiscriminatorTypes.assertNotNull((Object)leaf2);
        TestDiscriminatorTypes.assertNotNull((Object)root2);
        em.close();
    }

    public void testIntDiscriminators() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Discriminator discrim = this.getMapping("IntegerAbstractEntity").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)new Integer("IntegerAbstractEntity".hashCode()), (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)5, (int)discrim.getJavaType());
        discrim = this.getMapping("intLeaf").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)new Integer("intLeaf".hashCode()), (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)5, (int)discrim.getJavaType());
        discrim = this.getMapping("IntegerRootEntity").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)new Integer(10101), (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)5, (int)discrim.getJavaType());
        IntegerLeafEntity leaf = new IntegerLeafEntity();
        IntegerRootEntity root = new IntegerRootEntity();
        em.getTransaction().begin();
        em.persist((Object)leaf);
        em.persist((Object)root);
        em.getTransaction().commit();
        em.refresh((Object)leaf);
        em.refresh((Object)root);
        em.clear();
        IntegerLeafEntity leaf2 = (IntegerLeafEntity)em.find(IntegerLeafEntity.class, (Object)leaf.getId());
        IntegerRootEntity root2 = (IntegerRootEntity)em.find(IntegerRootEntity.class, (Object)root.getId());
        TestDiscriminatorTypes.assertNotNull((Object)leaf2);
        TestDiscriminatorTypes.assertNotNull((Object)root2);
        em.close();
    }

    public void testStringDiscriminators() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Discriminator discrim = this.getMapping("StringAbstractEntity").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)"StringAbstractEntity", (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)9, (int)discrim.getJavaType());
        discrim = this.getMapping("strLeaf").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)"strLeaf", (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)9, (int)discrim.getJavaType());
        discrim = this.getMapping("StringRootEntity").getDiscriminator();
        TestDiscriminatorTypes.assertEquals((Object)"StringRoot", (Object)discrim.getValue());
        TestDiscriminatorTypes.assertEquals((int)9, (int)discrim.getJavaType());
        StringLeafEntity leaf = new StringLeafEntity();
        StringRootEntity root = new StringRootEntity();
        em.getTransaction().begin();
        em.persist((Object)leaf);
        em.persist((Object)root);
        em.getTransaction().commit();
        em.refresh((Object)leaf);
        em.refresh((Object)root);
        em.clear();
        StringLeafEntity leaf2 = (StringLeafEntity)em.find(StringLeafEntity.class, (Object)leaf.getId());
        StringRootEntity root2 = (StringRootEntity)em.find(StringRootEntity.class, (Object)root.getId());
        TestDiscriminatorTypes.assertNotNull((Object)leaf2);
        TestDiscriminatorTypes.assertNotNull((Object)root2);
        em.close();
    }

    public void testExistsQuery() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        StringRootEntity e = new StringRootEntity();
        e.setName("foo");
        em.persist((Object)e);
        e = new StringRootEntity();
        e.setName("foo");
        em.persist((Object)e);
        e = new StringRootEntity();
        e.setName("bar");
        em.persist((Object)e);
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        Query q = em.createQuery("select o from StringAbstractEntity o where exists (select o2 from StringLeafEntity o2)");
        List list = q.getResultList();
        TestDiscriminatorTypes.assertEquals((int)0, (int)list.size());
        for (StringAbstractEntity entity : list) {
            TestDiscriminatorTypes.assertTrue((boolean)(entity instanceof StringLeafEntity));
        }
        em.close();
    }
}

