/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed;

import java.util.List;
import javax.persistence.EntityTransaction;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.embed.Address;
import org.apache.openjpa.persistence.embed.BaseEntity;
import org.apache.openjpa.persistence.embed.Geocode;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestEmbedded
extends SQLListenerTestCase {
    @Override
    public void setUp() {
        super.setUp(BaseEntity.class, Address.class, Geocode.class, CLEAR_TABLES);
    }

    public void testInsertEmbedded() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        Address a = new Address();
        a.setStreetAddress("123 Main St");
        a.setCity("Chicago");
        a.setState("IL");
        a.setZip(60606);
        Geocode g = new Geocode();
        g.setLatitude(1.0f);
        g.setLongtitude(2.0f);
        a.setGeocode(g);
        em.persist((Object)a);
        em.getTransaction().commit();
        em.close();
    }

    public void testDetachedQueryEmbedded() {
        Address a = new Address();
        a.setStreetAddress("456 Main St");
        a.setCity("New York");
        a.setState("NY");
        a.setZip(12955);
        Geocode g = new Geocode();
        g.setLatitude(1.0f);
        g.setLongtitude(2.0f);
        a.setGeocode(g);
        this.persistAddress(a);
        Address a2 = this.queryAddresses("select address from Address address where address.streetAddress = '456 Main St'").get(0);
        TestEmbedded.assertEquals((Object)Float.valueOf(a2.getGeocode().getLatitude()), (Object)Float.valueOf(1.0f));
    }

    public void testDeleteEmbeddedDoesNotSelectBeforeDelete() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        String[] streets = new String[]{"S1", "S2", "S3"};
        String[] cities = new String[]{"C1", "C2", "C3"};
        String[] states = new String[]{"AB", "CD", "EF"};
        int[] zips = new int[]{123456, 345678, 456789};
        for (int i = 0; i < streets.length; ++i) {
            Address a = new Address();
            a.setStreetAddress(streets[i]);
            a.setCity(cities[i]);
            a.setState(states[i]);
            a.setZip(zips[i]);
            Geocode g = new Geocode();
            g.setLatitude((float)i + 1.0f);
            g.setLongtitude((float)i + 6.0f);
            a.setGeocode(g);
            em.persist((Object)a);
        }
        em.getTransaction().commit();
        em.close();
        em = this.emf.createEntityManager();
        em.getTransaction().begin();
        this.sql.clear();
        int count = em.createQuery("DELETE FROM Address a WHERE a.zip=:zip").setParameter("zip", (Object)zips[0]).executeUpdate();
        TestEmbedded.assertEquals((int)1, (int)count);
        em.getTransaction().commit();
        TestEmbedded.assertEquals((int)1, (int)this.sql.size());
        em.getTransaction().begin();
        this.sql.clear();
        count = em.createQuery("DELETE FROM Address").executeUpdate();
        TestEmbedded.assertEquals((int)(streets.length - 1), (int)count);
        TestEmbedded.assertTrue((count > 1 ? 1 : 0) != 0);
        em.getTransaction().commit();
        TestEmbedded.assertEquals((int)1, (int)this.sql.size());
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistAddress(Address address) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        try {
            em.persist((Object)address);
            tx.commit();
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
        TestEmbedded.assertEquals((Object)Float.valueOf(address.getGeocode().getLatitude()), (Object)Float.valueOf(1.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Address> queryAddresses(String query) {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        try {
            List list = em.createQuery(query).getResultList();
            tx.commit();
            List list2 = list;
            return list2;
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            em.close();
        }
    }
}

