/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed.attrOverrides;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.embed.attrOverrides.AbstractEmployee;
import org.apache.openjpa.persistence.embed.attrOverrides.Address;
import org.apache.openjpa.persistence.embed.attrOverrides.ContactInfo;
import org.apache.openjpa.persistence.embed.attrOverrides.EmergencyContactInfo;
import org.apache.openjpa.persistence.embed.attrOverrides.Employee;
import org.apache.openjpa.persistence.embed.attrOverrides.JobInfo;
import org.apache.openjpa.persistence.embed.attrOverrides.PartTimeEmployee;
import org.apache.openjpa.persistence.embed.attrOverrides.PhoneNumber;
import org.apache.openjpa.persistence.embed.attrOverrides.ProgramManager;
import org.apache.openjpa.persistence.embed.attrOverrides.Project;
import org.apache.openjpa.persistence.embed.attrOverrides.Zipcode;
import org.apache.openjpa.persistence.test.SQLListenerTestCase;

public class TestAssocOverrides
extends SQLListenerTestCase {
    public int numEmployees = 2;
    public int numPhoneNumbers = this.numEmployees + 1;
    public int numEmployeesPerPhoneNumber = 2;
    public int numPhoneNumbersPerEmployee = 2;
    public int numJobsPerEmployee = 2;
    public int empId = 1;
    public int phoneId = 1;
    public int addrId = 1;
    public int pmId = 1;
    public int peId = 1;
    public int pId = 1;

    @Override
    public void setUp() throws Exception {
        super.setUp(DROP_TABLES, Address.class, ContactInfo.class, EmergencyContactInfo.class, Employee.class, JobInfo.class, PhoneNumber.class, ProgramManager.class, Zipcode.class, AbstractEmployee.class, PartTimeEmployee.class, Project.class);
    }

    public void testAssocOverride1() {
        this.sql.clear();
        this.createObj1();
        this.findObj1();
        this.queryObj1();
        this.assertMappingOverrides("EMPPHONES");
        this.assertMappingOverrides("EMP_ATTROVER");
        this.assertMappingOverrides("EMP_ATTROVER_jobInfos");
    }

    public void testAssocOverride2() {
        this.sql.clear();
        this.createObj2();
        this.findObj2();
        this.queryObj2();
        this.assertMappingOverrides("PART_EMP_ASSOC");
        this.assertMappingOverrides("PART_EMP_PROJECTS");
    }

    public void createObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.createEmployee((EntityManager)em, this.empId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public Employee createEmployee(EntityManager em, int id) {
        Employee e = new Employee();
        e.setEmpId(id);
        ContactInfo contactInfo = new ContactInfo();
        for (int i = 0; i < this.numPhoneNumbersPerEmployee; ++i) {
            PhoneNumber phoneNumber = this.createPhoneNumber(em);
            contactInfo.addPhoneNumber(phoneNumber);
            e.setContactInfo(contactInfo);
            phoneNumber.addEmployees(e);
            em.persist((Object)phoneNumber);
        }
        Address addr = new Address();
        addr.setId(this.addrId++);
        addr.setCity("city_" + addr.getId());
        addr.setState("state_" + addr.getId());
        addr.setStreet("street_" + addr.getId());
        Zipcode zip = new Zipcode();
        zip.setZip("zip_" + addr.getId());
        zip.setPlusFour("+4_" + addr.getId());
        addr.setZipcode(zip);
        em.persist((Object)addr);
        contactInfo.setAddress(addr);
        EmergencyContactInfo ecInfo = new EmergencyContactInfo();
        ecInfo.setFName("fName_" + id);
        ecInfo.setLName("lName_" + id);
        for (int i = 5; i > 0; --i) {
            ecInfo.addNickName("nickName" + i);
        }
        Address eaddr = new Address();
        eaddr.setId(this.addrId++);
        eaddr.setCity("city_" + eaddr.getId());
        eaddr.setState("state_" + eaddr.getId());
        eaddr.setStreet("street_" + eaddr.getId());
        Zipcode ezip = new Zipcode();
        ezip.setZip("zip_" + eaddr.getId());
        ezip.setPlusFour("+4_" + eaddr.getId());
        eaddr.setZipcode(ezip);
        ecInfo.setAddress(eaddr);
        contactInfo.setEmergencyContactInfo(ecInfo);
        PhoneNumber phoneNumber = this.createPhoneNumber(em);
        ecInfo.setPhoneNumber(phoneNumber);
        em.persist((Object)eaddr);
        for (int i = 0; i < this.numJobsPerEmployee; ++i) {
            JobInfo job = new JobInfo();
            job.setJobDescription("job_" + id + "_" + i);
            ProgramManager pm = new ProgramManager();
            pm.setId(this.pmId++);
            pm.addManage(e);
            em.persist((Object)pm);
            job.setProgramManager(pm);
            e.addJobInfo(job);
        }
        em.persist((Object)e);
        return e;
    }

    public PhoneNumber createPhoneNumber(EntityManager em) {
        PhoneNumber p = new PhoneNumber();
        p.setPhNumber(this.phoneId++);
        em.persist((Object)p);
        return p;
    }

    public void findObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        Employee e = (Employee)em.find(Employee.class, (Object)1);
        this.assertEmployee(e);
        em.close();
    }

    public void queryObj1() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        Query q = em.createQuery("select e from Employee e");
        List es = q.getResultList();
        for (Employee e : es) {
            this.assertEmployee(e);
        }
        tran.commit();
        em.close();
    }

    public void assertEmployee(Employee e) {
        int id = e.getEmpId();
        ContactInfo c = e.getContactInfo();
        List<PhoneNumber> phones = c.getPhoneNumbers();
        for (PhoneNumber p : phones) {
            this.assertPhoneNumber(p, e.getEmpId());
        }
        Collection<String> nickNames = c.getEmergencyContactInfo().getNickNames();
        int i = 1;
        for (String nickName : nickNames) {
            TestAssocOverrides.assertEquals((String)("nickName" + i), (String)nickName);
            ++i;
        }
    }

    public void assertPhoneNumber(PhoneNumber p, int empId) {
        int number = p.getPhNumber();
        Collection<Employee> es = p.getEmployees();
        for (Employee e : es) {
            TestAssocOverrides.assertEquals((int)empId, (int)e.getEmpId());
        }
    }

    public void createObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        for (int i = 0; i < this.numEmployees; ++i) {
            this.createPartTimeEmployee((EntityManager)em, this.peId++);
        }
        tran.begin();
        em.flush();
        tran.commit();
        em.close();
    }

    public PartTimeEmployee createPartTimeEmployee(EntityManager em, int id) {
        PartTimeEmployee p = new PartTimeEmployee();
        p.setId(id);
        Address addr = new Address();
        addr.setId(id);
        addr.setCity("city_" + id);
        addr.setState("state_" + id);
        addr.setStreet("street_" + id);
        p.setAddress(addr);
        p.setHourlyWage(Float.valueOf(100.0f));
        Project project = new Project();
        project.setId(this.pId++);
        project.setDescription("p_" + project.getId());
        p.addProject(project);
        em.persist((Object)addr);
        em.persist((Object)p);
        em.persist((Object)project);
        return p;
    }

    public void findObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        PartTimeEmployee p = (PartTimeEmployee)em.find(PartTimeEmployee.class, (Object)1);
        Assert.assertEquals((Object)p.getHourlyWage(), (Object)Float.valueOf(100.0f));
        em.close();
    }

    public void queryObj2() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        String firstName = "f_1";
        String jpql = "select p from PartTimeEmployee p";
        Query q = em.createQuery(jpql);
        List ps = q.getResultList();
        Assert.assertEquals((int)ps.size(), (int)this.numEmployees);
        tran.commit();
        em.close();
    }

    public void assertMappingOverrides(String tableName) {
        boolean found = false;
        for (String sqlStr : this.sql) {
            String key;
            if (sqlStr.indexOf(key = "CREATE TABLE " + tableName + " ") == -1) continue;
            if (tableName.equals("EMPPHONES")) {
                if (sqlStr.indexOf("EMP") == -1 || sqlStr.indexOf("PHONE") == -1) {
                    TestAssocOverrides.fail();
                }
                found = true;
                break;
            }
            if (tableName.equals("EMP_ATTROVER")) {
                if (sqlStr.indexOf("EMP_ADDR") == -1 || sqlStr.indexOf("EMERGENCY_FNAME") == -1 || sqlStr.indexOf("EMERGENCY_LNAME") == -1 || sqlStr.indexOf("EMERGENCY_ADDR") == -1 || sqlStr.indexOf("EMERGENCY_PHONE") == -1) {
                    TestAssocOverrides.fail();
                }
                found = true;
                break;
            }
            if (tableName.equals("EMP_ATTROVER_jobInfos")) {
                if (sqlStr.indexOf("JOB_KEY") == -1 || sqlStr.indexOf("JOB_DESC") == -1 || sqlStr.indexOf("PROGRAM_MGR") == -1) {
                    TestAssocOverrides.fail();
                }
                found = true;
                break;
            }
            if (tableName.equals("PART_EMP_ASSOC")) {
                if (sqlStr.indexOf("ADDR_ID") == -1) {
                    TestAssocOverrides.fail();
                }
                found = true;
                break;
            }
            if (!tableName.equals("PART_EMP_PROJECTS")) break;
            if (sqlStr.indexOf("PART_EMP") == -1 || sqlStr.indexOf("PROJECT_ID") == -1) {
                TestAssocOverrides.fail();
            }
            found = true;
            break;
        }
        if (!found) {
            TestAssocOverrides.fail();
        }
    }
}

