/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.embed.lazy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.lib.jdbc.AbstractJDBCListener;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.embed.lazy.BeverageHolder;
import org.apache.openjpa.persistence.embed.lazy.Guy;
import org.apache.openjpa.persistence.embed.lazy.Recliner;
import org.apache.openjpa.persistence.embed.lazy.ReclinerId;
import org.apache.openjpa.persistence.embed.lazy.Style;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestLazyEmbeddable
extends AbstractPersistenceTestCase {
    protected List<String> _sql = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyEmbeddableFields() throws Exception {
        this._sql.clear();
        HashMap<String, JDBCListener[]> props = new HashMap<String, JDBCListener[]>();
        props.put("openjpa.jdbc.JDBCListeners", new JDBCListener[]{new SQLListener()});
        OpenJPAEntityManagerFactorySPI emf1 = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.createEntityManagerFactory((String)"LazyEmbedPU", (String)"org/apache/openjpa/persistence/embed/lazy/embed-lazy-persistence.xml", props);
        try {
            OpenJPAEntityManagerSPI em = emf1.createEntityManager();
            Recliner rec = new Recliner();
            ReclinerId recId = new ReclinerId();
            recId.setColor("Camouflage");
            recId.setId(new Random().nextInt());
            rec.setId(recId);
            rec.setStyle(Style.RETRO);
            Guy guy = new Guy();
            guy.setName("Tom");
            guy.setHeight(76);
            guy.setWeight(275);
            rec.setGuy(guy);
            BeverageHolder bh = new BeverageHolder();
            bh.setDepth(2);
            bh.setDiameter(3);
            rec.setHolder(bh);
            em.getTransaction().begin();
            em.persist((Object)rec);
            em.getTransaction().commit();
            em.clear();
            this._sql.clear();
            Recliner r2 = (Recliner)em.find(Recliner.class, (Object)recId);
            TestLazyEmbeddable.assertNotNull((String)"Find returned null object", (Object)r2);
            TestLazyEmbeddable.assertTrue((boolean)this.selectContains("REC_TABLE", this._sql, "REC_STYLE", "RECID_ID", "RECID_COLOR"));
            TestLazyEmbeddable.assertFalse((boolean)this.selectContains("REC_TABLE", this._sql, "GUY_HEIGHT", "GUY_WEIGHT", "GUY_NAME", "BH_DIAMETER", "BH_DEPTH"));
            em.detach((Object)r2);
            TestLazyEmbeddable.assertNull((String)"Embedded field guy is null before getter is called", (Object)r2.getGuy());
            TestLazyEmbeddable.assertNull((String)"Embedded field holder is null before getter is called", (Object)r2.getHolder());
            r2 = (Recliner)em.merge((Object)r2);
            this.verifyLazyLoading(r2);
            em.clear();
            this._sql.clear();
            r2 = (Recliner)em.find(Recliner.class, (Object)recId);
            TestLazyEmbeddable.assertNotNull((String)"Find returned null object", (Object)r2);
            TestLazyEmbeddable.assertTrue((boolean)this.selectContains("REC_TABLE", this._sql, "REC_STYLE", "RECID_ID", "RECID_COLOR"));
            TestLazyEmbeddable.assertFalse((boolean)this.selectContains("REC_TABLE", this._sql, "GUY_HEIGHT", "GUY_WEIGHT", "GUY_NAME", "BH_DIAMETER", "BH_DEPTH"));
            this.verifyLazyLoading(r2);
        }
        finally {
            this.cleanupEMF(emf1);
        }
    }

    private void verifyLazyLoading(Recliner r2) {
        this._sql.clear();
        Guy g = r2.getGuy();
        TestLazyEmbeddable.assertNotNull((String)"Guy is not null", (Object)g);
        TestLazyEmbeddable.assertTrue((boolean)this.selectContains("REC_TABLE", this._sql, "GUY_NAME"));
        TestLazyEmbeddable.assertFalse((boolean)this.selectContains("REC_TABLE", this._sql, "GUY_HEIGHT", "GUY_WEIGHT"));
        this._sql.clear();
        g.getHeight();
        TestLazyEmbeddable.assertTrue((boolean)this.selectContains("REC_TABLE", this._sql, "GUY_HEIGHT"));
        TestLazyEmbeddable.assertFalse((boolean)this.selectContains("REC_TABLE", this._sql, "GUY_NAME", "GUY_WEIGHT", "BH_DIAMETER", "BH_DEPTH"));
        this._sql.clear();
        BeverageHolder holder = r2.getHolder();
        TestLazyEmbeddable.assertNotNull((String)"Holder is not null", (Object)holder);
        TestLazyEmbeddable.assertTrue((boolean)this.selectContains("REC_TABLE", this._sql, "BH_DEPTH"));
        TestLazyEmbeddable.assertFalse((boolean)this.selectContains("REC_TABLE", this._sql, "BH_DIAMETER"));
        this._sql.clear();
        holder.getDiameter();
        TestLazyEmbeddable.assertTrue((boolean)this.selectContains("REC_TABLE", this._sql, "BH_DIAMETER"));
        TestLazyEmbeddable.assertFalse((boolean)this.selectContains("REC_TABLE", this._sql, "BH_DEPTH"));
    }

    private boolean selectContains(String table, List<String> sql, String ... cols) {
        boolean foundSelect = false;
        for (String s : sql) {
            String stmt = s.toUpperCase();
            if (!stmt.startsWith("SELECT") && !stmt.contains(table)) continue;
            foundSelect = true;
            for (String col : cols) {
                String ucol = col.toUpperCase();
                if (stmt.contains(ucol)) continue;
                return false;
            }
        }
        return foundSelect;
    }

    private static String toString(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String s : list) {
            buf.append(s).append("\r\n");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupEMF(OpenJPAEntityManagerFactorySPI emf1) throws Exception {
        if (emf1 == null) {
            return;
        }
        try {
            this.clear((EntityManagerFactory)emf1);
        }
        catch (Exception e) {
            if (this.testResult.wasSuccessful()) {
                throw e;
            }
        }
        finally {
            this.closeEMF((EntityManagerFactory)emf1);
        }
    }

    public class SQLListener
    extends AbstractJDBCListener {
        public void beforeExecuteStatement(JDBCEvent event) {
            if (event.getSQL() != null && TestLazyEmbeddable.this._sql != null) {
                TestLazyEmbeddable.this._sql.add(event.getSQL());
            }
        }
    }
}

