/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.enhance;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.AssertionFailedError;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.enhance.common.apps.BackingFieldNameMismatchInstance;
import org.apache.openjpa.persistence.enhance.common.apps.BaseEntity;
import org.apache.openjpa.persistence.enhance.common.apps.BasicSubclassInstance;
import org.apache.openjpa.persistence.enhance.common.apps.DerivedEntity;
import org.apache.openjpa.persistence.enhance.common.apps.Entity1;
import org.apache.openjpa.persistence.enhance.common.apps.ManagedInverseTestInstance;
import org.apache.openjpa.persistence.enhance.common.apps.ManagedInverseTestInstance2;
import org.apache.openjpa.persistence.enhance.common.apps.SubclassTestInstance;
import org.apache.openjpa.util.ExceptionInfo;
import org.apache.openjpa.util.ImplHelper;

public class TestSubclassedBehavior
extends AbstractTestCase {
    public TestSubclassedBehavior(String name) {
        super(name, "enhancecactusapp");
    }

    public void setUp() {
        this.deleteAll(BasicSubclassInstance.class);
        this.deleteAll(BackingFieldNameMismatchInstance.class);
        this.deleteAll(BaseEntity.class);
        this.deleteAll(ManagedInverseTestInstance.class);
        this.deleteAll(ManagedInverseTestInstance2.class);
    }

    public void testInheritance() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        DerivedEntity de = (DerivedEntity)this.newInstance(pm, DerivedEntity.class);
        BasicSubclassInstance basic = (BasicSubclassInstance)this.newInstance(pm, BasicSubclassInstance.class);
        basic.setStringField("basic one-to-one");
        de.setOneToOne(basic);
        Object oid = this.persistenceOperations(pm, de, false);
        ClassMetaData meta = JPAFacadeHelper.getMetaData((EntityManager)pm, de.getClass());
        TestSubclassedBehavior.assertEquals(BaseEntity.class, (Object)meta.getPCSuperclass());
        pm = this.currentEntityManager();
        Object o = pm.find(DerivedEntity.class, oid);
        TestSubclassedBehavior.assertTrue((boolean)(o instanceof DerivedEntity));
        de = (DerivedEntity)o;
        Broker b = JPAFacadeHelper.toBroker((EntityManager)pm);
        OpenJPAStateManager sm = b.getStateManager((Object)de);
        TestSubclassedBehavior.assertFalse((boolean)sm.getLoaded().get(sm.getMetaData().getField("oneToOne").getIndex()));
        TestSubclassedBehavior.assertEquals((String)"basic one-to-one", (String)de.getOneToOne().getStringField());
        TestSubclassedBehavior.assertTrue((boolean)sm.getLoaded().get(sm.getMetaData().getField("oneToOne").getIndex()));
        this.startTx((EntityManager)pm);
        pm.remove((Object)de);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testBasicSubclassPersistenceOperations() throws ClassNotFoundException {
        OpenJPAEntityManager pm = this.currentEntityManager();
        BasicSubclassInstance o = (BasicSubclassInstance)this.newInstance(pm, BasicSubclassInstance.class);
        this.persistenceOperations(pm, o, true);
    }

    public void testBackingFieldNameMismatch() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        BackingFieldNameMismatchInstance o = (BackingFieldNameMismatchInstance)this.newInstance(pm, BackingFieldNameMismatchInstance.class);
        this.persistenceOperations(pm, o, true);
    }

    private Object newInstance(OpenJPAEntityManager pm, Class cls) {
        return pm.createInstance(cls);
    }

    private Object createInstance(EntityManager em, Class cls) {
        return ((OpenJPAEntityManager)em).createInstance(cls);
    }

    private Object persistenceOperations(OpenJPAEntityManager pm, SubclassTestInstance o, boolean delete) {
        this.startTx((EntityManager)pm);
        pm.persist((Object)o);
        o.setStringField("new persistent instance");
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)o);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        o = (SubclassTestInstance)pm.find(SubclassTestInstance.class, oid);
        TestSubclassedBehavior.assertEquals((String)"new persistent instance", (String)o.getStringField());
        this.startTx((EntityManager)pm);
        o.setStringField("modified persistent instance");
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        if (delete) {
            pm = this.currentEntityManager();
            o = (SubclassTestInstance)pm.find(SubclassTestInstance.class, oid);
            TestSubclassedBehavior.assertEquals((String)"modified persistent instance", (String)o.getStringField());
            this.startTx((EntityManager)pm);
            pm.remove((Object)o);
            this.endTx((EntityManager)pm);
            this.endEm((EntityManager)pm);
            return null;
        }
        return oid;
    }

    public void testPolymorphicQueries() {
        this.deleteAll(BaseEntity.class);
        this.deleteAll(BasicSubclassInstance.class);
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        BaseEntity be = (BaseEntity)this.newInstance(pm, BaseEntity.class);
        be.setShortField((short)0);
        pm.persist((Object)be);
        be = (BaseEntity)this.newInstance(pm, BaseEntity.class);
        be.setShortField((short)1);
        pm.persist((Object)be);
        DerivedEntity de = (DerivedEntity)this.newInstance(pm, DerivedEntity.class);
        de.setShortField((short)2);
        de.setOneToOne((BasicSubclassInstance)this.newInstance(pm, BasicSubclassInstance.class));
        pm.persist((Object)de);
        de = (DerivedEntity)this.newInstance(pm, DerivedEntity.class);
        de.setShortField((short)3);
        de.setOneToOne((BasicSubclassInstance)this.newInstance(pm, BasicSubclassInstance.class));
        pm.persist((Object)de);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        OpenJPAQuery q = pm.createQuery("SELECT a FROM BaseEntity a ORDER BY a.shortField ASC");
        List l = q.getResultList();
        TestSubclassedBehavior.assertEquals((int)4, (int)l.size());
        TestSubclassedBehavior.assertEquals((int)0, (int)((BaseEntity)l.get(0)).getShortField());
        TestSubclassedBehavior.assertEquals((int)1, (int)((BaseEntity)l.get(1)).getShortField());
        TestSubclassedBehavior.assertEquals((int)2, (int)((BaseEntity)l.get(2)).getShortField());
        TestSubclassedBehavior.assertEquals((int)3, (int)((BaseEntity)l.get(3)).getShortField());
        TestSubclassedBehavior.assertTrue((boolean)(l.get(2) instanceof DerivedEntity));
        TestSubclassedBehavior.assertTrue((boolean)(l.get(3) instanceof DerivedEntity));
        this.endEm((EntityManager)pm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnhancedClassChangesOutsideTxWithoutNTW() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.startTx((EntityManager)pm);
        this.deleteAll(Entity1.class);
        this.endTx((EntityManager)pm);
        Entity1 o = new Entity1(8L, "pk 8", 4);
        this.startTx((EntityManager)pm);
        pm.persist((Object)o);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)o);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        o = (Entity1)pm.find(Entity1.class, oid);
        try {
            o.setStringField("hello");
            TestSubclassedBehavior.fail((String)"non-transactional write should not be allowed");
        }
        catch (Exception e) {
        }
        finally {
            this.endEm((EntityManager)pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubclassChangesOutsideTxWithoutNTW() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        BasicSubclassInstance basic = (BasicSubclassInstance)this.newInstance(pm, BasicSubclassInstance.class);
        basic.setStringField("foo");
        this.startTx((EntityManager)pm);
        pm.persist((Object)basic);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)basic);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        basic = (BasicSubclassInstance)pm.find(BasicSubclassInstance.class, oid);
        try {
            basic.setStringField("hello");
            TestSubclassedBehavior.fail((String)"non-transactional write should not be allowed");
        }
        catch (Exception e) {
        }
        finally {
            this.endEm((EntityManager)pm);
        }
    }

    public void testBasicPMUses() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        Broker broker = JPAFacadeHelper.toBroker((EntityManager)pm);
        this.startTx((EntityManager)pm);
        BasicSubclassInstance basic = (BasicSubclassInstance)this.newInstance(pm, BasicSubclassInstance.class);
        TestSubclassedBehavior.assertTrue((boolean)ImplHelper.isManageable((Object)basic));
        basic.setStringField("foo");
        pm.persist((Object)basic);
        TestSubclassedBehavior.assertTrue((boolean)broker.isNew((Object)basic));
        TestSubclassedBehavior.assertTrue((boolean)broker.isPersistent((Object)basic));
        this.endTx((EntityManager)pm);
        TestSubclassedBehavior.assertFalse((boolean)broker.isNew((Object)basic));
        OpenJPAStateManager sm = broker.getStateManager((Object)basic);
        TestSubclassedBehavior.assertNotNull((Object)sm);
        TestSubclassedBehavior.assertEquals((Object)sm.getManagedInstance(), (Object)basic);
        FieldMetaData fmd = sm.getMetaData().getField("stringField");
        TestSubclassedBehavior.assertEquals((Object)"foo", (Object)sm.fetch(fmd.getIndex()));
        TestSubclassedBehavior.assertTrue((boolean)sm.getLoaded().get(fmd.getIndex()));
        pm.evict((Object)basic);
        TestSubclassedBehavior.assertFalse((boolean)sm.getLoaded().get(fmd.getIndex()));
        TestSubclassedBehavior.assertNotNull((Object)basic.getStringField());
        TestSubclassedBehavior.assertEquals((Object)"foo", (Object)sm.fetch(fmd.getIndex()));
        TestSubclassedBehavior.assertEquals((String)"foo", (String)basic.getStringField());
        TestSubclassedBehavior.assertTrue((boolean)sm.getLoaded().get(fmd.getIndex()));
        this.startTx((EntityManager)pm);
        basic.setStringField("bar");
        TestSubclassedBehavior.assertTrue((boolean)broker.isDirty((Object)basic));
        this.endTx((EntityManager)pm);
        Object oid = broker.getObjectId((Object)basic);
        TestSubclassedBehavior.assertNotNull((Object)oid);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        basic = (BasicSubclassInstance)pm.find(BasicSubclassInstance.class, oid);
        TestSubclassedBehavior.assertEquals((String)"bar", (String)basic.getStringField());
        this.startTx((EntityManager)pm);
        pm.remove((Object)basic);
        TestSubclassedBehavior.assertTrue((boolean)JPAFacadeHelper.toBroker((EntityManager)pm).isDeleted((Object)basic));
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
    }

    public void testGetObjectId() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        BasicSubclassInstance basic = new BasicSubclassInstance();
        basic.setStringField("foo");
        this.startTx((EntityManager)pm);
        pm.persist((Object)basic);
        this.endTx((EntityManager)pm);
        Object oid = null;
        try {
            oid = pm.getObjectId((Object)basic);
            TestSubclassedBehavior.assertNotNull((Object)oid);
        }
        catch (Exception e) {
            TestSubclassedBehavior.fail((String)("object id lookup failed: " + e.getMessage()));
        }
        this.startTx((EntityManager)pm);
        pm.remove((Object)basic);
        TestSubclassedBehavior.assertNotNull((Object)pm.getObjectId((Object)basic));
        this.endTx((EntityManager)pm);
        TestSubclassedBehavior.assertNull((Object)pm.getObjectId((Object)basic));
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        try {
            pm.find(BasicSubclassInstance.class, oid);
            TestSubclassedBehavior.fail((String)"instance should have been deleted!");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.endEm((EntityManager)pm);
    }

    public void testChangesOutsideTxWithNTW() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        BasicSubclassInstance basic = new BasicSubclassInstance();
        basic.setStringField("foo");
        this.startTx((EntityManager)pm);
        pm.persist((Object)basic);
        this.endTx((EntityManager)pm);
        Object oid = pm.getObjectId((Object)basic);
        this.endEm((EntityManager)pm);
        pm = this.getNTWPM();
        basic = (BasicSubclassInstance)pm.find(BasicSubclassInstance.class, oid);
        basic.setStringField("hello");
        this.startTx((EntityManager)pm);
        this.endTx((EntityManager)pm);
        this.endEm((EntityManager)pm);
        pm = this.currentEntityManager();
        basic = (BasicSubclassInstance)pm.find(BasicSubclassInstance.class, oid);
        try {
            TestSubclassedBehavior.assertEquals((String)"hello", (String)basic.getStringField());
        }
        catch (AssertionFailedError afe) {
            this.bug(1205, afe, "JDO 2-style NTW not supported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangesOutsideTxWithoutNTW() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        BasicSubclassInstance basic = new BasicSubclassInstance();
        basic.setStringField("foo");
        this.startTx((EntityManager)pm);
        pm.persist((Object)basic);
        this.endTx((EntityManager)pm);
        try {
            basic.setStringField("hello");
            TestSubclassedBehavior.fail((String)"should not be able to write outside tx without NTW");
        }
        catch (RuntimeException re) {
            Object failed = ((ExceptionInfo)re).getFailedObject();
            TestSubclassedBehavior.assertNotNull((Object)failed);
            TestSubclassedBehavior.assertSame((Object)basic, (Object)failed);
        }
        finally {
            this.endEm((EntityManager)pm);
        }
    }

    private OpenJPAEntityManager getNTWPM() {
        OpenJPAEntityManagerFactory pmf = this.getEmf();
        OpenJPAEntityManager em = (OpenJPAEntityManager)pmf.createEntityManager();
        em.setNontransactionalWrite(true);
        return em;
    }

    public void testVersionIncrementAndIdField() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        BasicSubclassInstance basic = new BasicSubclassInstance();
        basic.setStringField("foo");
        this.startTx((EntityManager)pm);
        pm.persist((Object)basic);
        this.endTx((EntityManager)pm);
        TestSubclassedBehavior.assertEquals((int)1, (int)basic.getVersion());
        long id = basic.getId();
        TestSubclassedBehavior.assertNotEquals(0, id);
        this.startTx((EntityManager)pm);
        basic.setStringField("bar");
        this.endTx((EntityManager)pm);
        TestSubclassedBehavior.assertEquals((int)2, (int)basic.getVersion());
        this.endEm((EntityManager)pm);
    }

    public void testJPABasics() {
        OpenJPAEntityManager em = this.currentEntityManager();
        BasicSubclassInstance basic = (BasicSubclassInstance)this.createInstance((EntityManager)em, BasicSubclassInstance.class);
        basic.setStringField("hello");
        this.startTx((EntityManager)em);
        em.persist((Object)basic);
        this.endTx((EntityManager)em);
        this.endEm((EntityManager)em);
    }

    public void testSingleValuedInverseManagement() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.InverseManager", "true");
        OpenJPAEntityManager pm = this.getEmf(map).createEntityManager();
        ManagedInverseTestInstance managed = (ManagedInverseTestInstance)this.newInstance(pm, ManagedInverseTestInstance.class);
        ManagedInverseTestInstance2 managed2 = (ManagedInverseTestInstance2)this.newInstance(pm, ManagedInverseTestInstance2.class);
        managed.setStringField("managed");
        managed2.setStringField("managed2");
        managed.setManaged2(managed2);
        this.startTx((EntityManager)pm);
        pm.persist((Object)managed);
        this.endTx((EntityManager)pm);
        TestSubclassedBehavior.assertSame((Object)managed, (Object)managed2.getManaged());
    }

    public void testBackingFieldConfigurationWithTwoFactories() {
        OpenJPAEntityManager pm = this.currentEntityManager();
        this.newInstance(pm, DerivedEntity.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.Log", "DiagnosticContext=subclass-two-factories-test");
        pm = this.getEmf(map).createEntityManager();
        this.newInstance(pm, DerivedEntity.class);
        ClassMetaData meta = this.getConfiguration().getMetaDataRepositoryInstance().getMetaData(DerivedEntity.class, null, false);
        TestSubclassedBehavior.assertTrue((String)"meta's access should be ACCESS_PROPERTY", (boolean)AccessCode.isProperty((int)meta.getAccessType()));
        FieldMetaData[] fmds = meta.getFields();
        for (int i = 0; i < fmds.length; ++i) {
            TestSubclassedBehavior.assertEquals(Method.class, fmds[i].getBackingMember().getClass());
            if (fmds[i].getName().equals("intField") || fmds[i].getName().equals("oneToOne")) {
                TestSubclassedBehavior.assertEquals(DerivedEntity.class, (Object)fmds[i].getDefiningMetaData().getDescribedType());
                continue;
            }
            TestSubclassedBehavior.assertEquals(BaseEntity.class, (Object)fmds[i].getDefiningMetaData().getDescribedType());
        }
    }
}

