/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.openjpa.event.JMSRemoteCommitProvider;
import org.apache.openjpa.persistence.event.RemoteEventBase;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;

public class JMSRemoteEventsTest
extends RemoteEventBase {
    public JMSRemoteEventsTest(String s) {
        super(s);
    }

    @Override
    public void setUp() {
        this.deleteAll(RuntimeTest1.class);
    }

    public void testJMSEvents() {
        this.doTest(JMSRemoteCommitProvider.class, "Topic=topic/KodoCommitProviderTopic", "Topic=topic/KodoCommitProviderTopic");
    }

    public static void main(String[] args) throws Exception {
        InitialContext ctx = new InitialContext();
        TopicConnectionFactory tcf = (TopicConnectionFactory)ctx.lookup("java:/ConnectionFactory");
        Topic topic = (Topic)ctx.lookup("topic/KodoCommitProviderTopic");
        ctx.close();
        TopicConnection connection = tcf.createTopicConnection();
        TopicSession session = connection.createTopicSession(false, 1);
        TopicSubscriber s = session.createSubscriber(topic, null, false);
        s.setMessageListener((MessageListener)new DebugMessageListener());
        connection.start();
        System.out.println("started listening on topic/KodoCommitProviderTopic");
    }

    private static class DebugMessageListener
    implements MessageListener {
        private DebugMessageListener() {
        }

        public void onMessage(Message m) {
            try {
                if (m instanceof ObjectMessage) {
                    ObjectMessage om = (ObjectMessage)m;
                    System.out.println("received object: " + om.getObject());
                } else {
                    System.out.println("received bad message: " + m);
                }
            }
            catch (JMSException e) {
                System.out.println("Exception while processing message");
                e.printStackTrace(System.out);
            }
        }
    }
}

