/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.event.TransactionListener;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.jdbc.sql.SybaseDictionary;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.event.AnEntity;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestBeforeCommit
extends AbstractPersistenceTestCase
implements TransactionListener {
    AnEntity ae = null;
    public final int PKID = 2;
    private DBDictionary dict = null;
    private static OpenJPAEntityManagerFactorySPI emf = null;

    public void setUp() throws Exception {
        if (emf == null) {
            emf = this.createEMF(AnEntity.class);
        }
        this.dict = ((JDBCConfiguration)emf.getConfiguration()).getDBDictionaryInstance();
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        tran.begin();
        em.createQuery("Delete from AnEntity").executeUpdate();
        tran.commit();
        tran.begin();
        this.ae = new AnEntity();
        this.ae.setId(2);
        this.ae.setName("");
        em.persist((Object)this.ae);
        tran.commit();
        em.close();
    }

    @Override
    public void tearDown() throws Exception {
        this.closeEMF((EntityManagerFactory)emf);
        emf = null;
        super.tearDown();
    }

    public void testQuery() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.addTransactionListener((Object)this);
        OpenJPAEntityTransaction tran = em.getTransaction();
        tran.begin();
        this.ae = this.doQuery((EntityManager)em);
        if (this.dict instanceof OracleDictionary) {
            TestBeforeCommit.assertNull((Object)this.ae.getName());
        } else if (this.dict instanceof SybaseDictionary) {
            TestBeforeCommit.assertEquals((String)" ", (String)this.ae.getName());
        } else {
            TestBeforeCommit.assertEquals((String)"", (String)this.ae.getName());
        }
        TestBeforeCommit.assertEquals((int)1, (int)this.ae.getVersion());
        tran.commit();
        this.ae = this.doQuery((EntityManager)em);
        TestBeforeCommit.assertEquals((String)"Ava", (String)this.ae.getName());
        TestBeforeCommit.assertEquals((int)2, (int)this.ae.getVersion());
        em.clear();
        this.ae = (AnEntity)em.find(AnEntity.class, (Object)2);
        TestBeforeCommit.assertEquals((String)"Ava", (String)this.ae.getName());
        TestBeforeCommit.assertEquals((int)2, (int)this.ae.getVersion());
        tran.begin();
        tran.commit();
        em.clear();
        this.ae = (AnEntity)em.find(AnEntity.class, (Object)2);
        TestBeforeCommit.assertEquals((String)"AvaAva", (String)this.ae.getName());
        TestBeforeCommit.assertEquals((int)3, (int)this.ae.getVersion());
        em.close();
    }

    public void testEmptyTransaction() {
        OpenJPAEntityManagerSPI em = emf.createEntityManager();
        em.addTransactionListener((Object)this);
        OpenJPAEntityTransaction tran = em.getTransaction();
        this.ae = this.doQuery((EntityManager)em);
        if (this.dict instanceof OracleDictionary) {
            TestBeforeCommit.assertNull((Object)this.ae.getName());
        } else if (this.dict instanceof SybaseDictionary) {
            TestBeforeCommit.assertEquals((String)" ", (String)this.ae.getName());
        } else {
            TestBeforeCommit.assertEquals((String)"", (String)this.ae.getName());
        }
        TestBeforeCommit.assertEquals((int)1, (int)this.ae.getVersion());
        em.clear();
        tran.begin();
        tran.commit();
        TestBeforeCommit.assertEquals((String)"Ava", (String)this.ae.getName());
        this.ae = this.doQuery((EntityManager)em);
        if (this.dict instanceof OracleDictionary) {
            TestBeforeCommit.assertNull((Object)this.ae.getName());
        } else if (this.dict instanceof SybaseDictionary) {
            TestBeforeCommit.assertEquals((String)" ", (String)this.ae.getName());
        } else {
            TestBeforeCommit.assertEquals((String)"", (String)this.ae.getName());
        }
        TestBeforeCommit.assertEquals((int)1, (int)this.ae.getVersion());
        em.close();
    }

    public void beforeCommit(TransactionEvent event) {
        if (StringUtils.isBlank((String)this.ae.getName())) {
            this.ae.setName("Ava");
        } else {
            this.ae.setName(this.ae.getName() + "Ava");
        }
    }

    private AnEntity doQuery(EntityManager em) {
        Query q = em.createQuery("select a from AnEntity a where a.id = :id");
        return (AnEntity)q.setParameter("id", (Object)2).getSingleResult();
    }

    public void afterBegin(TransactionEvent event) {
    }

    public void afterFlush(TransactionEvent event) {
    }

    public void beforeFlush(TransactionEvent event) {
    }

    public void afterCommit(TransactionEvent event) {
    }

    public void afterCommitComplete(TransactionEvent event) {
    }

    public void afterRollback(TransactionEvent event) {
    }

    public void afterRollbackComplete(TransactionEvent event) {
    }

    public void afterStateTransitions(TransactionEvent event) {
    }
}

