/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.event.LoadListener;
import org.apache.openjpa.event.StoreListener;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.common.utils.AbstractTestCase;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest1;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest2;
import org.apache.openjpa.persistence.event.common.apps.RuntimeTest4;
import org.apache.openjpa.persistence.test.AllowFailure;

@AllowFailure(message="surefire excluded")
public class TestLifecycleEventManager
extends AbstractTestCase {
    public TestLifecycleEventManager(String s) {
        super(s, "eventcactusapp");
    }

    public void testAllClassListener() {
        MetaDataRepository repos = ((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)OpenJPAPersistence.createEntityManagerFactory((String)"TestConv2", (String)""))).getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getMetaData(RuntimeTest2.class, null, true);
        LifecycleEventManager mgr = new LifecycleEventManager();
        RuntimeTest2 pc = new RuntimeTest2();
        Listener listener = new Listener();
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasStoreListeners((Object)pc, meta));
        mgr.addListener((Object)listener, null);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasStoreListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasDirtyListeners((Object)pc, meta));
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        Listener listener2 = new Listener();
        mgr.addListener((Object)listener2, null);
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasStoreListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasDirtyListeners((Object)pc, meta));
        mgr.fireEvent((Object)pc, meta, 2);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.preStore);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.removeListener((Object)listener2);
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasStoreListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasDirtyListeners((Object)pc, meta));
        mgr.fireEvent((Object)pc, meta, 2);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.preStore);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.fireEvent((Object)pc, meta, 4);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.preStore);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.fireEvent((Object)pc, meta, 3);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.preStore);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.fireEvent((Object)pc, meta, 10);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.store);
        mgr.removeListener((Object)listener);
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasStoreListeners((Object)pc, meta));
        mgr.fireEvent((Object)pc, meta, 4);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.store);
    }

    public void testBaseClassListener() {
        MetaDataRepository repos = ((OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)OpenJPAPersistence.createEntityManagerFactory((String)"TestConv2", (String)""))).getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getMetaData(RuntimeTest2.class, null, true);
        LifecycleEventManager mgr = new LifecycleEventManager();
        RuntimeTest2 pc = new RuntimeTest2();
        Listener listener = new Listener();
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasStoreListeners((Object)pc, meta));
        mgr.addListener((Object)listener, new Class[]{RuntimeTest1.class});
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasStoreListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasDirtyListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasLoadListeners((Object)new RuntimeTest4("foo"), meta));
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        Listener listener2 = new Listener();
        mgr.addListener((Object)listener2, new Class[]{RuntimeTest2.class});
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasStoreListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasDirtyListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasLoadListeners((Object)new RuntimeTest4("foo"), meta));
        mgr.fireEvent((Object)pc, meta, 2);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.fireEvent((Object)pc, meta, 2);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.fireEvent((Object)new RuntimeTest1(), meta, 2);
        TestLifecycleEventManager.assertEquals((int)3, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.removeListener((Object)listener2);
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertTrue((boolean)mgr.hasStoreListeners((Object)pc, meta));
        mgr.fireEvent((Object)pc, meta, 4);
        TestLifecycleEventManager.assertEquals((int)3, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.store);
        TestLifecycleEventManager.assertEquals((int)2, (int)listener2.load);
        TestLifecycleEventManager.assertEquals((int)0, (int)listener2.store);
        mgr.fireEvent((Object)pc, meta, 10);
        TestLifecycleEventManager.assertEquals((int)3, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.store);
        mgr.fireEvent((Object)new RuntimeTest4("foo"), meta, 4);
        TestLifecycleEventManager.assertEquals((int)3, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.store);
        mgr.removeListener((Object)listener);
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasLoadListeners((Object)pc, meta));
        TestLifecycleEventManager.assertFalse((boolean)mgr.hasStoreListeners((Object)pc, meta));
        mgr.fireEvent((Object)pc, meta, 4);
        TestLifecycleEventManager.assertEquals((int)3, (int)listener.load);
        TestLifecycleEventManager.assertEquals((int)1, (int)listener.store);
    }

    private static class Listener
    implements LoadListener,
    StoreListener {
        public int load = 0;
        public int preStore = 0;
        public int store = 0;

        private Listener() {
        }

        public void afterLoad(LifecycleEvent ev) {
            ++this.load;
        }

        public void afterRefresh(LifecycleEvent ev) {
        }

        public void beforeStore(LifecycleEvent ev) {
            ++this.preStore;
            ++this.store;
        }

        public void afterStore(LifecycleEvent ev) {
            ++this.store;
        }
    }
}

