/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.event.common.apps;

import javax.persistence.Entity;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;

@Entity
public class Duration
implements Cloneable,
PersistenceCapable {
    private String _name;
    private boolean _started;
    private boolean _running;
    private long _startTime;
    private long _stopTime;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openjpa$persistence$event$common$apps$Duration;
    private transient Object pcDetachedState;

    public Duration(String name) {
        this._name = name;
        this._started = false;
        this._running = false;
    }

    public String getName() {
        return Duration.pcGet_name(this);
    }

    public synchronized void start() {
        if (Duration.pcGet_started(this)) {
            throw new RuntimeException("Duration was already started.");
        }
        Duration.pcSet_startTime(this, System.currentTimeMillis());
        Duration.pcSet_started(this, true);
        Duration.pcSet_running(this, true);
    }

    public synchronized void stop() {
        if (!Duration.pcGet_started(this)) {
            throw new RuntimeException("Duration was never started.");
        }
        if (!Duration.pcGet_running(this)) {
            throw new RuntimeException("Duration was already stopped.");
        }
        Duration.pcSet_stopTime(this, System.currentTimeMillis());
        Duration.pcSet_running(this, false);
    }

    protected Object clone() throws CloneNotSupportedException {
        ((Duration)super.clone()).pcStateManager = null;
        return super.clone();
    }

    public synchronized Duration getCurrentDuration() {
        Duration currentDuration;
        if (!Duration.pcGet_started(this)) {
            throw new RuntimeException("Duration was never started.");
        }
        if (!Duration.pcGet_running(this)) {
            throw new RuntimeException("Duration is not running.");
        }
        long now = System.currentTimeMillis();
        try {
            currentDuration = (Duration)this.clone();
        }
        catch (Exception e) {
            currentDuration = new Duration("");
        }
        Duration.pcSet_stopTime(currentDuration, now);
        Duration.pcSet_running(currentDuration, false);
        return currentDuration;
    }

    public synchronized double getDurationAsSeconds() {
        if (!Duration.pcGet_started(this)) {
            throw new RuntimeException("Duration was never started.");
        }
        if (Duration.pcGet_running(this)) {
            Duration snapshot = this.getCurrentDuration();
            return 1000.0 * (double)(Duration.pcGet_stopTime(snapshot) - Duration.pcGet_startTime(snapshot));
        }
        return (double)(Duration.pcGet_stopTime(this) - Duration.pcGet_startTime(this)) / 1000.0;
    }

    public synchronized boolean isRunning() {
        return Duration.pcGet_running(this);
    }

    public synchronized boolean wasStarted() {
        return Duration.pcGet_started(this);
    }

    public String toString() {
        double time = 0.0;
        StringBuffer buf = new StringBuffer(256);
        if (this.wasStarted()) {
            if (this.isRunning()) {
                Duration snapshot = this.getCurrentDuration();
                time = snapshot.getDurationAsSeconds();
            } else {
                time = this.getDurationAsSeconds();
            }
            buf.append("Duration for '" + Duration.pcGet_name(this) + "' is " + time + " (s).");
        } else {
            buf.append("Duration for '" + Duration.pcGet_name(this) + "' has not yet been started.");
        }
        return buf.toString();
    }

    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    public Duration() {
    }

    static {
        pcFieldNames = new String[]{"_name", "_running", "_startTime", "_started", "_stopTime"};
        Class[] classArray = new Class[5];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Duration.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = Boolean.TYPE;
        classArray[2] = Long.TYPE;
        classArray[3] = Boolean.TYPE;
        classArray[4] = Long.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26};
        Class clazz2 = class$Lorg$apache$openjpa$persistence$event$common$apps$Duration != null ? class$Lorg$apache$openjpa$persistence$event$common$apps$Duration : (class$Lorg$apache$openjpa$persistence$event$common$apps$Duration = Duration.class$("org.apache.openjpa.persistence.event.common.apps.Duration"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Duration", (PersistenceCapable)new Duration());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._name = null;
        this._running = false;
        this._startTime = 0L;
        this._started = false;
        this._stopTime = 0L;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Duration duration = new Duration();
        if (bl) {
            duration.pcClearFields();
        }
        duration.pcStateManager = stateManager;
        duration.pcCopyKeyFieldsFromObjectId(object);
        return duration;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Duration duration = new Duration();
        if (bl) {
            duration.pcClearFields();
        }
        duration.pcStateManager = stateManager;
        return duration;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._running = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._startTime = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._started = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this._stopTime = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._name);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this._running);
                return;
            }
            case 2: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this._startTime);
                return;
            }
            case 3: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this._started);
                return;
            }
            case 4: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this._stopTime);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Duration duration, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._name = duration._name;
                return;
            }
            case 1: {
                this._running = duration._running;
                return;
            }
            case 2: {
                this._startTime = duration._startTime;
                return;
            }
            case 3: {
                this._started = duration._started;
                return;
            }
            case 4: {
                this._stopTime = duration._stopTime;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        Duration duration = (Duration)object;
        if (duration.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(duration, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
    }

    public Object pcNewObjectIdInstance() {
        return null;
    }

    public Object pcNewObjectIdInstance(Object object) {
        return null;
    }

    private static final String pcGet_name(Duration duration) {
        if (duration.pcStateManager == null) {
            return duration._name;
        }
        int n = pcInheritedFieldCount + 0;
        duration.pcStateManager.accessingField(n);
        return duration._name;
    }

    private static final void pcSet_name(Duration duration, String string) {
        if (duration.pcStateManager == null) {
            duration._name = string;
            return;
        }
        duration.pcStateManager.settingStringField((PersistenceCapable)duration, pcInheritedFieldCount + 0, duration._name, string, 0);
    }

    private static final boolean pcGet_running(Duration duration) {
        if (duration.pcStateManager == null) {
            return duration._running;
        }
        int n = pcInheritedFieldCount + 1;
        duration.pcStateManager.accessingField(n);
        return duration._running;
    }

    private static final void pcSet_running(Duration duration, boolean bl) {
        if (duration.pcStateManager == null) {
            duration._running = bl;
            return;
        }
        duration.pcStateManager.settingBooleanField((PersistenceCapable)duration, pcInheritedFieldCount + 1, duration._running, bl, 0);
    }

    private static final long pcGet_startTime(Duration duration) {
        if (duration.pcStateManager == null) {
            return duration._startTime;
        }
        int n = pcInheritedFieldCount + 2;
        duration.pcStateManager.accessingField(n);
        return duration._startTime;
    }

    private static final void pcSet_startTime(Duration duration, long l) {
        if (duration.pcStateManager == null) {
            duration._startTime = l;
            return;
        }
        duration.pcStateManager.settingLongField((PersistenceCapable)duration, pcInheritedFieldCount + 2, duration._startTime, l, 0);
    }

    private static final boolean pcGet_started(Duration duration) {
        if (duration.pcStateManager == null) {
            return duration._started;
        }
        int n = pcInheritedFieldCount + 3;
        duration.pcStateManager.accessingField(n);
        return duration._started;
    }

    private static final void pcSet_started(Duration duration, boolean bl) {
        if (duration.pcStateManager == null) {
            duration._started = bl;
            return;
        }
        duration.pcStateManager.settingBooleanField((PersistenceCapable)duration, pcInheritedFieldCount + 3, duration._started, bl, 0);
    }

    private static final long pcGet_stopTime(Duration duration) {
        if (duration.pcStateManager == null) {
            return duration._stopTime;
        }
        int n = pcInheritedFieldCount + 4;
        duration.pcStateManager.accessingField(n);
        return duration._stopTime;
    }

    private static final void pcSet_stopTime(Duration duration, long l) {
        if (duration.pcStateManager == null) {
            duration._stopTime = l;
            return;
        }
        duration.pcStateManager.settingLongField((PersistenceCapable)duration, pcInheritedFieldCount + 4, duration._stopTime, l, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

