/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.RollbackException;
import org.apache.openjpa.lib.log.AbstractLog;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.exception.PObject;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestParameterLogging
extends AbstractPersistenceTestCase
implements LogFactory {
    String _regex = ".*params=.*1,.*]";
    private static final String ID = Integer.toString(Integer.MIN_VALUE);
    private static List<String> messages = new ArrayList<String>();

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        messages.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RollbackException getRollbackException(Object ... props) {
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(props);
        EntityManager em = emf.createEntityManager();
        EntityTransaction tran = em.getTransaction();
        PObject p1 = new PObject();
        PObject p2 = new PObject();
        p1.setId(1L);
        p2.setId(1L);
        try {
            tran.begin();
            em.persist((Object)p1);
            em.persist((Object)p2);
            tran.commit();
            em.close();
            TestParameterLogging.fail((String)"Expected a RollbackException");
            RollbackException rollbackException = null;
            return rollbackException;
        }
        catch (RollbackException re) {
            RollbackException rollbackException = re;
            return rollbackException;
        }
        finally {
            if (tran.isActive()) {
                tran.rollback();
            }
            this.closeEM(em);
            this.closeEMF((EntityManagerFactory)emf);
        }
    }

    public void testNoParamsByDefault() {
        RollbackException e = this.getRollbackException(PObject.class, CLEAR_TABLES);
        TestParameterLogging.assertFalse((boolean)Pattern.matches(this._regex, e.toString()));
        for (Throwable nested = e.getCause(); nested != null; nested = nested.getCause()) {
            if (!Pattern.matches(".*INSERT.*", nested.toString())) continue;
            TestParameterLogging.assertFalse((boolean)Pattern.matches(this._regex, nested.toString()));
        }
    }

    public void testParamsEnabledByConfig() {
        Throwable nested;
        RollbackException e = this.getRollbackException(PObject.class, CLEAR_TABLES, "openjpa.ConnectionFactoryProperties", "PrintParameters=true");
        TestParameterLogging.assertFalse((boolean)Pattern.matches(this._regex, e.toString()));
        TestParameterLogging.assertNotNull((Object)nested);
        for (nested = e.getCause(); nested != null; nested = nested.getCause()) {
            if (!Pattern.matches(".*INSERT.*", nested.toString())) continue;
            TestParameterLogging.assertTrue((boolean)Pattern.matches(this._regex, nested.toString()));
        }
    }

    public void testDefaultPrintParameters() {
        this.queryCachePrintParametersLogic(null);
    }

    public void testPrintParametersTrue() {
        this.queryCachePrintParametersLogic(true);
    }

    public void testPrintParametersFalse() {
        this.queryCachePrintParametersLogic(false);
    }

    private void queryCachePrintParametersLogic(Boolean printParameters) {
        Object[] props = null;
        props = printParameters == null ? new Object[]{PObject.class, CLEAR_TABLES, "openjpa.DataCache", "true", "openjpa.Log", "org.apache.openjpa.persistence.exception.TestParameterLogging"} : new Object[]{PObject.class, CLEAR_TABLES, "openjpa.DataCache", "true", "openjpa.Log", "org.apache.openjpa.persistence.exception.TestParameterLogging", "openjpa.ConnectionFactoryProperties", "PrintParameters=" + printParameters};
        OpenJPAEntityManagerFactorySPI emf = this.createEMF(props);
        EntityManager em = emf.createEntityManager();
        String queryStr = "SELECT c FROM PObject c WHERE c.id=:id";
        em.createQuery(queryStr).setParameter("id", (Object)Integer.MIN_VALUE).getResultList();
        em.createQuery(queryStr).setParameter("id", (Object)Integer.MIN_VALUE).getResultList();
        boolean expected = printParameters == null ? false : printParameters;
        boolean actual = false;
        for (String s : messages) {
            actual |= s.contains(ID);
        }
        TestParameterLogging.assertEquals((boolean)expected, (boolean)actual);
    }

    public Log getLog(String channel) {
        return new AbstractLog(){

            protected boolean isEnabled(short logLevel) {
                return true;
            }

            public void trace(Object message) {
                messages.add(message.toString());
            }

            protected void log(short type, String message, Throwable t) {
                messages.add(message);
            }

            public void error(Object message) {
                messages.add(message.toString());
            }

            public void warn(Object message) {
                super.warn((Object)message.toString());
            }

            public void info(Object message) {
                messages.add(message.toString());
            }
        };
    }
}

