/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.external;

import java.util.Iterator;
import java.util.List;
import javax.persistence.Query;
import junit.framework.Assert;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.RollbackException;
import org.apache.openjpa.persistence.external.EntityA;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestExternalValues
extends SingleEMFTestCase {
    @Override
    public void setUp() {
        super.setUp(DROP_TABLES, EntityA.class);
    }

    public void testExternalValues() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        EntityA entity = new EntityA();
        entity.setS1("SMALL");
        entity.setS2("MEDIUM");
        entity.setUseStreaming(true);
        em.persist((Object)entity);
        em.getTransaction().commit();
        Query q = em.createQuery("SELECT a from EntityA a");
        EntityA aPrime = (EntityA)q.getSingleResult();
        Assert.assertEquals((String)"SMALL", (String)aPrime.getS1());
        Assert.assertEquals((String)"MEDIUM", (String)aPrime.getS2());
        Assert.assertEquals((boolean)true, (boolean)aPrime.getUseStreaming());
        em.getTransaction().begin();
        entity = new EntityA();
        entity.setS1("LARGE");
        entity.setS2("LARGE");
        entity.setUseStreaming(false);
        em.persist((Object)entity);
        em.getTransaction().commit();
        q = em.createQuery("SELECT t0.id, t0.s1, t0._useStreaming, t0.s2 FROM EntityA t0 ORDER BY t0.s1 DESC");
        List res = q.getResultList();
        Iterator itr = res.iterator();
        Object[] values = (Object[])itr.next();
        Assert.assertEquals((Object)"SMALL", (Object)values[1]);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)values[2]);
        Assert.assertEquals((Object)"MEDIUM", (Object)values[3]);
        values = (Object[])itr.next();
        Assert.assertEquals((Object)"LARGE", (Object)values[1]);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)values[2]);
        Assert.assertEquals((Object)"LARGE", (Object)values[3]);
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnrecognizedExternalValue() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        em.getTransaction().begin();
        EntityA entity = new EntityA();
        entity.setS1("ABDEF");
        entity.setS2("NOT_VALID");
        em.persist((Object)entity);
        try {
            em.getTransaction().commit();
            TestExternalValues.fail((String)"Expected an exception at commit time");
        }
        catch (RollbackException e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            TestExternalValues.assertTrue((boolean)t.getMessage().contains("was not found in the list of ExternalValues"));
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
        }
        em.close();
    }
}

