/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.fetchgroups;

import java.util.HashSet;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.fetchgroups.FGAddress;
import org.apache.openjpa.persistence.fetchgroups.FGDepartment;
import org.apache.openjpa.persistence.fetchgroups.FGEmployee;
import org.apache.openjpa.persistence.fetchgroups.FGManager;
import org.apache.openjpa.persistence.test.SingleEMTestCase;

public class TestFetchGroups
extends SingleEMTestCase {
    private static final int empPerMgr = 5;
    private static final int mgrCount = 3;
    private static final int empCount = 15;
    private HashSet<FGEmployee> employeeSet = new HashSet();
    private HashSet<FGManager> managerSet = new HashSet();
    private static final String empDescriptionFieldStr = "org.apache.openjpa.persistence.fetchgroups.FGEmployee.description";

    @Override
    public void setUp() {
        super.setUp(CLEAR_TABLES, FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class);
        this.createEmployeeData();
    }

    public void testNoDefaultGroupLazyLoad() {
        FGEmployee emp = this.employeeSet.iterator().next();
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FGEmployee e = (FGEmployee)em.find(FGEmployee.class, (Object)emp.getId());
        TestFetchGroups.assertEquals((String)emp.getFirstName(), (String)e.getFirstName());
        em.clear();
        em.getFetchPlan().resetFetchGroups().removeFetchGroup("default").addFetchGroups(new String[]{"AddressFetchGroup"});
        FGEmployee e2 = (FGEmployee)em.find(FGEmployee.class, (Object)emp.getId());
        em.clear();
        TestFetchGroups.assertNull((Object)e2.getFirstName());
        FGEmployee e3 = (FGEmployee)em.find(FGEmployee.class, (Object)emp.getId());
        TestFetchGroups.assertEquals((String)emp.getFirstName(), (String)e3.getFirstName());
        em.close();
    }

    public void testDefaultFetchPlan001() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.close();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
    }

    public void testDefaultFetchPlan002() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.close();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
    }

    public void testDefaultFetchPlan003() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        fp.addField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.close();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
    }

    public void testPctxDefaultFetchPlan001() {
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF(this.getPersistenceUnitName(), FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class, "openjpa.FetchGroups", "default,DescFetchGroup");
        OpenJPAEntityManager em = emf2.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.close();
        emf2.close();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
    }

    public void testPctxDefaultFetchPlan002() {
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF(this.getPersistenceUnitName(), FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class, "openjpa.FetchGroups", "Default,DescFetchGroup");
        OpenJPAEntityManager em = emf2.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("Default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.close();
        emf2.close();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertNull((Object)findMgr.getFirstName());
        TestFetchGroups.assertNull((Object)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
    }

    public void testClearFetchGroups001() {
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF(this.getPersistenceUnitName(), FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class, "openjpa.FetchGroups", "Default,DescFetchGroup");
        OpenJPAEntityManager em = emf2.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("Default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.close();
        emf2.close();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
    }

    public void testResetFetchGroups001() {
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF(this.getPersistenceUnitName(), FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class, "openjpa.FetchGroups", "Default,DescFetchGroup");
        OpenJPAEntityManager em = emf2.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("Default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        fp.resetFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("Default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.close();
        emf2.close();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
    }

    public void testFinderCache001() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        em.close();
    }

    public void testFinderCache002() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.resetFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        em.close();
    }

    public void testFinderCache003() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.resetFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        em.close();
    }

    public void testFinderCache004() {
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF(this.getPersistenceUnitName(), FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class, "openjpa.FetchGroups", "default,DescFetchGroup");
        OpenJPAEntityManager em = emf2.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.resetFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        em.close();
        emf2.close();
    }

    public void testFinderCache005() {
        OpenJPAEntityManagerFactorySPI emf2 = this.createNamedEMF(this.getPersistenceUnitName(), FGManager.class, FGDepartment.class, FGEmployee.class, FGAddress.class, "openjpa.FetchGroups", "default,DescFetchGroup");
        OpenJPAEntityManager em = emf2.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.resetFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)2, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeFetchGroup("DescFetchGroup");
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        em.close();
        emf2.close();
    }

    public void testFinderCache006() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.resetFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.clearFields();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        em.close();
    }

    public void testFinderCache007() {
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        FetchPlan fp = em.getFetchPlan();
        TestFetchGroups.assertNotNull((Object)fp);
        fp.addField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        FetchConfiguration fetchCfg = ((EntityManagerImpl)em).getBroker().getFetchConfiguration();
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        FGManager mgr = this.managerSet.iterator().next();
        TestFetchGroups.assertNotNull((Object)mgr);
        FGManager findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.removeField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        fp.addField(empDescriptionFieldStr);
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.resetFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFetchGroups().contains("DescFetchGroup"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.clearFetchGroups();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertTrue((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertFalse((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertEquals((String)mgr.getDescription(), (String)findMgr.getDescription());
        fp.clearFields();
        TestFetchGroups.assertNotNull((Object)fp.getFetchGroups());
        TestFetchGroups.assertEquals((int)1, (int)fp.getFetchGroups().size());
        TestFetchGroups.assertTrue((boolean)fp.getFetchGroups().contains("default"));
        TestFetchGroups.assertFalse((boolean)fp.getFields().contains(empDescriptionFieldStr));
        TestFetchGroups.assertTrue((boolean)fetchCfg.isDefaultPUFetchGroupConfigurationOnly());
        findMgr = (FGManager)em.find(FGManager.class, (Object)mgr.getId());
        em.clear();
        TestFetchGroups.assertEquals((int)mgr.getId(), (int)findMgr.getId());
        TestFetchGroups.assertEquals((String)mgr.getFirstName(), (String)findMgr.getFirstName());
        TestFetchGroups.assertEquals((String)mgr.getLastName(), (String)findMgr.getLastName());
        TestFetchGroups.assertNull((Object)findMgr.getDescription());
        em.close();
    }

    private void createEmployeeData() {
        int id;
        int i;
        OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
        this.employeeSet.clear();
        this.managerSet.clear();
        int empIdIndex = 1;
        em.getTransaction().begin();
        for (i = 1; i < 3; ++i) {
            id = empIdIndex++;
            FGAddress addr = this.createAddress(id);
            em.persist((Object)addr);
            FGDepartment dept = this.createDepartment(id);
            em.persist((Object)dept);
            FGManager mgr = new FGManager();
            mgr.setId(id);
            mgr.setFirstName("First-" + id);
            mgr.setLastName("Last-" + id);
            mgr.setMData("MData-" + id);
            mgr.setRating("Rating-" + id);
            mgr.setDescription("Manager-" + id);
            mgr.setAddress(addr);
            mgr.setDept(dept);
            em.persist((Object)mgr);
            this.managerSet.add(mgr);
        }
        for (i = 1; i < 15; ++i) {
            id = empIdIndex++;
            int mgrId = id % 5 + 1;
            FGAddress addr = this.createAddress(id);
            em.persist((Object)addr);
            FGDepartment dept = this.createDepartment(id);
            em.persist((Object)dept);
            FGEmployee emp = new FGEmployee();
            emp.setId(id);
            emp.setFirstName("First-" + id);
            emp.setLastName("Last-" + id);
            emp.setRating("Rating-" + id);
            emp.setDescription("Employee-" + id);
            emp.setAddress(addr);
            emp.setDept(dept);
            em.persist((Object)emp);
            this.employeeSet.add(emp);
        }
        em.getTransaction().commit();
        em.close();
    }

    private FGAddress createAddress(int id) {
        FGAddress addr = new FGAddress();
        addr.setId(id);
        addr.setStreet("Street-" + id);
        addr.setCity("City-" + id);
        addr.setState("State-" + id);
        addr.setZip(id);
        return addr;
    }

    private FGDepartment createDepartment(int id) {
        FGDepartment dept = new FGDepartment();
        dept.setId(id);
        dept.setName("Department-" + id);
        return dept;
    }
}

